/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.brands;

import com.okta.sdk.resource.brands.EmailTemplate;
import com.okta.sdk.resource.brands.EmailTemplateContent;
import com.okta.sdk.resource.brands.EmailTemplateCustomization;
import com.okta.sdk.resource.brands.EmailTemplateCustomizationList;
import com.okta.sdk.resource.brands.EmailTemplateCustomizationRequest;
import com.okta.sdk.resource.brands.EmailTemplateTestRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * EmailTemplate
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2022-04-28T13:49:19.036-05:00")
public interface EmailTemplate extends ExtensibleResource {

    Map<String, Object> getLinks();

    String getName();


    /**
    * Delete Email Customization
    * Delete an email customization
    * @param brandId  (required)
    * @param templateName  (required)
    * @param customizationId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "DELETE - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}")
    void deleteEmailTemplateCustomization(String brandId, String templateName, String customizationId);


    /**
    * Get Preview of Email Template Default Content
    * Send a test email to the current users primary and secondary email addresses. The email content is selected based on the following priority: An email customization specifically for the users locale. The default language of email customizations. The email templates default content.
    * @param brandId  (required)
    * @param templateName  (required)
    * @param customization  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/brands/{brandId}/templates/email/{templateName}/test")
    void sendTestEmail(String brandId, String templateName, EmailTemplateTestRequest customization);


    /**
    * Get Email Template Customization
    * Fetch an email customization by id.
    * @param brandId  (required)
    * @param templateName  (required)
    * @param customizationId  (required)
    * @return EmailTemplateCustomization
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}")
    EmailTemplateCustomization getEmailTemplateCustomization(String brandId, String templateName, String customizationId);


    /**
    * Get Preview Content of Email Customization
    * Get a preview of an email template customization.
    * @param brandId  (required)
    * @param templateName  (required)
    * @param customizationId  (required)
    * @return EmailTemplateContent
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}/preview")
    EmailTemplateContent getEmailTemplateCustomizationPreview(String brandId, String templateName, String customizationId);


    /**
    * Create Email Template Customization
    * Create an email customization
    * @param brandId  (required)
    * @param templateName  (required)
    * @param customization  (required)
    * @return EmailTemplateCustomization
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations")
    EmailTemplateCustomization createEmailTemplateCustomization(String brandId, String templateName, EmailTemplateCustomizationRequest customization);


    /**
    * Get Preview of Email Template Default Content
    * Fetch a preview of an email template&#39;s default content by populating velocity references with the current user&#39;s environment.
    * @param brandId  (required)
    * @param templateName  (required)
    * @return EmailTemplateContent
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/brands/{brandId}/templates/email/{templateName}/default-content/preview")
    EmailTemplateContent getEmailTemplateDefaultContentPreview(String brandId, String templateName);


    /**
    * Delete Email Template Customization
    * Delete all customizations for an email template. Also known as “Reset to Default”.
    * @param brandId  (required)
    * @param templateName  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "DELETE - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations")
    void deleteEmailTemplateCustomizations(String brandId, String templateName);


    /**
    * List Email Template Customization
    * List all email customizations for an email template
    * @param brandId  (required)
    * @param templateName  (required)
    * @return EmailTemplateCustomizationList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations")
    EmailTemplateCustomizationList listEmailTemplateCustomizations(String brandId, String templateName);


    /**
    * Update Email Customization
    * Update an email customization
    * @param brandId  (required)
    * @param templateName  (required)
    * @param customizationId  (required)
    * @param customization  (required)
    * @return EmailTemplateCustomization
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "PUT - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}")
    EmailTemplateCustomization updateEmailTemplateCustomization(String brandId, String templateName, String customizationId, EmailTemplateCustomizationRequest customization);


    /**
    * Get Default Content of Email Template
    * Fetch the default content for an email template.
    * @param brandId  (required)
    * @param templateName  (required)
    * @return EmailTemplateContent
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/brands/{brandId}/templates/email/{templateName}/default-content")
    EmailTemplateContent getEmailTemplateDefaultContent(String brandId, String templateName);


    /**
    * Get Email Template
    * Fetch an email template by templateName
    * @param brandId  (required)
    * @param templateName  (required)
    * @return EmailTemplate
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/brands/{brandId}/templates/email/{templateName}")
    EmailTemplate getEmailTemplate(String brandId, String templateName);


}

