/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.policy;

import com.okta.sdk.resource.policy.Policy;
import com.okta.sdk.resource.policy.PolicyRule;
import com.okta.sdk.resource.policy.PolicyRuleConditions;
import com.okta.sdk.resource.policy.PolicyRuleList;
import com.okta.sdk.resource.policy.PolicyType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * Policy
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2022-04-28T13:49:19.036-05:00")
public interface Policy extends ExtensibleResource, Deletable {

    Map<String, Object> getEmbedded();

    Map<String, Object> getLinks();

    PolicyRuleConditions getConditions();

    Policy setConditions(PolicyRuleConditions conditions);

    Date getCreated();

    String getDescription();

    Policy setDescription(String description);

    String getId();

    Date getLastUpdated();

    String getName();

    Policy setName(String name);

    Integer getPriority();

    Policy setPriority(Integer priority);

    StatusEnum getStatus();

    Policy setStatus(StatusEnum status);

    /**
    * Enum status
    */
    public enum StatusEnum {
        ACTIVE("ACTIVE"),
        
        INACTIVE("INACTIVE");

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
    }

    Boolean getSystem();

    Policy setSystem(Boolean system);

    PolicyType getType();

    Policy setType(PolicyType type);


    /**
    * 
    * Creates a policy rule.
    * @param policyRule  (required)
    * @return PolicyRule
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/policies/{policyId}/rules")
    PolicyRule createRule(PolicyRule policyRule);


    /**
    * 
    * Deactivates a policy.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/policies/{policyId}/lifecycle/deactivate")
    void deactivate();


    /**
    * 
    * Updates a policy.
    * @return Policy
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "PUT - /api/v1/policies/{policyId}")
    Policy update();


    /**
    * 
    * Removes a policy.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "DELETE - /api/v1/policies/{policyId}")
    void delete();


    /**
    * 
    * Activates a policy.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/policies/{policyId}/lifecycle/activate")
    void activate();


    /**
    * 
    * Enumerates all policy rules.
    * @return PolicyRuleList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/policies/{policyId}/rules")
    PolicyRuleList listPolicyRules();


    /**
    * 
    * Gets a policy rule.
    * @param ruleId  (required)
    * @return PolicyRule
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/policies/{policyId}/rules/{ruleId}")
    PolicyRule getPolicyRule(String ruleId);


}

