/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.authorization.server.policy;

import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRule;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRuleActions;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRuleConditions;
import java.util.Date;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * AuthorizationServerPolicyRule
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2022-09-19T13:58:14.532-05:00")
public interface AuthorizationServerPolicyRule extends ExtensibleResource {

    AuthorizationServerPolicyRuleActions getActions();

    AuthorizationServerPolicyRule setActions(AuthorizationServerPolicyRuleActions actions);

    AuthorizationServerPolicyRuleConditions getConditions();

    AuthorizationServerPolicyRule setConditions(AuthorizationServerPolicyRuleConditions conditions);

    Date getCreated();

    String getId();

    Date getLastUpdated();

    String getName();

    AuthorizationServerPolicyRule setName(String name);

    Integer getPriority();

    AuthorizationServerPolicyRule setPriority(Integer priority);

    StatusEnum getStatus();

    AuthorizationServerPolicyRule setStatus(StatusEnum status);

    /**
    * Enum status
    */
    public enum StatusEnum {
        ACTIVE("ACTIVE"),
        
        INACTIVE("INACTIVE");

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
    }

    Boolean getSystem();

    AuthorizationServerPolicyRule setSystem(Boolean system);

    TypeEnum getType();

    AuthorizationServerPolicyRule setType(TypeEnum type);

    /**
    * Enum type
    */
    public enum TypeEnum {
        ACCESS("RESOURCE_ACCESS");

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }
    }


    /**
    * 
    * Updates the configuration of the Policy Rule defined in the specified Custom Authorization Server and Policy.
    * @param authServerId  (required)
    * @return AuthorizationServerPolicyRule
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "PUT - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}")
    AuthorizationServerPolicyRule update(String authServerId);


    /**
    * 
    * Activate Authorization Server Policy Rule
    * @param authServerId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "POST - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/activate")
    void activate(String authServerId);


    /**
    * 
    * Deactivate Authorization Server Policy Rule
    * @param authServerId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "POST - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate")
    void deactivate(String authServerId);


    /**
    * 
    * Deletes a Policy Rule defined in the specified Custom Authorization Server and Policy.
    * @param authServerId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "DELETE - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}")
    void delete(String authServerId);


}

