/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.brand;

import com.okta.sdk.resource.brand.EmailTemplateTouchPointVariant;
import com.okta.sdk.resource.brand.EndUserDashboardTouchPointVariant;
import com.okta.sdk.resource.brand.ErrorPageTouchPointVariant;
import com.okta.sdk.resource.brand.ImageUploadResponse;
import com.okta.sdk.resource.brand.SignInPageTouchPointVariant;
import com.okta.sdk.resource.brand.Theme;
import com.okta.sdk.resource.brand.ThemeResponse;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * Theme
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2022-09-19T13:58:14.532-05:00")
public interface Theme extends ExtensibleResource {

    Map<String, Object> getLinks();

    String getBackgroundImage();

    EmailTemplateTouchPointVariant getEmailTemplateTouchPointVariant();

    Theme setEmailTemplateTouchPointVariant(EmailTemplateTouchPointVariant emailTemplateTouchPointVariant);

    EndUserDashboardTouchPointVariant getEndUserDashboardTouchPointVariant();

    Theme setEndUserDashboardTouchPointVariant(EndUserDashboardTouchPointVariant endUserDashboardTouchPointVariant);

    ErrorPageTouchPointVariant getErrorPageTouchPointVariant();

    Theme setErrorPageTouchPointVariant(ErrorPageTouchPointVariant errorPageTouchPointVariant);

    String getPrimaryColorContrastHex();

    Theme setPrimaryColorContrastHex(String primaryColorContrastHex);

    String getPrimaryColorHex();

    Theme setPrimaryColorHex(String primaryColorHex);

    String getSecondaryColorContrastHex();

    Theme setSecondaryColorContrastHex(String secondaryColorContrastHex);

    String getSecondaryColorHex();

    Theme setSecondaryColorHex(String secondaryColorHex);

    SignInPageTouchPointVariant getSignInPageTouchPointVariant();

    Theme setSignInPageTouchPointVariant(SignInPageTouchPointVariant signInPageTouchPointVariant);


    /**
    * Deletes a Theme favicon. The org then uses the Okta default favicon.
    * Deletes a Theme favicon. The org then uses the Okta default favicon.
    * @param brandId  (required)
    * @param themeId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "DELETE - /api/v1/brands/{brandId}/themes/{themeId}/favicon")
    void deleteBrandThemeFavicon(String brandId, String themeId);


    /**
    * Deletes a Theme logo. The org then uses the Okta default logo.
    * Deletes a Theme logo. The org then uses the Okta default logo.
    * @param brandId  (required)
    * @param themeId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "DELETE - /api/v1/brands/{brandId}/themes/{themeId}/logo")
    void deleteBrandThemeLogo(String brandId, String themeId);


    /**
    * Deletes a Theme background image
    * Deletes a Theme background image
    * @param brandId  (required)
    * @param themeId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "DELETE - /api/v1/brands/{brandId}/themes/{themeId}/background-image")
    void deleteBrandThemeBackgroundImage(String brandId, String themeId);


    /**
    * Updates the favicon for your theme
    * Updates the favicon for your theme
    * @param brandId  (required)
    * @param themeId  (required)
    * @param file  (required)
    * @return ImageUploadResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "POST - /api/v1/brands/{brandId}/themes/{themeId}/favicon")
    ImageUploadResponse updateBrandThemeFavicon(String brandId, String themeId, File file);


    /**
    * Update a themes logo
    * Updates the logo for your Theme
    * @param brandId  (required)
    * @param themeId  (required)
    * @param file  (required)
    * @return ImageUploadResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "POST - /api/v1/brands/{brandId}/themes/{themeId}/logo")
    ImageUploadResponse uploadBrandThemeLogo(String brandId, String themeId, File file);


    /**
    * Updates the background image for your Theme
    * Updates the background image for your Theme
    * @param brandId  (required)
    * @param themeId  (required)
    * @param file  (required)
    * @return ImageUploadResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "POST - /api/v1/brands/{brandId}/themes/{themeId}/background-image")
    ImageUploadResponse updateBrandThemeBackgroundImage(String brandId, String themeId, File file);


    /**
    * Update a theme for a brand
    * Updates a theme for a brand
    * @param brandId  (required)
    * @param themeId  (required)
    * @param theme  (required)
    * @return ThemeResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "PUT - /api/v1/brands/{brandId}/themes/{themeId}")
    ThemeResponse update(String brandId, String themeId, Theme theme);


}

