/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.role;

import com.okta.sdk.resource.role.Subscription;
import com.okta.sdk.resource.role.SubscriptionList;
import com.okta.sdk.resource.role.SubscriptionStatus;
import com.okta.sdk.resource.subscription.NotificationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * Subscription
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2022-09-19T13:58:14.532-05:00")
public interface Subscription extends ExtensibleResource {

    Map<String, Object> getLinks();

    List<String> getChannels();

    Subscription setChannels(List<String> channels);

    NotificationType getNotificationType();

    Subscription setNotificationType(NotificationType notificationType);

    SubscriptionStatus getStatus();

    Subscription setStatus(SubscriptionStatus status);


    /**
    * Get the subscription of a User with a specific notification type
    * Get the subscriptions of a User with a specific notification type. Only gets subscriptions for current user. An AccessDeniedException message is sent if requests are made from other users.
    * @param userId  (required)
    * @param notificationType  (required)
    * @return Subscription
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "GET - /api/v1/users/{userId}/subscriptions/{notificationType}")
    Subscription getUserSubscriptionByNotificationType(String userId, String notificationType);


    /**
    * Subscribe a Custom Role to a specific notification type
    * When roleType Subscribes a Role to a specific notification type. When you change the subscription status of a Role, it overrides the subscription of any individual user of that Role. Else when roleId Subscribes a Custom Role to a specific notification type. When you change the subscription status of a Custom Role, it overrides the subscription of any individual user of that Custom Role.
    * @param roleTypeOrRoleId  (required)
    * @param notificationType  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "POST - /api/v1/roles/{roleTypeOrRoleId}/subscriptions/{notificationType}/subscribe")
    void subscribeRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType);


    /**
    * Subscribe to a specific notification type
    * Subscribes a User to a specific notification type. Only the current User can subscribe to a specific notification type. An AccessDeniedException message is sent if requests are made from other users.
    * @param userId  (required)
    * @param notificationType  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "POST - /api/v1/users/{userId}/subscriptions/{notificationType}/subscribe")
    void subscribeUserSubscriptionByNotificationType(String userId, String notificationType);


    /**
    * List all subscriptions of a Custom Role
    * When roleType List all subscriptions of a Role. Else when roleId List subscriptions of a Custom Role
    * @param roleTypeOrRoleId  (required)
    * @return SubscriptionList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "GET - /api/v1/roles/{roleTypeOrRoleId}/subscriptions")
    SubscriptionList listRoleSubscriptions(String roleTypeOrRoleId);


    /**
    * Unsubscribe a Custom Role from a specific notification type
    * When roleType Unsubscribes a Role from a specific notification type. When you change the subscription status of a Role, it overrides the subscription of any individual user of that Role. Else when roleId Unsubscribes a Custom Role from a specific notification type. When you change the subscription status of a Custom Role, it overrides the subscription of any individual user of that Custom Role.
    * @param roleTypeOrRoleId  (required)
    * @param notificationType  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "POST - /api/v1/roles/{roleTypeOrRoleId}/subscriptions/{notificationType}/unsubscribe")
    void unsubscribeRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType);


    /**
    * Get subscriptions of a Custom Role with a specific notification type
    * When roleType Get subscriptions of a Role with a specific notification type. Else when roleId Get subscription of a Custom Role with a specific notification type.
    * @param roleTypeOrRoleId  (required)
    * @param notificationType  (required)
    * @return Subscription
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "GET - /api/v1/roles/{roleTypeOrRoleId}/subscriptions/{notificationType}")
    Subscription getRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType);


    /**
    * Unsubscribe from a specific notification type
    * Unsubscribes a User from a specific notification type. Only the current User can unsubscribe from a specific notification type. An AccessDeniedException message is sent if requests are made from other users.
    * @param userId  (required)
    * @param notificationType  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "POST - /api/v1/users/{userId}/subscriptions/{notificationType}/unsubscribe")
    void unsubscribeUserSubscriptionByNotificationType(String userId, String notificationType);


    /**
    * List subscriptions of a User
    * List subscriptions of a User. Only lists subscriptions for current user. An AccessDeniedException message is sent if requests are made from other users.
    * @param userId  (required)
    * @return SubscriptionList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-09-19T13:58:14.532-05:00",
            comments = "GET - /api/v1/users/{userId}/subscriptions")
    SubscriptionList listUserSubscriptions(String userId);


}

