/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.http.httpclient;

import com.okta.sdk.impl.http.MediaType;
import com.okta.sdk.impl.http.Request;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.InputStreamEntity;

class RepeatableInputStreamEntity
extends BasicHttpEntity {
    private boolean firstAttempt = true;
    private InputStreamEntity inputStreamEntity;
    private InputStream content;

    RepeatableInputStreamEntity(Request request) {
        this.setChunked(false);
        MediaType contentType = request.getHeaders().getContentType();
        long contentLength = request.getHeaders().getContentLength();
        InputStream body = request.getBody();
        this.inputStreamEntity = new InputStreamEntity(body, contentLength);
        this.inputStreamEntity.setContentType(contentType.getType());
        this.content = body;
        this.setContent(this.content);
        this.setContentType(contentType.getType());
        this.setContentLength(contentLength);
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isRepeatable() {
        return this.content.markSupported() || this.inputStreamEntity.isRepeatable();
    }

    public void writeTo(OutputStream output) throws IOException {
        if (!this.firstAttempt && this.isRepeatable()) {
            this.content.reset();
        }
        this.firstAttempt = false;
        this.inputStreamEntity.writeTo(output);
    }
}

