/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.http.httpclient;

import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.Proxy;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.impl.http.HttpHeaders;
import com.okta.sdk.impl.http.MediaType;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.impl.http.Request;
import com.okta.sdk.impl.http.RequestExecutor;
import com.okta.sdk.impl.http.Response;
import com.okta.sdk.impl.http.RestException;
import com.okta.sdk.impl.http.authc.DefaultRequestAuthenticatorFactory;
import com.okta.sdk.impl.http.authc.RequestAuthenticator;
import com.okta.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.okta.sdk.impl.http.httpclient.HttpClientRequestFactory;
import com.okta.sdk.impl.http.httpclient.Timer;
import com.okta.sdk.impl.http.support.BackoffStrategy;
import com.okta.sdk.impl.http.support.DefaultRequest;
import com.okta.sdk.impl.http.support.DefaultResponse;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequestExecutor
implements RequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestExecutor.class);
    private static final int DEFAULT_MAX_BACKOFF_IN_MILLISECONDS = 20000;
    private static final int DEFAULT_MAX_RETRIES = 4;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 0x3FFFFFFF;
    private static final String MAX_CONNECTIONS_PER_ROUTE_PROPERTY_KEY = "com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.maxPerRoute";
    private static final int MAX_CONNECTIONS_PER_ROUTE;
    private static final int DEFAULT_MAX_CONNECTIONS_TOTAL = Integer.MAX_VALUE;
    private static final String MAX_CONNECTIONS_TOTAL_PROPERTY_KEY = "com.okta.sdk.impl.http.httpclient.HttpClientRequestExecutor.connPoolControl.maxTotal";
    private static final int MAX_CONNECTIONS_TOTAL;
    private int maxRetries = 4;
    private int maxElapsedMillis = 0;
    private final RequestAuthenticator requestAuthenticator;
    private HttpClient httpClient;
    private BackoffStrategy backoffStrategy;
    private HttpClientRequestFactory httpClientRequestFactory;

    public HttpClientRequestExecutor(ClientConfiguration clientConfiguration) {
        this(clientConfiguration.getClientCredentialsResolver().getClientCredentials(), clientConfiguration.getProxy(), clientConfiguration.getAuthenticationScheme(), clientConfiguration.getRequestAuthenticatorFactory(), clientConfiguration.getConnectionTimeout());
        if (clientConfiguration.getRetryMaxElapsed() >= 0) {
            this.maxElapsedMillis = clientConfiguration.getRetryMaxElapsed() * 1000;
        }
        if (clientConfiguration.getRetryMaxAttempts() > 0) {
            this.maxRetries = clientConfiguration.getRetryMaxAttempts();
        }
    }

    @Deprecated
    public HttpClientRequestExecutor(ClientCredentials clientCredentials, Proxy proxy, AuthenticationScheme authenticationScheme, RequestAuthenticatorFactory requestAuthenticatorFactory, Integer connectionTimeout) {
        Assert.notNull((Object)clientCredentials, (String)"clientCredentials argument is required.");
        Assert.isTrue((connectionTimeout >= 0 ? 1 : 0) != 0, (String)"Timeout cannot be a negative number.");
        RequestAuthenticatorFactory factory = requestAuthenticatorFactory != null ? requestAuthenticatorFactory : new DefaultRequestAuthenticatorFactory();
        this.requestAuthenticator = factory.create(authenticationScheme, clientCredentials);
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
        if (MAX_CONNECTIONS_TOTAL >= MAX_CONNECTIONS_PER_ROUTE) {
            connMgr.setDefaultMaxPerRoute(MAX_CONNECTIONS_PER_ROUTE);
            connMgr.setMaxTotal(MAX_CONNECTIONS_TOTAL);
        } else {
            connMgr.setDefaultMaxPerRoute(0x3FFFFFFF);
            connMgr.setMaxTotal(Integer.MAX_VALUE);
            log.warn("{} ({}) is less than {} ({}). Reverting to defaults: connectionMaxTotal ({}) and connectionMaxPerRoute ({}).", new Object[]{MAX_CONNECTIONS_TOTAL_PROPERTY_KEY, MAX_CONNECTIONS_TOTAL, MAX_CONNECTIONS_PER_ROUTE_PROPERTY_KEY, MAX_CONNECTIONS_PER_ROUTE, Integer.MAX_VALUE, 0x3FFFFFFF});
        }
        int connectionTimeoutAsMilliseconds = connectionTimeout * 1000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectionTimeoutAsMilliseconds).setSocketTimeout(connectionTimeoutAsMilliseconds).setRedirectsEnabled(false).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).disableCookieManagement().setDefaultConnectionConfig(connectionConfig).setConnectionManager((HttpClientConnectionManager)connMgr);
        this.httpClientRequestFactory = new HttpClientRequestFactory(requestConfig);
        if (proxy != null) {
            HttpHost httpProxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
            httpClientBuilder.setProxy(httpProxyHost);
            if (proxy.isAuthenticationRequired()) {
                AuthScope authScope = new AuthScope(proxy.getHost(), proxy.getPort());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword());
                BasicCredentialsProvider credentialsProviderProvider = new BasicCredentialsProvider();
                credentialsProviderProvider.setCredentials(authScope, (Credentials)credentials);
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProviderProvider);
            }
        }
        this.httpClient = httpClientBuilder.build();
    }

    @Deprecated
    public int getNumRetries() {
        return this.maxRetries;
    }

    @Deprecated
    public void setNumRetries(int numRetries) {
        this.maxRetries = numRetries;
    }

    public BackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }

    public void setBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response executeRequest(Request request) throws RestException {
        Assert.notNull((Object)request, (String)"Request argument cannot be null.");
        int retryCount = 0;
        URI redirectUri = null;
        HttpEntity entity = null;
        HttpResponse httpResponse = null;
        String requestId = null;
        Timer timer = new Timer();
        QueryString originalQuery = new QueryString();
        originalQuery.putAll((Map)request.getQueryString());
        HttpHeaders originalHeaders = new HttpHeaders();
        originalHeaders.putAll((Map)request.getHeaders());
        while (true) {
            if (redirectUri != null) {
                request = new DefaultRequest(request.getMethod(), redirectUri.toString(), null, null, request.getBody(), request.getHeaders().getContentLength());
            }
            if (retryCount > 0) {
                request.setQueryString(originalQuery);
                request.setHeaders(originalHeaders);
                if (requestId == null) {
                    requestId = this.getRequestId(httpResponse);
                }
            }
            this.requestAuthenticator.authenticate(request);
            HttpRequestBase httpRequest = this.httpClientRequestFactory.createHttpClientRequest(request, entity);
            if (httpRequest instanceof HttpEntityEnclosingRequest) {
                entity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
            }
            try {
                if (retryCount > 0 && redirectUri == null) {
                    try {
                        this.pauseBeforeRetry(retryCount, httpResponse, timer.split());
                    }
                    catch (RestException e) {
                        if (log.isDebugEnabled()) {
                            log.warn("Unable to pause for retry: {}", (Object)e.getMessage(), (Object)e);
                        } else {
                            log.warn("Unable to pause for retry: {}", (Object)e.getMessage());
                        }
                        Response response = this.toSdkResponse(httpResponse);
                        try {
                            httpResponse.getEntity().getContent().close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return response;
                    }
                    this.resetStream(entity);
                }
                redirectUri = null;
                this.setOktaHeaders(request, requestId, ++retryCount);
                httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
                if (this.isRedirect(httpResponse)) {
                    redirectUri = this.getRedirectUri(httpResponse);
                    httpRequest.setURI(redirectUri);
                    continue;
                }
                Response response = this.toSdkResponse(httpResponse);
                if (this.shouldRetry(response, retryCount, timer.split())) continue;
                Response response2 = response;
                return response2;
            }
            catch (Throwable t) {
                log.warn("Unable to execute HTTP request: ", (Object)t.getMessage(), (Object)t);
                if (this.shouldRetry(httpRequest, t, retryCount, timer.split())) continue;
                throw new RestException("Unable to execute HTTP request: " + t.getMessage(), t);
            }
            finally {
                try {
                    httpResponse.getEntity().getContent().close();
                }
                catch (Throwable throwable) {}
                continue;
            }
            break;
        }
    }

    private void resetStream(HttpEntity entity) throws IOException {
        InputStream content;
        if (entity != null && (content = entity.getContent()).markSupported()) {
            content.reset();
        }
    }

    private void setOktaHeaders(Request request, String requestId, int retryCount) {
        if (Strings.hasText((String)requestId)) {
            request.getHeaders().add("X-Okta-Retry-For", requestId);
        }
        if (retryCount > 1) {
            request.getHeaders().add("X-Okta-Retry-Count", Integer.toString(retryCount));
        }
    }

    private String getRequestId(HttpResponse httpResponse) {
        if (httpResponse != null) {
            return this.getHeaderValue(httpResponse.getFirstHeader("X-Okta-Request-Id"));
        }
        return null;
    }

    private String getOnlySingleHeaderValue(HttpResponse response, String name) {
        Header[] headers = response.getHeaders(name);
        if (headers == null || headers.length != 1) {
            return null;
        }
        return headers[0].getValue();
    }

    private String getHeaderValue(Header header) {
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    private boolean isRedirect(HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return (status == 301 || status == 302 || status == 307) && response.getHeaders("Location") != null && response.getHeaders("Location").length > 0;
    }

    private URI getRedirectUri(HttpResponse httpResponse) {
        Header[] locationHeaders = httpResponse.getHeaders("Location");
        String location = locationHeaders[0].getValue();
        log.debug("Redirecting to: {}", (Object)location);
        return URI.create(location);
    }

    private void pauseBeforeRetry(int retries, HttpResponse httpResponse, long timeElapsed) throws RestException {
        long delay = -1L;
        long timeElapsedLeft = (long)this.maxElapsedMillis - timeElapsed;
        if (!this.shouldRetry(retries, timeElapsed)) {
            throw this.failedToRetry();
        }
        if (this.backoffStrategy != null) {
            delay = Math.min(this.backoffStrategy.getDelayMillis(retries), timeElapsedLeft);
        } else if (httpResponse != null && httpResponse.getStatusLine().getStatusCode() == 429) {
            delay = this.get429DelayMillis(httpResponse);
            if (!this.shouldRetry(retries, timeElapsed + delay)) {
                throw this.failedToRetry();
            }
            log.debug("429 detected, will retry in {}ms, attempt number: {}", (Object)delay, (Object)retries);
        }
        if (delay < 0L) {
            delay = Math.min(this.getDefaultDelayMillis(retries), timeElapsedLeft);
        }
        if (delay < 0L) {
            throw this.failedToRetry();
        }
        log.debug("Retryable condition detected, will retry in {}ms, attempt number: {}", (Object)delay, (Object)retries);
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RestException(e.getMessage(), (Throwable)e);
        }
    }

    private RestException failedToRetry() {
        return new RestException("Cannot retry request, next request will exceed retry configuration.");
    }

    private long get429DelayMillis(HttpResponse httpResponse) {
        String resetLimit = this.getOnlySingleHeaderValue(httpResponse, "X-Rate-Limit-Reset");
        if (resetLimit == null || !resetLimit.chars().allMatch(Character::isDigit)) {
            return -1L;
        }
        Date requestDate = this.dateFromHeader(httpResponse);
        if (requestDate == null) {
            return -1L;
        }
        long waitUntil = Long.parseLong(resetLimit) * 1000L;
        long requestTime = requestDate.getTime();
        long delay = waitUntil - requestTime + 1000L;
        log.debug("429 wait: {} - {} + {} = {}", new Object[]{waitUntil, requestTime, 1000, delay});
        return delay;
    }

    private Date dateFromHeader(HttpResponse httpResponse) {
        Date result = null;
        Header dateHeader = httpResponse.getFirstHeader("Date");
        if (dateHeader != null) {
            result = DateUtils.parseDate((String)dateHeader.getValue());
        }
        return result;
    }

    private long getDefaultDelayMillis(int retries) {
        long scaleFactor = 300L;
        long result = (long)(Math.pow(2.0, retries) * (double)scaleFactor);
        return Math.min(result, 20000L);
    }

    private boolean shouldRetry(HttpRequestBase method, Throwable t, int retryCount, long timeElapsed) {
        HttpEntity entity;
        if (!this.shouldRetry(retryCount, timeElapsed)) {
            return false;
        }
        if (method instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)method).getEntity()) != null && !entity.isRepeatable()) {
            return false;
        }
        if (t instanceof NoHttpResponseException || t instanceof SocketException || t instanceof SocketTimeoutException || t instanceof ConnectTimeoutException) {
            log.debug("Retrying on {}: {}", (Object)t.getClass().getName(), (Object)t.getMessage());
            return true;
        }
        return false;
    }

    private boolean shouldRetry(int retryCount, long timeElapsed) {
        return !(this.maxRetries <= 0 && this.maxElapsedMillis <= 0 || this.maxRetries > 0 && retryCount > this.maxRetries || this.maxElapsedMillis > 0 && timeElapsed >= (long)this.maxElapsedMillis);
    }

    private boolean shouldRetry(Response response, int retryCount, long timeElapsed) {
        int httpStatus = response.getHttpStatus();
        return this.shouldRetry(retryCount, timeElapsed) && (httpStatus == 429 || httpStatus == 503 || httpStatus == 504);
    }

    protected byte[] toBytes(HttpEntity entity) throws IOException {
        return EntityUtils.toByteArray((HttpEntity)entity);
    }

    protected Response toSdkResponse(HttpResponse httpResponse) throws IOException {
        long contentLength;
        int httpStatus = httpResponse.getStatusLine().getStatusCode();
        HttpHeaders headers = this.getHeaders(httpResponse);
        MediaType mediaType = headers.getContentType();
        HttpEntity entity = this.getHttpEntity(httpResponse);
        InputStream body = entity != null ? entity.getContent() : null;
        long l = contentLength = entity != null ? entity.getContentLength() : -1L;
        if (body != null) {
            byte[] bytes = this.toBytes(entity);
            body = bytes != null ? new ByteArrayInputStream(bytes) : null;
        }
        DefaultResponse response = new DefaultResponse(httpStatus, mediaType, body, contentLength);
        response.getHeaders().add("Okta-Request-Id", headers.getOktaRequestId());
        response.getHeaders().put("Link", headers.getLinkHeaders());
        return response;
    }

    private HttpEntity getHttpEntity(HttpResponse response) {
        Header contentEncodingHeader;
        HttpEntity entity = response.getEntity();
        if (entity != null && (contentEncodingHeader = entity.getContentEncoding()) != null) {
            for (HeaderElement element : contentEncodingHeader.getElements()) {
                if (!element.getName().equalsIgnoreCase("gzip")) continue;
                return new GzipDecompressingEntity(response.getEntity());
            }
        }
        return entity;
    }

    private HttpHeaders getHeaders(HttpResponse response) {
        HttpHeaders headers = new HttpHeaders();
        Header[] httpHeaders = response.getAllHeaders();
        if (httpHeaders != null) {
            for (Header httpHeader : httpHeaders) {
                headers.add(httpHeader.getName(), httpHeader.getValue());
            }
        }
        return headers;
    }

    static {
        int connectionMaxPerRoute = 0x3FFFFFFF;
        String connectionMaxPerRouteString = System.getProperty(MAX_CONNECTIONS_PER_ROUTE_PROPERTY_KEY);
        if (connectionMaxPerRouteString != null) {
            try {
                connectionMaxPerRoute = Integer.parseInt(connectionMaxPerRouteString);
            }
            catch (NumberFormatException nfe) {
                log.warn("Bad max connection per route value: {}. Using default: {}.", new Object[]{connectionMaxPerRouteString, 0x3FFFFFFF, nfe});
            }
        }
        MAX_CONNECTIONS_PER_ROUTE = connectionMaxPerRoute;
        int connectionMaxTotal = Integer.MAX_VALUE;
        String connectionMaxTotalString = System.getProperty(MAX_CONNECTIONS_TOTAL_PROPERTY_KEY);
        if (connectionMaxTotalString != null) {
            try {
                connectionMaxTotal = Integer.parseInt(connectionMaxTotalString);
            }
            catch (NumberFormatException nfe) {
                log.warn("Bad max connection total value: {}. Using default: {}.", new Object[]{connectionMaxTotalString, Integer.MAX_VALUE, nfe});
            }
        }
        MAX_CONNECTIONS_TOTAL = connectionMaxTotal;
    }
}

