/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 0.11.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.application;

import com.okta.sdk.resource.application.AppUser;
import com.okta.sdk.resource.application.AppUserList;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationAccessibility;
import com.okta.sdk.resource.application.ApplicationCredentials;
import com.okta.sdk.resource.application.ApplicationGroupAssignment;
import com.okta.sdk.resource.application.ApplicationGroupAssignmentList;
import com.okta.sdk.resource.application.ApplicationLicensing;
import com.okta.sdk.resource.application.ApplicationSettings;
import com.okta.sdk.resource.application.ApplicationSignOnMode;
import com.okta.sdk.resource.application.ApplicationVisibility;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.application.JsonWebKeyList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;



import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.http.QueryString;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;

import java.util.Map;

import static com.okta.sdk.lang.Assert.notNull;
import static com.okta.sdk.lang.Assert.hasText;


/**
 * Application
 */

@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2017-12-14T13:01:44.308-05:00")
public class DefaultApplication extends AbstractInstanceResource<Application> implements Application {

    private final static MapProperty embeddedProperty = new MapProperty("_embedded");
    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static ResourceReference<ApplicationAccessibility> accessibilityProperty = new ResourceReference("accessibility", ApplicationAccessibility.class, false);
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static ResourceReference<ApplicationCredentials> credentialsProperty = new ResourceReference("credentials", ApplicationCredentials.class, false);
    private final static ListProperty featuresProperty = new ListProperty("features");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static StringProperty labelProperty = new StringProperty("label");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static ResourceReference<ApplicationLicensing> licensingProperty = new ResourceReference("licensing", ApplicationLicensing.class, false);
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static ResourceReference<ApplicationSettings> settingsProperty = new ResourceReference("settings", ApplicationSettings.class, false);
    private final static EnumProperty<ApplicationSignOnMode> signOnModeProperty = new EnumProperty("signOnMode", ApplicationSignOnMode.class);
    private final static EnumProperty<StatusEnum> statusProperty = new EnumProperty("status", StatusEnum.class);
    private final static ResourceReference<ApplicationVisibility> visibilityProperty = new ResourceReference("visibility", ApplicationVisibility.class, false);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(embeddedProperty, linksProperty, accessibilityProperty, createdProperty, credentialsProperty, featuresProperty, idProperty, labelProperty, lastUpdatedProperty, licensingProperty, nameProperty, settingsProperty, signOnModeProperty, statusProperty, visibilityProperty);

    public DefaultApplication(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultApplication(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Map<String, Object> getEmbedded() {
        return  getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public ApplicationAccessibility getAccessibility() {
        return  getResourceProperty(accessibilityProperty);
    }

    public Application setAccessibility(ApplicationAccessibility accessibility) {
        setProperty(accessibilityProperty, accessibility);
        return this;
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public ApplicationCredentials getCredentials() {
        return  getResourceProperty(credentialsProperty);
    }

    public Application setCredentials(ApplicationCredentials credentials) {
        setProperty(credentialsProperty, credentials);
        return this;
    }

    public List<String> getFeatures() {
        return (List<String>) getListProperty(featuresProperty);
    }

    public Application setFeatures(List<String> features) {
        setProperty(featuresProperty, features);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public String getLabel() {
        return  getString(labelProperty);
    }

    public Application setLabel(String label) {
        setProperty(labelProperty, label);
        return this;
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public ApplicationLicensing getLicensing() {
        return  getResourceProperty(licensingProperty);
    }

    public Application setLicensing(ApplicationLicensing licensing) {
        setProperty(licensingProperty, licensing);
        return this;
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public ApplicationSettings getSettings() {
        return  getResourceProperty(settingsProperty);
    }

    public Application setSettings(ApplicationSettings settings) {
        setProperty(settingsProperty, settings);
        return this;
    }

    public ApplicationSignOnMode getSignOnMode() {
        return  getEnumProperty(signOnModeProperty);
    }

    public Application setSignOnMode(ApplicationSignOnMode signOnMode) {
        setProperty(signOnModeProperty, signOnMode);
        return this;
    }

    public StatusEnum getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public ApplicationVisibility getVisibility() {
        return  getResourceProperty(visibilityProperty);
    }

    public Application setVisibility(ApplicationVisibility visibility) {
        setProperty(visibilityProperty, visibility);
        return this;
    }


    /**
    * Activate Application
    * Activates an inactive application.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/apps/{appId}/lifecycle/activate")
    public void activate() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        String href = "/api/v1/apps/" + appId + "/lifecycle/activate";
        getDataStore().create(href, new DefaultVoidResource(getDataStore()));

    }


    /**
    * Assign Group to Application
    * Assigns a group to an application
    * @param groupId  (required)
    * @param applicationGroupAssignment  (required)
    * @return ApplicationGroupAssignment
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "PUT - /api/v1/apps/{appId}/groups/{groupId}")
    public ApplicationGroupAssignment createApplicationGroupAssignment(String groupId, ApplicationGroupAssignment applicationGroupAssignment) {

        String appId = getId();

        notNull(applicationGroupAssignment, "'applicationGroupAssignment' is required and cannot be null.");
        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        String href = "/api/v1/apps/" + appId + "/groups/" + groupId + "";

        getDataStore().save(href, applicationGroupAssignment);
        return  applicationGroupAssignment;
    }


    /**
    * Get Assigned Group for Application
    * Fetches an application group assignment
    * @param groupId  (required)
    * @param expand  (optional)
    * @return ApplicationGroupAssignment
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/apps/{appId}/groups/{groupId}")
    public ApplicationGroupAssignment getApplicationGroupAssignment(String groupId, String expand) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (expand != null) queryArgs.put("expand", expand);

        String href = QueryString.buildHref("/api/v1/apps/" + appId + "/groups/" + groupId + "", queryArgs);
        return getDataStore().getResource(href, ApplicationGroupAssignment.class);
    }

    /**
    * Get Assigned Group for Application
    * Fetches an application group assignment
    * @param groupId  (required)
    * @return ApplicationGroupAssignment
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/apps/{appId}/groups/{groupId}")
    public ApplicationGroupAssignment getApplicationGroupAssignment(String groupId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        String href = "/api/v1/apps/" + appId + "/groups/" + groupId + "";
        return getDataStore().getResource(href, ApplicationGroupAssignment.class);
     }


    /**
    * Get Assigned User for Application
    * Fetches a specific user assignment for application by &#x60;id&#x60;.
    * @param userId  (required)
    * @param expand  (optional)
    * @return AppUser
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/apps/{appId}/users/{userId}")
    public AppUser getApplicationUser(String userId, String expand) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (expand != null) queryArgs.put("expand", expand);

        String href = QueryString.buildHref("/api/v1/apps/" + appId + "/users/" + userId + "", queryArgs);
        return getDataStore().getResource(href, AppUser.class);
    }

    /**
    * Get Assigned User for Application
    * Fetches a specific user assignment for application by &#x60;id&#x60;.
    * @param userId  (required)
    * @return AppUser
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/apps/{appId}/users/{userId}")
    public AppUser getApplicationUser(String userId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");
        String href = "/api/v1/apps/" + appId + "/users/" + userId + "";
        return getDataStore().getResource(href, AppUser.class);
     }


    /**
    * Clone Application Key Credential
    * Clones a X.509 certificate for an application key credential from a source application to target application.
    * @param keyId  (required)
    * @param targetAid Unique key of the target Application (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/apps/{appId}/credentials/keys/{keyId}/clone")
    public JsonWebKey cloneApplicationKey(String keyId, String targetAid) {

        String appId = getId();

        notNull(targetAid, "'targetAid' is required and cannot be null.");
        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(keyId, "'keyId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (targetAid != null) queryArgs.put("targetAid", targetAid);

        String href = QueryString.buildHref("/api/v1/apps/" + appId + "/credentials/keys/" + keyId + "/clone", queryArgs);
        return getDataStore().create(href, new DefaultVoidResource(getDataStore()), JsonWebKey.class);

    }


    /**
    * Generate New Application Key Credential
    * Generates a new X.509 certificate for an application key credential
    * @param validityYears expiry of the Application Key Credential (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/apps/{appId}/credentials/keys/generate")
    public JsonWebKey generateApplicationKey(Integer validityYears) {

        String appId = getId();

        notNull(validityYears, "'validityYears' is required and cannot be null.");
        hasText(appId, "'appId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (validityYears != null) queryArgs.put("validityYears", validityYears);

        String href = QueryString.buildHref("/api/v1/apps/" + appId + "/credentials/keys/generate", queryArgs);
        return getDataStore().create(href, new DefaultVoidResource(getDataStore()), JsonWebKey.class);

    }


    /**
    * Deactivate Application
    * Deactivates an active application.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/apps/{appId}/lifecycle/deactivate")
    public void deactivate() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        String href = "/api/v1/apps/" + appId + "/lifecycle/deactivate";
        getDataStore().create(href, new DefaultVoidResource(getDataStore()));

    }


    /**
    * Update Application
    * Updates an application in your organization.
    * @return Application
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "PUT - /api/v1/apps/{appId}")
    public Application update() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        String href = "/api/v1/apps/" + appId + "";
        getDataStore().save(href, this);
        return this;
    }


    /**
    * List Key Credentials for Application
    * Enumerates key credentials for an application
    * @return JsonWebKeyList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/apps/{appId}/credentials/keys")
    public JsonWebKeyList listKeys() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        String href = "/api/v1/apps/" + appId + "/credentials/keys";
        return getDataStore().getResource(href, JsonWebKeyList.class);
    }


    /**
    * List Groups Assigned to Application
    * Enumerates group assignments for an application.
    * @param q  (optional)
    * @param expand  (optional)
    * @return ApplicationGroupAssignmentList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/apps/{appId}/groups")
    public ApplicationGroupAssignmentList listGroupAssignments(String q, String expand) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (q != null) queryArgs.put("q", q);
        if (expand != null) queryArgs.put("expand", expand);

        String href = QueryString.buildHref("/api/v1/apps/" + appId + "/groups", queryArgs);
        return getDataStore().getResource(href, ApplicationGroupAssignmentList.class);
    }

    /**
    * List Groups Assigned to Application
    * Enumerates group assignments for an application.
    * @return ApplicationGroupAssignmentList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/apps/{appId}/groups")
    public ApplicationGroupAssignmentList listGroupAssignments() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        String href = "/api/v1/apps/" + appId + "/groups";
        return getDataStore().getResource(href, ApplicationGroupAssignmentList.class);
     }


    /**
    * List Users Assigned to Application
    * Enumerates all assigned [application users](#application-user-model) for an application.
    * @param q  (optional)
    * @param queryScope  (optional)
    * @param filter  (optional)
    * @param expand  (optional)
    * @return AppUserList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/apps/{appId}/users")
    public AppUserList listApplicationUsers(String q, String queryScope, String filter, String expand) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (q != null) queryArgs.put("q", q);
        if (queryScope != null) queryArgs.put("query_scope", queryScope);
        if (filter != null) queryArgs.put("filter", filter);
        if (expand != null) queryArgs.put("expand", expand);

        String href = QueryString.buildHref("/api/v1/apps/" + appId + "/users", queryArgs);
        return getDataStore().getResource(href, AppUserList.class);
    }

    /**
    * List Users Assigned to Application
    * Enumerates all assigned [application users](#application-user-model) for an application.
    * @return AppUserList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/apps/{appId}/users")
    public AppUserList listApplicationUsers() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        String href = "/api/v1/apps/" + appId + "/users";
        return getDataStore().getResource(href, AppUserList.class);
     }


    /**
    * Get Key Credential for Application
    * Gets a specific [application key credential](#application-key-credential-model) by &#x60;kid&#x60;
    * @param keyId  (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/apps/{appId}/credentials/keys/{keyId}")
    public JsonWebKey getApplicationKey(String keyId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(keyId, "'keyId' is required and cannot be null or empty.");

        String href = "/api/v1/apps/" + appId + "/credentials/keys/" + keyId + "";
        return getDataStore().getResource(href, JsonWebKey.class);
    }


    /**
    * Assign User to Application for SSO &amp; Provisioning
    * Assigns an user to an application with [credentials](#application-user-credentials-object) and an app-specific [profile](#application-user-profile-object). Profile mappings defined for the application are first applied before applying any profile properties specified in the request.
    * @param appUser  (required)
    * @return AppUser
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/apps/{appId}/users")
    public AppUser assignUserToApplication(AppUser appUser) {

        String appId = getId();

        notNull(appUser, "'appUser' is required and cannot be null.");
        hasText(appId, "'appId' is required and cannot be null or empty.");

        String href = "/api/v1/apps/" + appId + "/users";
        getDataStore().create(href, appUser, appUser.getClass());
        return appUser;
    }


    /**
    * Delete Application
    * Removes an inactive application.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "DELETE - /api/v1/apps/{appId}")
    public void delete() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        String href = "/api/v1/apps/" + appId + "";
        getDataStore().delete(href);
    }




}
