/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 0.11.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.group;

import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupProfile;
import com.okta.sdk.resource.user.UserList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;



import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.http.QueryString;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;

import java.util.Map;

import static com.okta.sdk.lang.Assert.notNull;
import static com.okta.sdk.lang.Assert.hasText;


/**
 * Group
 */

@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2017-12-14T13:01:44.308-05:00")
public class DefaultGroup extends AbstractInstanceResource<Group> implements Group {

    private final static MapProperty embeddedProperty = new MapProperty("_embedded");
    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastMembershipUpdatedProperty = new DateProperty("lastMembershipUpdated");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static ListProperty objectClassProperty = new ListProperty("objectClass");
    private final static ResourceReference<GroupProfile> profileProperty = new ResourceReference("profile", GroupProfile.class, true);
    private final static StringProperty typeProperty = new StringProperty("type");

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(embeddedProperty, linksProperty, createdProperty, idProperty, lastMembershipUpdatedProperty, lastUpdatedProperty, objectClassProperty, profileProperty, typeProperty);

    public DefaultGroup(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultGroup(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Map<String, Object> getEmbedded() {
        return  getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastMembershipUpdated() {
        return  getDateProperty(lastMembershipUpdatedProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public List<String> getObjectClass() {
        return (List<String>) getListProperty(objectClassProperty);
    }

    public GroupProfile getProfile() {
        return  getResourceProperty(profileProperty);
    }

    public Group setProfile(GroupProfile profile) {
        setProperty(profileProperty, profile);
        return this;
    }

    public String getType() {
        return  getString(typeProperty);
    }


    /**
    * List Group Members
    * Enumerates all [users](/docs/api/resources/users.html#user-model) that are a member of a group.
    * @return UserList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/groups/{groupId}/users")
    public UserList listUsers() {

        String groupId = getId();

        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        String href = "/api/v1/groups/" + groupId + "/users";
        return getDataStore().getResource(href, UserList.class);
    }


    /**
    * Update Group
    * Updates the profile for a group with &#x60;OKTA_GROUP&#x60; type from your organization.
    * @return Group
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "PUT - /api/v1/groups/{groupId}")
    public Group update() {

        String groupId = getId();

        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        String href = "/api/v1/groups/" + groupId + "";
        getDataStore().save(href, this);
        return this;
    }


    /**
    * Remove Group
    * Removes a group with &#x60;OKTA_GROUP&#x60; type from your organization.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "DELETE - /api/v1/groups/{groupId}")
    public void delete() {

        String groupId = getId();

        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        String href = "/api/v1/groups/" + groupId + "";
        getDataStore().delete(href);
    }


    /**
    * Remove User from Group
    * Removes a [user](users.html#user-model) from a group with &#x60;OKTA_GROUP&#x60; type.
    * @param userId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "DELETE - /api/v1/groups/{groupId}/users/{userId}")
    public void removeUser(String userId) {

        String groupId = getId();

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/groups/" + groupId + "/users/" + userId + "";
        getDataStore().delete(href);
    }




}
