/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 0.11.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.group.rule;

import com.okta.sdk.resource.group.rule.GroupRule;
import com.okta.sdk.resource.group.rule.GroupRuleAction;
import com.okta.sdk.resource.group.rule.GroupRuleConditions;
import com.okta.sdk.resource.group.rule.GroupRuleStatus;
import java.util.Date;



import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.http.QueryString;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;

import java.util.Map;

import static com.okta.sdk.lang.Assert.notNull;
import static com.okta.sdk.lang.Assert.hasText;


/**
 * GroupRule
 */

@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2017-12-14T13:01:44.308-05:00")
public class DefaultGroupRule extends AbstractInstanceResource<GroupRule> implements GroupRule {

    private final static ResourceReference<GroupRuleAction> actionsProperty = new ResourceReference("actions", GroupRuleAction.class, false);
    private final static ResourceReference<GroupRuleConditions> conditionsProperty = new ResourceReference("conditions", GroupRuleConditions.class, false);
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static EnumProperty<GroupRuleStatus> statusProperty = new EnumProperty("status", GroupRuleStatus.class);
    private final static StringProperty typeProperty = new StringProperty("type");

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(actionsProperty, conditionsProperty, createdProperty, idProperty, lastUpdatedProperty, nameProperty, statusProperty, typeProperty);

    public DefaultGroupRule(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultGroupRule(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public GroupRuleAction getActions() {
        return  getResourceProperty(actionsProperty);
    }

    public GroupRule setActions(GroupRuleAction actions) {
        setProperty(actionsProperty, actions);
        return this;
    }

    public GroupRuleConditions getConditions() {
        return  getResourceProperty(conditionsProperty);
    }

    public GroupRule setConditions(GroupRuleConditions conditions) {
        setProperty(conditionsProperty, conditions);
        return this;
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public GroupRule setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public GroupRuleStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public String getType() {
        return  getString(typeProperty);
    }

    public GroupRule setType(String type) {
        setProperty(typeProperty, type);
        return this;
    }


    /**
    * Activate a group Rule
    * Activates a specific group rule by id from your organization
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/groups/rules/{ruleId}/lifecycle/activate")
    public void activate() {

        String ruleId = getId();

        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        String href = "/api/v1/groups/rules/" + ruleId + "/lifecycle/activate";
        getDataStore().create(href, new DefaultVoidResource(getDataStore()));

    }


    /**
    * Delete a group Rule
    * Removes a specific group rule by id from your organization
    * @param removeUsers  (optional)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "DELETE - /api/v1/groups/rules/{ruleId}")
    public void delete(Boolean removeUsers) {

        String ruleId = getId();

        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (removeUsers != null) queryArgs.put("removeUsers", removeUsers);

        String href = QueryString.buildHref("/api/v1/groups/rules/" + ruleId + "", queryArgs);
        getDataStore().delete(href);
    }

    /**
    * Delete a group Rule
    * Removes a specific group rule by id from your organization
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "DELETE - /api/v1/groups/rules/{ruleId}")
    public void delete() {

        String ruleId = getId();

        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");
        String href = "/api/v1/groups/rules/" + ruleId + "";
        getDataStore().delete(href);
     }


    /**
    * Deactivate a group Rule
    * Deactivates a specific group rule by id from your organization
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/groups/rules/{ruleId}/lifecycle/deactivate")
    public void deactivate() {

        String ruleId = getId();

        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        String href = "/api/v1/groups/rules/" + ruleId + "/lifecycle/deactivate";
        getDataStore().create(href, new DefaultVoidResource(getDataStore()));

    }


    /**
    * 
    * 
    * @return GroupRule
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "PUT - /api/v1/groups/rules/{ruleId}")
    public GroupRule update() {

        String ruleId = getId();

        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        String href = "/api/v1/groups/rules/" + ruleId + "";
        getDataStore().save(href, this);
        return this;
    }




}
