/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 0.11.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.user;

import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.user.AppLinkList;
import com.okta.sdk.resource.user.AuthenticationProviderType;
import com.okta.sdk.resource.user.ChangePasswordRequest;
import com.okta.sdk.resource.user.ForgotPasswordResponse;
import com.okta.sdk.resource.user.ResetPasswordToken;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.RoleList;
import com.okta.sdk.resource.user.TempPassword;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserActivationToken;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.UserProfile;
import com.okta.sdk.resource.user.UserStatus;
import com.okta.sdk.resource.user.factor.Factor;
import com.okta.sdk.resource.user.factor.FactorList;
import com.okta.sdk.resource.user.factor.SecurityQuestionList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;



import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.http.QueryString;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;

import java.util.Map;

import static com.okta.sdk.lang.Assert.notNull;
import static com.okta.sdk.lang.Assert.hasText;


/**
 * User
 */

@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2017-12-14T13:01:44.308-05:00")
public class DefaultUser extends AbstractInstanceResource<User> implements User {

    private final static MapProperty embeddedProperty = new MapProperty("_embedded");
    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static DateProperty activatedProperty = new DateProperty("activated");
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static ResourceReference<UserCredentials> credentialsProperty = new ResourceReference("credentials", UserCredentials.class, false);
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastLoginProperty = new DateProperty("lastLogin");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static DateProperty passwordChangedProperty = new DateProperty("passwordChanged");
    private final static ResourceReference<UserProfile> profileProperty = new ResourceReference("profile", UserProfile.class, true);
    private final static EnumProperty<UserStatus> statusProperty = new EnumProperty("status", UserStatus.class);
    private final static DateProperty statusChangedProperty = new DateProperty("statusChanged");
    private final static EnumProperty<UserStatus> transitioningToStatusProperty = new EnumProperty("transitioningToStatus", UserStatus.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(embeddedProperty, linksProperty, activatedProperty, createdProperty, credentialsProperty, idProperty, lastLoginProperty, lastUpdatedProperty, passwordChangedProperty, profileProperty, statusProperty, statusChangedProperty, transitioningToStatusProperty);

    public DefaultUser(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultUser(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Map<String, Object> getEmbedded() {
        return  getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public Date getActivated() {
        return  getDateProperty(activatedProperty);
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public UserCredentials getCredentials() {
        return  getResourceProperty(credentialsProperty);
    }

    public User setCredentials(UserCredentials credentials) {
        setProperty(credentialsProperty, credentials);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastLogin() {
        return  getDateProperty(lastLoginProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public Date getPasswordChanged() {
        return  getDateProperty(passwordChangedProperty);
    }

    public UserProfile getProfile() {
        return  getResourceProperty(profileProperty);
    }

    public User setProfile(UserProfile profile) {
        setProperty(profileProperty, profile);
        return this;
    }

    public UserStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public Date getStatusChanged() {
        return  getDateProperty(statusChangedProperty);
    }

    public UserStatus getTransitioningToStatus() {
        return  getEnumProperty(transitioningToStatusProperty);
    }


    /**
    * Deactivate User
    * Deactivates a user.  This operation can only be performed on users that do not have a &#x60;DEPROVISIONED&#x60; status.  Deactivation of a user is an asynchronous operation.  The user will have the &#x60;transitioningToStatus&#x60; property with a value of &#x60;DEPROVISIONED&#x60; during deactivation to indicate that the user hasn&#39;t completed the asynchronous operation.  The user will have a status of &#x60;DEPROVISIONED&#x60; when the deactivation process is complete.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/deactivate")
    public void deactivate() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/lifecycle/deactivate";
        getDataStore().create(href, new DefaultVoidResource(getDataStore()));

    }


    /**
    * Reset Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password.  The OTT link can be automatically emailed to the user or returned to the API caller and distributed using a custom flow.
    * @param provider  (optional)
    * @param sendEmail  (optional)
    * @return ResetPasswordToken
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/reset_password")
    public ResetPasswordToken resetPassword(String provider, Boolean sendEmail) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (provider != null) queryArgs.put("provider", provider);
        if (sendEmail != null) queryArgs.put("sendEmail", sendEmail);

        String href = QueryString.buildHref("/api/v1/users/" + userId + "/lifecycle/reset_password", queryArgs);
        return getDataStore().create(href, new DefaultVoidResource(getDataStore()), ResetPasswordToken.class);

    }

    /**
    * Reset Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password.  The OTT link can be automatically emailed to the user or returned to the API caller and distributed using a custom flow.
    * @return ResetPasswordToken
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/reset_password")
    public ResetPasswordToken resetPassword() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/lifecycle/reset_password";
        return getDataStore().create(href, new DefaultVoidResource(getDataStore()), ResetPasswordToken.class);

     }


    /**
    * 
    * Enumerates all the enrolled factors for the specified user
    * @return FactorList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/users/{userId}/factors")
    public FactorList listFactors() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/factors";
        return getDataStore().getResource(href, FactorList.class);
    }


    /**
    * 
    * 
    * @param roleId  (required)
    * @return GroupList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/users/{userId}/roles/{roleId}/targets/groups")
    public GroupList listGroupTargetsForRole(String roleId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups";
        return getDataStore().getResource(href, GroupList.class);
    }


    /**
    * Forgot Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password.  The user will be required to validate their security question&#39;s answer when visiting the reset link.  This operation can only be performed on users with a valid [recovery question credential](#recovery-question-object) and have an &#x60;ACTIVE&#x60; status.
    * @param sendEmail  (optional, default to true)
    * @param userCredentials  (optional)
    * @return ForgotPasswordResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/credentials/forgot_password")
    public ForgotPasswordResponse forgotPassword(Boolean sendEmail, UserCredentials userCredentials) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (sendEmail != null) queryArgs.put("sendEmail", sendEmail);

        String href = QueryString.buildHref("/api/v1/users/" + userId + "/credentials/forgot_password", queryArgs);
        return getDataStore().create(href, userCredentials, ForgotPasswordResponse.class);

    }

    /**
    * Forgot Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password.  The user will be required to validate their security question&#39;s answer when visiting the reset link.  This operation can only be performed on users with a valid [recovery question credential](#recovery-question-object) and have an &#x60;ACTIVE&#x60; status.
    * @return ForgotPasswordResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/credentials/forgot_password")
    public ForgotPasswordResponse forgotPassword() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/credentials/forgot_password";
        return getDataStore().create(href, new DefaultVoidResource(getDataStore()), ForgotPasswordResponse.class);
     }


    /**
    * 
    * Unassigns a role from a user.
    * @param roleId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "DELETE - /api/v1/users/{userId}/roles/{roleId}")
    public void removeRole(String roleId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "";
        getDataStore().delete(href);
    }


    /**
    * Expire Password
    * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; so that the user is required to change their password at their next login.
    * @param tempPassword Sets the user&#39;s password to a temporary password,  if true (optional, default to false)
    * @return TempPassword
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/expire_password")
    public TempPassword expirePassword(Boolean tempPassword) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (tempPassword != null) queryArgs.put("tempPassword", tempPassword);

        String href = QueryString.buildHref("/api/v1/users/" + userId + "/lifecycle/expire_password", queryArgs);
        return getDataStore().create(href, new DefaultVoidResource(getDataStore()), TempPassword.class);

    }

    /**
    * Expire Password
    * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; so that the user is required to change their password at their next login.
    * @return TempPassword
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/expire_password")
    public TempPassword expirePassword() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/lifecycle/expire_password";
        return getDataStore().create(href, new DefaultVoidResource(getDataStore()), TempPassword.class);

     }


    /**
    * Activate User
    * Activates a user.  This operation can only be performed on users with a &#x60;STAGED&#x60; status.  Activation of a user is an asynchronous operation.  The user will have the &#x60;transitioningToStatus&#x60; property with a value of &#x60;ACTIVE&#x60; during activation to indicate that the user hasn&#39;t completed the asynchronous operation.  The user will have a status of &#x60;ACTIVE&#x60; when the activation process is complete.
    * @param sendEmail Sends an activation email to the user if true (required)
    * @return UserActivationToken
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/activate")
    public UserActivationToken activate(Boolean sendEmail) {

        String userId = getId();

        notNull(sendEmail, "'sendEmail' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (sendEmail != null) queryArgs.put("sendEmail", sendEmail);

        String href = QueryString.buildHref("/api/v1/users/" + userId + "/lifecycle/activate", queryArgs);
        return getDataStore().create(href, new DefaultVoidResource(getDataStore()), UserActivationToken.class);

    }


    /**
    * Change Recovery Question
    * Changes a user&#39;s recovery question &amp; answer credential by validating the user&#39;s current password.  This operation can only be performed on users in **STAGED**, **ACTIVE** or **RECOVERY** &#x60;status&#x60; that have a valid [password credential](#password-object)
    * @param userCredentials  (required)
    * @return UserCredentials
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/credentials/change_recovery_question")
    public UserCredentials changeRecoveryQuestion(UserCredentials userCredentials) {

        String userId = getId();

        notNull(userCredentials, "'userCredentials' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/credentials/change_recovery_question";
        getDataStore().create(href, userCredentials, userCredentials.getClass());
        return userCredentials;
    }


    /**
    * Unsuspend User
    * Unsuspends a user and returns them to the &#x60;ACTIVE&#x60; state.  This operation can only be performed on users that have a &#x60;SUSPENDED&#x60; status.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/unsuspend")
    public void unsuspend() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/lifecycle/unsuspend";
        getDataStore().create(href, new DefaultVoidResource(getDataStore()));

    }


    /**
    * Enroll Factor
    * Enrolls a user with a supported [factor](#list-factors-to-enroll)
    * @param updatePhone  (optional, default to false)
    * @param templateId id of SMS template (only for SMS factor) (optional)
    * @param body Factor (required)
    * @return Factor
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/factors")
    public Factor addFactor(Boolean updatePhone, String templateId, Factor body) {

        String userId = getId();

        notNull(body, "'body' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (updatePhone != null) queryArgs.put("updatePhone", updatePhone);
        if (templateId != null) queryArgs.put("templateId", templateId);

        String href = QueryString.buildHref("/api/v1/users/" + userId + "/factors", queryArgs);
        getDataStore().create(href, body, body.getClass());
        return body;
    }

    /**
    * Enroll Factor
    * Enrolls a user with a supported [factor](#list-factors-to-enroll)
    * @param body Factor (required)
    * @return Factor
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/factors")
    public Factor addFactor(Factor body) {

        String userId = getId();

        notNull(body, "'body' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/factors";
        getDataStore().create(href, body, body.getClass());
        return body;
     }


    /**
    * Get Member Groups
    * Fetches the groups of which the user is a member.
    * @return GroupList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/users/{userId}/groups")
    public GroupList listGroups() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/groups";
        return getDataStore().getResource(href, GroupList.class);
    }


    /**
    * 
    * 
    * @param roleId  (required)
    * @param groupId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "DELETE - /api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}")
    public void removeGroupTargetFromRole(String roleId, String groupId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups/" + groupId + "";
        getDataStore().delete(href);
    }


    /**
    * 
    * Enumerates all the [supported factors](#supported-factors-for-providers) that can be enrolled for the specified user
    * @return FactorList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/users/{userId}/factors/catalog")
    public FactorList listSupportedFactors() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/factors/catalog";
        return getDataStore().getResource(href, FactorList.class);
    }


    /**
    * Delete User
    * Deletes a user permanently.  This operation can only be performed on users that have a &#x60;DEPROVISIONED&#x60; status.  **This action cannot be recovered!**
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "DELETE - /api/v1/users/{userId}")
    public void delete() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "";
        getDataStore().delete(href);
    }


    /**
    * Reset Factors
    * This operation resets all factors for the specified user. All MFA factor enrollments returned to the unenrolled state. The user&#39;s status remains ACTIVE. This link is present only if the user is currently enrolled in one or more MFA factors.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/reset_factors")
    public void resetFactors() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/lifecycle/reset_factors";
        getDataStore().create(href, new DefaultVoidResource(getDataStore()));

    }


    /**
    * Suspend User
    * Suspends a user.  This operation can only be performed on users with an &#x60;ACTIVE&#x60; status.  The user will have a status of &#x60;SUSPENDED&#x60; when the process is complete.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/suspend")
    public void suspend() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/lifecycle/suspend";
        getDataStore().create(href, new DefaultVoidResource(getDataStore()));

    }


    /**
    * 
    * Lists all roles assigned to a user.
    * @param expand  (optional)
    * @return RoleList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/users/{userId}/roles")
    public RoleList listRoles(String expand) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (expand != null) queryArgs.put("expand", expand);

        String href = QueryString.buildHref("/api/v1/users/" + userId + "/roles", queryArgs);
        return getDataStore().getResource(href, RoleList.class);
    }

    /**
    * 
    * Lists all roles assigned to a user.
    * @return RoleList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/users/{userId}/roles")
    public RoleList listRoles() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/roles";
        return getDataStore().getResource(href, RoleList.class);
     }


    /**
    * Unlock User
    * Unlocks a user with a &#x60;LOCKED_OUT&#x60; status and returns them to &#x60;ACTIVE&#x60; status.  Users will be able to login with their current password.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/unlock")
    public void unlock() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/lifecycle/unlock";
        getDataStore().create(href, new DefaultVoidResource(getDataStore()));

    }


    /**
    * Update User
    * Update a user&#39;s profile and/or credentials using strict-update semantics.
    * @return User
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "PUT - /api/v1/users/{userId}")
    public User update() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "";
        getDataStore().save(href, this);
        return this;
    }


    /**
    * 
    * Fetches a factor for the specified user
    * @param factorId  (required)
    * @return Factor
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/users/{userId}/factors/{factorId}")
    public Factor getFactor(String factorId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/factors/" + factorId + "";
        return getDataStore().getResource(href, Factor.class);
    }


    /**
    * Change Password
    * Changes a user&#39;s password by validating the user&#39;s current password.  This operation can only be performed on users in &#x60;STAGED&#x60;, &#x60;ACTIVE&#x60;, &#x60;PASSWORD_EXPIRED&#x60;, or &#x60;RECOVERY&#x60; status that have a valid [password credential](#password-object)
    * @param changePasswordRequest  (required)
    * @return UserCredentials
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/credentials/change_password")
    public UserCredentials changePassword(ChangePasswordRequest changePasswordRequest) {

        String userId = getId();

        notNull(changePasswordRequest, "'changePasswordRequest' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/credentials/change_password";
        return getDataStore().create(href, changePasswordRequest, UserCredentials.class);

    }


    /**
    * Get Assigned App Links
    * Fetches appLinks for all direct or indirect (via group membership) assigned applications.
    * @param showAll  (optional, default to false)
    * @return AppLinkList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/users/{userId}/appLinks")
    public AppLinkList listAppLinks(Boolean showAll) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (showAll != null) queryArgs.put("showAll", showAll);

        String href = QueryString.buildHref("/api/v1/users/" + userId + "/appLinks", queryArgs);
        return getDataStore().getResource(href, AppLinkList.class);
    }

    /**
    * Get Assigned App Links
    * Fetches appLinks for all direct or indirect (via group membership) assigned applications.
    * @return AppLinkList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/users/{userId}/appLinks")
    public AppLinkList listAppLinks() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/appLinks";
        return getDataStore().getResource(href, AppLinkList.class);
     }


    /**
    * 
    * 
    * @param roleId  (required)
    * @param groupId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "PUT - /api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}")
    public void addGroupTargetToRole(String roleId, String groupId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups/" + groupId + "";

        getDataStore().save(href, new DefaultVoidResource(getDataStore()));
        
    }


    /**
    * 
    * Enumerates all available security questions for a user&#39;s &#x60;question&#x60; factor
    * @return SecurityQuestionList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "GET - /api/v1/users/{userId}/factors/questions")
    public SecurityQuestionList listSupportedSecurityQuestions() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/factors/questions";
        return getDataStore().getResource(href, SecurityQuestionList.class);
    }


    /**
    * 
    * Removes all active identity provider sessions. This forces the user to authenticate on the next operation. Optionally revokes OpenID Connect and OAuth refresh and access tokens issued to the user.
    * @param oAuthTokens Revoke issued OpenID Connect and OAuth refresh and access tokens (optional, default to false)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "DELETE - /api/v1/users/{userId}/sessions")
    public void endAllSessions(Boolean oAuthTokens) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (oAuthTokens != null) queryArgs.put("oauthTokens", oAuthTokens);

        String href = QueryString.buildHref("/api/v1/users/" + userId + "/sessions", queryArgs);
        getDataStore().delete(href);
    }

    /**
    * 
    * Removes all active identity provider sessions. This forces the user to authenticate on the next operation. Optionally revokes OpenID Connect and OAuth refresh and access tokens issued to the user.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "DELETE - /api/v1/users/{userId}/sessions")
    public void endAllSessions() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/sessions";
        getDataStore().delete(href);
     }


    /**
    * Add User to Group
    * Adds a [user](users.html#user-model) to a group with &#x60;OKTA_GROUP&#x60; type.
    * @param groupId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "PUT - /api/v1/groups/{groupId}/users/{userId}")
    public void addToGroup(String groupId) {

        String userId = getId();

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/groups/" + groupId + "/users/" + userId + "";

        getDataStore().save(href, new DefaultVoidResource(getDataStore()));
        
    }


    /**
    * 
    * Assigns a role to a user.
    * @param role  (required)
    * @return Role
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2017-12-14T13:01:44.308-05:00",
          comments = "POST - /api/v1/users/{userId}/roles")
    public Role addRole(Role role) {

        String userId = getId();

        notNull(role, "'role' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        String href = "/api/v1/users/" + userId + "/roles";
        getDataStore().create(href, role, role.getClass());
        return role;
    }




}
