/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.ds;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.okta.sdk.impl.ds.DefaultResourceConverter;
import com.okta.sdk.impl.ds.MapMarshaller;
import com.okta.sdk.impl.ds.MarshalingException;
import com.okta.sdk.impl.ds.ResourceConverter;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.ReferenceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JacksonMapMarshaller
implements MapMarshaller {
    private ObjectMapper objectMapper = new ObjectMapper();

    public JacksonMapMarshaller() {
        this.objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer((JsonSerializer)new AbstractResourceSerializer(AbstractResource.class));
        this.objectMapper.registerModule((Module)simpleModule);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isPrettyPrint() {
        return this.objectMapper.getSerializationConfig().isEnabled(SerializationFeature.INDENT_OUTPUT);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, prettyPrint);
    }

    @Override
    public String marshal(Map map) {
        try {
            return this.objectMapper.writeValueAsString((Object)map);
        }
        catch (IOException e) {
            throw new MarshalingException("Unable to convert Map to JSON String.", e);
        }
    }

    @Override
    public Map unmarshal(String marshalled) {
        try {
            TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};
            return (Map)this.objectMapper.readValue(marshalled, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new MarshalingException("Unable to convert JSON String to Map.", e);
        }
    }

    @Override
    public Map<String, Object> unmarshall(InputStream marshalled, Map<String, String> linkMap) {
        try {
            Object resolvedObj = this.objectMapper.readValue(marshalled, Object.class);
            if (resolvedObj instanceof Map) {
                return (Map)resolvedObj;
            }
            if (resolvedObj instanceof List) {
                List list = (List)resolvedObj;
                LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
                ret.put("items", list);
                ret.put("nextPage", linkMap.get("next"));
                ret.put("href", "local");
                return ret;
            }
            throw new MarshalingException("Unable to convert InputStream String to Map. Resolved Object is neither a Map or a List: " + resolvedObj.getClass());
        }
        catch (IOException e) {
            throw new MarshalingException("Unable to convert InputStream String to Map.", e);
        }
    }

    static class AbstractResourceSerializer
    extends StdSerializer<AbstractResource> {
        private static final long serialVersionUID = 42L;
        private final transient ResourceConverter resourceConverter = new DefaultResourceConverter(new ReferenceFactory());

        AbstractResourceSerializer(Class<AbstractResource> t) {
            super(t);
        }

        public void serialize(AbstractResource resource, JsonGenerator jgen, SerializerProvider sp) throws IOException {
            jgen.writeObject(this.resourceConverter.convert(resource, false));
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
        }
    }
}

