/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.http.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class Version {
    private static final String CLIENT_VERSION = Version.lookupClientVersion();

    public static String getClientVersion() {
        return CLIENT_VERSION;
    }

    private static String lookupClientVersion() {
        Class<Version> clazz = Version.class;
        String filePath = "/com/okta/sdk/version.properties";
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            String line;
            inputStream = clazz.getResourceAsStream(filePath);
            reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null && (line.startsWith("#") || line.isEmpty())) {
            }
            String string = line;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to obtain version from [" + filePath + "].");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception while trying to close file [" + filePath + "].");
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception while trying to close file [" + filePath + "].");
                }
            }
        }
    }
}

