/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Page;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.lang.Classes;
import com.okta.sdk.resource.CollectionResource;
import com.okta.sdk.resource.Resource;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class AbstractCollectionResource<T extends Resource>
extends AbstractResource
implements CollectionResource<T> {
    public static final StringProperty NEXT_PAGE = new StringProperty("nextPage");
    public static final String ITEMS_PROPERTY_NAME = "items";
    private final Map<String, Object> queryParams;
    private String nextPageHref = null;
    private AtomicBoolean firstPageQueryRequired = new AtomicBoolean();

    protected AbstractCollectionResource(InternalDataStore dataStore) {
        super(dataStore);
        this.queryParams = Collections.emptyMap();
    }

    protected AbstractCollectionResource(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
        this.queryParams = Collections.emptyMap();
        this.nextPageHref = this.getString(NEXT_PAGE);
    }

    protected AbstractCollectionResource(InternalDataStore dataStore, Map<String, Object> properties, Map<String, Object> queryParams) {
        super(dataStore, properties);
        this.nextPageHref = this.getString(NEXT_PAGE);
        this.queryParams = queryParams != null ? queryParams : Collections.emptyMap();
    }

    public static boolean isCollectionResource(Map<String, ?> props) {
        return AbstractCollectionResource.isMaterialized(props) && props.get(ITEMS_PROPERTY_NAME) instanceof Iterable;
    }

    private String getNextPageHref() {
        return this.nextPageHref;
    }

    private boolean hasNextPage() {
        return this.getNextPageHref() != null;
    }

    public T single() {
        Iterator<T> iterator = this.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("This list is empty while it was expected to contain one (and only one) element.");
        }
        Resource itemToReturn = (Resource)iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException("Only a single resource was expected, but this list contains more than one item.");
        }
        return (T)itemToReturn;
    }

    protected abstract Class<T> getItemType();

    public Page<T> getCurrentPage() {
        Collection<Object> items = Collections.emptyList();
        Object value = this.getProperty(ITEMS_PROPERTY_NAME);
        if (value != null) {
            Collection vals;
            Collection c = null;
            if (value instanceof Map[]) {
                Map[] vals2 = (Map[])value;
                if (vals2.length > 0) {
                    c = Arrays.asList(vals2);
                }
            } else if (value instanceof Collection && (vals = (Collection)value).size() > 0) {
                c = vals;
            }
            if (c != null && !c.isEmpty()) {
                if (!this.getItemType().isInstance(c.iterator().next())) {
                    items = this.toResourceList(c, this.getItemType());
                    this.setProperty(ITEMS_PROPERTY_NAME, items, false);
                } else {
                    items = c;
                }
            }
        }
        return new DefaultPage(items);
    }

    public Iterator<T> iterator() {
        return new PaginatedIterator(this, this.firstPageQueryRequired.getAndSet(true));
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Spliterator<T> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }

    private Collection<T> toResourceList(Collection vals, Class<T> itemType) {
        ArrayList<T> list = new ArrayList<T>(vals.size());
        for (Object o : vals) {
            Map properties = (Map)o;
            T resource = this.toResource(itemType, properties);
            list.add(resource);
        }
        return list;
    }

    protected T toResource(Class<T> resourceClass, Map<String, Object> properties) {
        return this.getDataStore().instantiate(resourceClass, properties);
    }

    public static final <T extends Resource, R extends CollectionResource<T>> R emptyCollectionResource(InternalDataStore internalDataStore, Class<R> implClass) {
        List emptyList = Collections.emptyList();
        LinkedHashMap properties = new LinkedHashMap();
        properties.put(ITEMS_PROPERTY_NAME, emptyList);
        Constructor ctor = Classes.getConstructor(implClass, (Class[])new Class[]{InternalDataStore.class, Map.class});
        return (R)((CollectionResource)Classes.instantiate((Constructor)ctor, (Object[])new Object[]{internalDataStore, properties}));
    }

    public static final <T extends Resource, R extends CollectionResource<T>> R singletonCollectionResource(InternalDataStore internalDataStore, Class<R> implClass, T item) {
        List<T> singletonList = Collections.singletonList(item);
        LinkedHashMap<String, List<T>> properties = new LinkedHashMap<String, List<T>>();
        properties.put(ITEMS_PROPERTY_NAME, singletonList);
        Constructor ctor = Classes.getConstructor(implClass, (Class[])new Class[]{InternalDataStore.class, Map.class});
        return (R)((CollectionResource)Classes.instantiate((Constructor)ctor, (Object[])new Object[]{internalDataStore, properties}));
    }

    private static class DefaultPage<T>
    implements Page<T> {
        private final Collection<T> items;

        DefaultPage(Collection<T> items) {
            this.items = Collections.unmodifiableCollection(items);
        }

        @Override
        public Collection<T> getItems() {
            return this.items;
        }
    }

    private class PaginatedIterator<T extends Resource>
    implements Iterator<T> {
        private AbstractCollectionResource<T> resource;
        private Page<T> currentPage;
        private Iterator<T> currentPageIterator;
        private int currentItemIndex;

        private PaginatedIterator(AbstractCollectionResource<T> resource, boolean firstPageQueryRequired) {
            if (firstPageQueryRequired) {
                this.resource = (AbstractCollectionResource)AbstractCollectionResource.this.getDataStore().getResource(resource.getResourceHref(), resource.getClass(), ((AbstractCollectionResource)resource).queryParams);
                this.currentPage = this.resource.getCurrentPage();
            } else {
                this.resource = resource;
                this.currentPage = resource.getCurrentPage();
            }
            this.currentPageIterator = this.currentPage.getItems().iterator();
            this.currentItemIndex = 0;
        }

        @Override
        public boolean hasNext() {
            AbstractCollectionResource nextResource;
            Page nextPage;
            Iterator nextIterator;
            boolean hasNext = this.currentPageIterator.hasNext();
            if (!hasNext && AbstractCollectionResource.this.hasNextPage() && (nextIterator = (nextPage = (nextResource = (AbstractCollectionResource)AbstractCollectionResource.this.getDataStore().getResource(AbstractCollectionResource.this.getNextPageHref(), this.resource.getClass())).getCurrentPage()).getItems().iterator()).hasNext()) {
                hasNext = true;
                this.resource = nextResource;
                this.currentPage = nextPage;
                this.currentPageIterator = nextIterator;
                this.currentItemIndex = 0;
                AbstractCollectionResource.this.nextPageHref = nextResource.getString(NEXT_PAGE);
            }
            return hasNext;
        }

        @Override
        public T next() {
            Resource item = (Resource)this.currentPageIterator.next();
            ++this.currentItemIndex;
            return (T)item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }
    }
}

