/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.user;

import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.http.QueryString;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.user.AppLinkList;
import com.okta.sdk.resource.user.ChangePasswordRequest;
import com.okta.sdk.resource.user.ForgotPasswordResponse;
import com.okta.sdk.resource.user.ResetPasswordToken;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.RoleList;
import com.okta.sdk.resource.user.TempPassword;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserActivationToken;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.UserProfile;
import com.okta.sdk.resource.user.UserStatus;
import com.okta.sdk.resource.user.factor.Factor;
import com.okta.sdk.resource.user.factor.FactorList;
import com.okta.sdk.resource.user.factor.SecurityQuestionList;
import java.util.Date;
import java.util.Map;

public class DefaultUser
extends AbstractInstanceResource<User>
implements User {
    private static final MapProperty embeddedProperty = new MapProperty("_embedded");
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final DateProperty activatedProperty = new DateProperty("activated");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final ResourceReference<UserCredentials> credentialsProperty = new ResourceReference<UserCredentials>("credentials", UserCredentials.class, false);
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastLoginProperty = new DateProperty("lastLogin");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final DateProperty passwordChangedProperty = new DateProperty("passwordChanged");
    private static final ResourceReference<UserProfile> profileProperty = new ResourceReference<UserProfile>("profile", UserProfile.class, true);
    private static final EnumProperty<UserStatus> statusProperty = new EnumProperty<UserStatus>("status", UserStatus.class);
    private static final DateProperty statusChangedProperty = new DateProperty("statusChanged");
    private static final EnumProperty<UserStatus> transitioningToStatusProperty = new EnumProperty<UserStatus>("transitioningToStatus", UserStatus.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultUser.createPropertyDescriptorMap(embeddedProperty, linksProperty, activatedProperty, createdProperty, credentialsProperty, idProperty, lastLoginProperty, lastUpdatedProperty, passwordChangedProperty, profileProperty, statusProperty, statusChangedProperty, transitioningToStatusProperty);

    public DefaultUser(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultUser(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Map<String, Object> getEmbedded() {
        return this.getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public Date getActivated() {
        return this.getDateProperty(activatedProperty);
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public UserCredentials getCredentials() {
        return this.getResourceProperty(credentialsProperty);
    }

    public User setCredentials(UserCredentials credentials) {
        this.setProperty(credentialsProperty, (Object)credentials);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastLogin() {
        return this.getDateProperty(lastLoginProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public Date getPasswordChanged() {
        return this.getDateProperty(passwordChangedProperty);
    }

    public UserProfile getProfile() {
        return this.getResourceProperty(profileProperty);
    }

    public User setProfile(UserProfile profile) {
        this.setProperty(profileProperty, (Object)profile);
        return this;
    }

    public UserStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public Date getStatusChanged() {
        return this.getDateProperty(statusChangedProperty);
    }

    public UserStatus getTransitioningToStatus() {
        return this.getEnumProperty(transitioningToStatusProperty);
    }

    public void deactivate() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/lifecycle/deactivate";
        this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()));
    }

    public ResetPasswordToken resetPassword(String provider, Boolean sendEmail) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (provider != null) {
            queryArgs.put("provider", provider);
        }
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        String href = QueryString.buildHref("/api/v1/users/" + userId + "/lifecycle/reset_password", queryArgs);
        return this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()), ResetPasswordToken.class);
    }

    public ResetPasswordToken resetPassword() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/lifecycle/reset_password";
        return this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()), ResetPasswordToken.class);
    }

    public FactorList listFactors() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/factors";
        return (FactorList)this.getDataStore().getResource(href, FactorList.class);
    }

    public GroupList listGroupTargetsForRole(String roleId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups";
        return (GroupList)this.getDataStore().getResource(href, GroupList.class);
    }

    public ForgotPasswordResponse forgotPassword(Boolean sendEmail, UserCredentials userCredentials) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        String href = QueryString.buildHref("/api/v1/users/" + userId + "/credentials/forgot_password", queryArgs);
        return this.getDataStore().create(href, userCredentials, ForgotPasswordResponse.class);
    }

    public ForgotPasswordResponse forgotPassword() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/credentials/forgot_password";
        return this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()), ForgotPasswordResponse.class);
    }

    public void removeRole(String roleId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "";
        this.getDataStore().delete(href);
    }

    public TempPassword expirePassword(Boolean tempPassword) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (tempPassword != null) {
            queryArgs.put("tempPassword", tempPassword);
        }
        String href = QueryString.buildHref("/api/v1/users/" + userId + "/lifecycle/expire_password", queryArgs);
        return this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()), TempPassword.class);
    }

    public TempPassword expirePassword() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/lifecycle/expire_password";
        return this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()), TempPassword.class);
    }

    public UserActivationToken activate(Boolean sendEmail) {
        String userId = this.getId();
        Assert.notNull((Object)sendEmail, (String)"'sendEmail' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        String href = QueryString.buildHref("/api/v1/users/" + userId + "/lifecycle/activate", queryArgs);
        return this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()), UserActivationToken.class);
    }

    public UserCredentials changeRecoveryQuestion(UserCredentials userCredentials) {
        String userId = this.getId();
        Assert.notNull((Object)userCredentials, (String)"'userCredentials' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/credentials/change_recovery_question";
        this.getDataStore().create(href, userCredentials, userCredentials.getClass());
        return userCredentials;
    }

    public void unsuspend() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/lifecycle/unsuspend";
        this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()));
    }

    public Factor addFactor(Boolean updatePhone, String templateId, Factor body) {
        String userId = this.getId();
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (updatePhone != null) {
            queryArgs.put("updatePhone", updatePhone);
        }
        if (templateId != null) {
            queryArgs.put("templateId", templateId);
        }
        String href = QueryString.buildHref("/api/v1/users/" + userId + "/factors", queryArgs);
        this.getDataStore().create(href, body, body.getClass());
        return body;
    }

    public Factor addFactor(Factor body) {
        String userId = this.getId();
        Assert.notNull((Object)body, (String)"'body' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/factors";
        this.getDataStore().create(href, body, body.getClass());
        return body;
    }

    public GroupList listGroups() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/groups";
        return (GroupList)this.getDataStore().getResource(href, GroupList.class);
    }

    public void removeGroupTargetFromRole(String roleId, String groupId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups/" + groupId + "";
        this.getDataStore().delete(href);
    }

    public FactorList listSupportedFactors() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/factors/catalog";
        return (FactorList)this.getDataStore().getResource(href, FactorList.class);
    }

    @Override
    public void delete() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "";
        this.getDataStore().delete(href);
    }

    public void resetFactors() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/lifecycle/reset_factors";
        this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()));
    }

    public void suspend() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/lifecycle/suspend";
        this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()));
    }

    public RoleList listRoles(String expand) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (expand != null) {
            queryArgs.put("expand", expand);
        }
        String href = QueryString.buildHref("/api/v1/users/" + userId + "/roles", queryArgs);
        return (RoleList)this.getDataStore().getResource(href, RoleList.class);
    }

    public RoleList listRoles() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/roles";
        return (RoleList)this.getDataStore().getResource(href, RoleList.class);
    }

    public void unlock() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/lifecycle/unlock";
        this.getDataStore().create(href, new DefaultVoidResource(this.getDataStore()));
    }

    public User update() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "";
        this.getDataStore().save(href, this);
        return this;
    }

    public Factor getFactor(String factorId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/factors/" + factorId + "";
        return (Factor)this.getDataStore().getResource(href, Factor.class);
    }

    public UserCredentials changePassword(ChangePasswordRequest changePasswordRequest) {
        String userId = this.getId();
        Assert.notNull((Object)changePasswordRequest, (String)"'changePasswordRequest' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/credentials/change_password";
        return this.getDataStore().create(href, changePasswordRequest, UserCredentials.class);
    }

    public AppLinkList listAppLinks(Boolean showAll) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (showAll != null) {
            queryArgs.put("showAll", showAll);
        }
        String href = QueryString.buildHref("/api/v1/users/" + userId + "/appLinks", queryArgs);
        return (AppLinkList)this.getDataStore().getResource(href, AppLinkList.class);
    }

    public AppLinkList listAppLinks() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/appLinks";
        return (AppLinkList)this.getDataStore().getResource(href, AppLinkList.class);
    }

    public void addGroupTargetToRole(String roleId, String groupId) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)roleId, (String)"'roleId' is required and cannot be null or empty.");
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups/" + groupId + "";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()));
    }

    public SecurityQuestionList listSupportedSecurityQuestions() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/factors/questions";
        return (SecurityQuestionList)this.getDataStore().getResource(href, SecurityQuestionList.class);
    }

    public void endAllSessions(Boolean oAuthTokens) {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        QueryString queryArgs = new QueryString();
        if (oAuthTokens != null) {
            queryArgs.put("oauthTokens", oAuthTokens);
        }
        String href = QueryString.buildHref("/api/v1/users/" + userId + "/sessions", queryArgs);
        this.getDataStore().delete(href);
    }

    public void endAllSessions() {
        String userId = this.getId();
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/sessions";
        this.getDataStore().delete(href);
    }

    public void addToGroup(String groupId) {
        String userId = this.getId();
        Assert.hasText((String)groupId, (String)"'groupId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/groups/" + groupId + "/users/" + userId + "";
        this.getDataStore().save(href, new DefaultVoidResource(this.getDataStore()));
    }

    public Role addRole(Role role) {
        String userId = this.getId();
        Assert.notNull((Object)role, (String)"'role' is required and cannot be null.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        String href = "/api/v1/users/" + userId + "/roles";
        this.getDataStore().create(href, role, role.getClass());
        return role;
    }
}

