/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.client;

import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.cache.CacheConfigurationBuilder;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.cache.CacheManagerBuilder;
import com.okta.sdk.cache.Caches;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.Client;
import com.okta.sdk.client.ClientBuilder;
import com.okta.sdk.client.Proxy;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.api.DefaultClientCredentialsResolver;
import com.okta.sdk.impl.client.DefaultClient;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.impl.config.EnvironmentVariablesPropertiesSource;
import com.okta.sdk.impl.config.OptionalPropertiesSource;
import com.okta.sdk.impl.config.PropertiesSource;
import com.okta.sdk.impl.config.ResourcePropertiesSource;
import com.okta.sdk.impl.config.SystemPropertiesSource;
import com.okta.sdk.impl.config.YAMLPropertiesSource;
import com.okta.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.okta.sdk.impl.io.DefaultResourceFactory;
import com.okta.sdk.impl.io.Resource;
import com.okta.sdk.impl.io.ResourceFactory;
import com.okta.sdk.impl.util.BaseUrlResolver;
import com.okta.sdk.impl.util.DefaultBaseUrlResolver;
import com.okta.sdk.lang.Assert;
import com.okta.sdk.lang.Classes;
import com.okta.sdk.lang.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientBuilder
implements ClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultClientBuilder.class);
    private Proxy proxy;
    private CacheManager cacheManager;
    private ClientCredentials clientCredentials;
    private static final String ENVVARS_TOKEN = "envvars";
    private static final String SYSPROPS_TOKEN = "sysprops";
    private static final String OKTA_YAML = "okta.yaml";
    private static final String USER_HOME = System.getProperty("user.home") + File.separatorChar;
    private static final String[] DEFAULT_OKTA_PROPERTIES_FILE_LOCATIONS = new String[]{"classpath:com/okta/sdk/config/okta.yaml", "classpath:okta.yaml", USER_HOME + ".okta" + File.separatorChar + "okta.yaml", "envvars", "sysprops"};
    private ClientConfiguration clientConfig = new ClientConfiguration();

    public DefaultClientBuilder() {
        this(new DefaultResourceFactory());
    }

    DefaultClientBuilder(ResourceFactory resourceFactory) {
        ArrayList<PropertiesSource> sources = new ArrayList<PropertiesSource>();
        for (String location : DEFAULT_OKTA_PROPERTIES_FILE_LOCATIONS) {
            if (ENVVARS_TOKEN.equalsIgnoreCase(location)) {
                sources.add(EnvironmentVariablesPropertiesSource.oktaFilteredPropertiesSource());
                continue;
            }
            if (SYSPROPS_TOKEN.equalsIgnoreCase(location)) {
                sources.add(SystemPropertiesSource.oktaFilteredPropertiesSource());
                continue;
            }
            Resource resource = resourceFactory.createResource(location);
            PropertiesSource wrappedSource = Strings.endsWithIgnoreCase((String)location, (String)".yaml") || Strings.endsWithIgnoreCase((String)location, (String)".yml") ? new YAMLPropertiesSource(resource) : new ResourcePropertiesSource(resource);
            OptionalPropertiesSource propertiesSource = new OptionalPropertiesSource(wrappedSource);
            sources.add(propertiesSource);
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (PropertiesSource source : sources) {
            Map<String, String> srcProps = source.getProperties();
            props.putAll(srcProps);
        }
        if (Strings.hasText((String)((String)props.get("okta.client.token")))) {
            this.clientConfig.setApiToken((String)props.get("okta.client.token"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.cache.enabled")))) {
            this.clientConfig.setCacheManagerEnabled(Boolean.valueOf((String)props.get("okta.client.cache.enabled")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.cache.defaultTtl")))) {
            this.clientConfig.setCacheManagerTtl(Long.parseLong((String)props.get("okta.client.cache.defaultTtl")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.cache.defaultTti")))) {
            this.clientConfig.setCacheManagerTti(Long.parseLong((String)props.get("okta.client.cache.defaultTti")));
        }
        for (String prop : props.keySet()) {
            boolean isPrefix = prop.length() == "okta.client.cache.caches".length();
            if (isPrefix || !prop.startsWith("okta.client.cache.caches")) continue;
            String cacheClass = prop.substring("okta.client.cache.caches".length() + 1, prop.length() - 4);
            String cacheTti = (String)props.get("okta.client.cache.caches." + cacheClass + ".tti");
            String cacheTtl = (String)props.get("okta.client.cache.caches." + cacheClass + ".ttl");
            CacheConfigurationBuilder cacheBuilder = Caches.forResource((Class)Classes.forName((String)cacheClass));
            if (Strings.hasText((String)cacheTti)) {
                cacheBuilder.withTimeToIdle(Long.parseLong(cacheTti), TimeUnit.SECONDS);
            }
            if (Strings.hasText((String)cacheTtl)) {
                cacheBuilder.withTimeToLive(Long.parseLong(cacheTtl), TimeUnit.SECONDS);
            }
            if (this.clientConfig.getCacheManagerCaches().containsKey(cacheClass)) continue;
            this.clientConfig.getCacheManagerCaches().put(cacheClass, cacheBuilder);
        }
        if (Strings.hasText((String)((String)props.get("okta.client.orgUrl")))) {
            String baseUrl = (String)props.get("okta.client.orgUrl");
            baseUrl = baseUrl.replace("\\:", ":");
            this.clientConfig.setBaseUrl(baseUrl);
        }
        if (Strings.hasText((String)((String)props.get("okta.client.connectionTimeout")))) {
            this.clientConfig.setConnectionTimeout(Integer.parseInt((String)props.get("okta.client.connectionTimeout")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.authenticationScheme")))) {
            this.clientConfig.setAuthenticationScheme(Enum.valueOf(AuthenticationScheme.class, (String)props.get("okta.client.authenticationScheme")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.proxy.port")))) {
            this.clientConfig.setProxyPort(Integer.parseInt((String)props.get("okta.client.proxy.port")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.proxy.host")))) {
            this.clientConfig.setProxyHost((String)props.get("okta.client.proxy.host"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.proxy.username")))) {
            this.clientConfig.setProxyUsername((String)props.get("okta.client.proxy.username"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.proxy.password")))) {
            this.clientConfig.setProxyPassword((String)props.get("okta.client.proxy.password"));
        }
    }

    public ClientBuilder setProxy(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy argument cannot be null.");
        }
        this.proxy = proxy;
        return this;
    }

    public ClientBuilder setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        return this;
    }

    public ClientBuilder setAuthenticationScheme(AuthenticationScheme authenticationScheme) {
        this.clientConfig.setAuthenticationScheme(authenticationScheme);
        return this;
    }

    public ClientBuilder setConnectionTimeout(int timeout) {
        Assert.isTrue((timeout >= 0 ? 1 : 0) != 0, (String)"Timeout cannot be a negative number.");
        this.clientConfig.setConnectionTimeout(timeout);
        return this;
    }

    public ClientBuilder setClientCredentials(ClientCredentials clientCredentials) {
        Assert.isInstanceOf(ClientCredentials.class, (Object)clientCredentials);
        this.clientCredentials = clientCredentials;
        return this;
    }

    public ClientBuilder setRequestAuthenticatorFactory(RequestAuthenticatorFactory factory) {
        Assert.notNull((Object)factory, (String)"factory argument cannot be null");
        this.clientConfig.setRequestAuthenticatorFactory(factory);
        return this;
    }

    public ClientBuilder setClientCredentialsResolver(ClientCredentialsResolver clientCredentialsResolver) {
        Assert.notNull((Object)clientCredentialsResolver, (String)"clientCredentialsResolver must not be null.");
        this.clientConfig.setClientCredentialsResolver(clientCredentialsResolver);
        return this;
    }

    public ClientBuilder setBaseUrlResolver(BaseUrlResolver baseUrlResolver) {
        Assert.notNull((Object)baseUrlResolver, (String)"baseUrlResolver must not be null");
        this.clientConfig.setBaseUrlResolver(baseUrlResolver);
        return this;
    }

    public Client build() {
        if (!this.clientConfig.isCacheManagerEnabled()) {
            log.debug("CacheManager disabled. Defaulting to DisabledCacheManager");
            this.cacheManager = Caches.newDisabledCacheManager();
        } else if (this.cacheManager == null) {
            log.debug("No CacheManager configured. Defaulting to in-memory CacheManager with default TTL and TTI of five minutes.");
            CacheManagerBuilder cacheManagerBuilder = Caches.newCacheManager().withDefaultTimeToIdle(this.clientConfig.getCacheManagerTti(), TimeUnit.SECONDS).withDefaultTimeToLive(this.clientConfig.getCacheManagerTtl(), TimeUnit.SECONDS);
            if (this.clientConfig.getCacheManagerCaches().size() > 0) {
                for (CacheConfigurationBuilder builder : this.clientConfig.getCacheManagerCaches().values()) {
                    cacheManagerBuilder.withCache(builder);
                }
            }
            this.cacheManager = cacheManagerBuilder.build();
        }
        if (this.clientConfig.getProxyPort() > 0 || this.clientConfig.getProxyHost() != null && (this.clientConfig.getProxyUsername() == null || this.clientConfig.getProxyPassword() == null)) {
            this.proxy = new Proxy(this.clientConfig.getProxyHost(), this.clientConfig.getProxyPort());
        } else if (this.clientConfig.getProxyUsername() != null && this.clientConfig.getProxyPassword() != null) {
            this.proxy = new Proxy(this.clientConfig.getProxyHost(), this.clientConfig.getProxyPort(), this.clientConfig.getProxyUsername(), this.clientConfig.getProxyPassword());
        }
        ClientCredentialsResolver clientCredentialsResolver = this.clientConfig.getClientCredentialsResolver();
        if (clientCredentialsResolver == null && this.clientCredentials != null) {
            clientCredentialsResolver = new DefaultClientCredentialsResolver(this.clientCredentials);
        } else if (clientCredentialsResolver == null) {
            clientCredentialsResolver = new DefaultClientCredentialsResolver(this.clientConfig);
        }
        BaseUrlResolver baseUrlResolver = this.clientConfig.getBaseUrlResolver();
        if (baseUrlResolver == null) {
            Assert.notNull((Object)this.clientConfig.getBaseUrl(), (String)"Okta org url must not be null.");
            baseUrlResolver = new DefaultBaseUrlResolver(this.clientConfig.getBaseUrl());
        }
        return new DefaultClient(clientCredentialsResolver, baseUrlResolver, this.proxy, this.cacheManager, this.clientConfig.getAuthenticationScheme(), this.clientConfig.getRequestAuthenticatorFactory(), this.clientConfig.getConnectionTimeout());
    }

    public ClientBuilder setOrgUrl(String baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("baseUrl argument cannot be null.");
        }
        this.clientConfig.setBaseUrl(baseUrl);
        return this;
    }

    ClientConfiguration getClientConfiguration() {
        return this.clientConfig;
    }
}

