/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.http.support;

import com.okta.sdk.impl.http.HttpHeaders;
import com.okta.sdk.impl.http.MediaType;
import com.okta.sdk.impl.http.Response;
import com.okta.sdk.impl.http.support.AbstractHttpMessage;
import java.io.InputStream;

public class DefaultResponse
extends AbstractHttpMessage
implements Response {
    private final int httpStatus;
    private final HttpHeaders headers;
    private final InputStream body;

    public DefaultResponse(int httpStatus, MediaType contentType, InputStream body, long contentLength) {
        this.httpStatus = httpStatus;
        this.headers = new HttpHeaders();
        this.headers.setContentType(contentType);
        this.body = body;
        this.headers.setContentLength(contentLength);
    }

    @Override
    public int getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(HttpHeaders headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    @Override
    public boolean isError() {
        return this.isServerError() || this.isClientError();
    }

    @Override
    public boolean isServerError() {
        int status = this.getHttpStatus();
        return status >= 500 && status < 600;
    }

    @Override
    public boolean isClientError() {
        int status = this.getHttpStatus();
        return status >= 400 && status < 500;
    }

    @Override
    public InputStream getBody() {
        return this.body;
    }
}

