/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.oauth2;

import com.okta.commons.http.authc.DisabledAuthenticator;
import com.okta.commons.http.authc.RequestAuthenticator;
import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Strings;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.AuthorizationMode;
import com.okta.sdk.error.Error;
import com.okta.sdk.error.ResourceException;
import com.okta.sdk.impl.api.DefaultClientCredentialsResolver;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.impl.oauth2.AccessTokenRetrieverService;
import com.okta.sdk.impl.oauth2.OAuth2AccessToken;
import com.okta.sdk.impl.oauth2.OAuth2HttpException;
import com.okta.sdk.impl.oauth2.OAuth2TokenRetrieverException;
import com.okta.sdk.impl.util.ConfigUtil;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.openapitools.client.ApiClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class AccessTokenRetrieverServiceImpl
implements AccessTokenRetrieverService {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenRetrieverServiceImpl.class);
    private static final String TOKEN_URI = "/oauth2/v1/token";
    private final ClientConfiguration tokenClientConfiguration;
    private final ApiClient apiClient;

    public AccessTokenRetrieverServiceImpl(ClientConfiguration apiClientConfiguration, ApiClient apiClient) {
        Assert.notNull((Object)((Object)apiClientConfiguration), (String)"apiClientConfiguration must not be null.");
        Assert.notNull((Object)apiClient, (String)"apiClient must not be null.");
        this.apiClient = apiClient;
        this.tokenClientConfiguration = this.constructTokenClientConfig(apiClientConfiguration);
    }

    @Override
    public OAuth2AccessToken getOAuth2AccessToken() throws IOException, InvalidKeyException, OAuth2TokenRetrieverException {
        log.debug("Attempting to get OAuth2 access token for client id {} from {}", (Object)this.tokenClientConfiguration.getClientId(), (Object)(this.tokenClientConfiguration.getBaseUrl() + TOKEN_URI));
        String signedJwt = this.createSignedJWT();
        String scope = String.join((CharSequence)" ", this.tokenClientConfiguration.getScopes());
        try {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            httpHeaders.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            queryParams.add((Object)"grant_type", (Object)"client_credentials");
            queryParams.add((Object)"client_assertion_type", (Object)"urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            queryParams.add((Object)"client_assertion", (Object)signedJwt);
            queryParams.add((Object)"scope", (Object)scope);
            ResponseEntity responseEntity = this.apiClient.invokeAPI(TOKEN_URI, HttpMethod.POST, Collections.emptyMap(), (MultiValueMap)queryParams, null, httpHeaders, (MultiValueMap)new LinkedMultiValueMap(), null, Collections.singletonList(MediaType.APPLICATION_JSON), MediaType.APPLICATION_JSON, new String[]{"OAuth_2.0"}, (ParameterizedTypeReference)new ParameterizedTypeReference<OAuth2AccessToken>(){});
            OAuth2AccessToken oAuth2AccessToken = (OAuth2AccessToken)responseEntity.getBody();
            log.debug("Got OAuth2 access token for client id {} from {}", (Object)this.tokenClientConfiguration.getClientId(), (Object)(this.tokenClientConfiguration.getBaseUrl() + TOKEN_URI));
            return oAuth2AccessToken;
        }
        catch (ResourceException e) {
            Error defaultError = e.getError();
            throw new OAuth2HttpException(defaultError.getMessage(), e, e.getStatus() == 401);
        }
        catch (Exception e) {
            throw new OAuth2TokenRetrieverException("Exception while trying to get OAuth2 access token for client id " + this.tokenClientConfiguration.getClientId(), e);
        }
    }

    String createSignedJWT() throws InvalidKeyException, IOException {
        String clientId = this.tokenClientConfiguration.getClientId();
        PrivateKey privateKey = this.parsePrivateKey(this.getPemReader());
        Instant now = Instant.now();
        JwtBuilder builder = Jwts.builder().setAudience(this.tokenClientConfiguration.getBaseUrl() + TOKEN_URI).setIssuedAt(Date.from(now)).setExpiration(Date.from(now.plus(50L, ChronoUnit.MINUTES))).setIssuer(clientId).setSubject(clientId).claim("jti", (Object)UUID.randomUUID().toString()).signWith((Key)privateKey);
        if (Strings.hasText((String)this.tokenClientConfiguration.getKid())) {
            builder.setHeaderParam("kid", (Object)this.tokenClientConfiguration.getKid());
        }
        return builder.compact();
    }

    PrivateKey parsePrivateKey(Reader pemReader) throws IOException, InvalidKeyException {
        PrivateKey privateKey = this.getPrivateKeyFromPEM(pemReader);
        String algorithm = privateKey.getAlgorithm();
        if (!algorithm.equals("RSA") && !algorithm.equals("EC")) {
            throw new InvalidKeyException("Supplied privateKey is not an RSA or EC key - " + algorithm);
        }
        return privateKey;
    }

    private Reader getPemReader() throws IOException {
        String privateKey = this.tokenClientConfiguration.getPrivateKey();
        if (ConfigUtil.hasPrivateKeyContentWrapper(privateKey)) {
            return new StringReader(privateKey);
        }
        return Files.newBufferedReader(Paths.get(privateKey, new String[0]), Charset.defaultCharset());
    }

    PrivateKey getPrivateKeyFromPEM(Reader reader) throws IOException {
        PrivateKey privateKey;
        block15: {
            try (PEMParser pemParser = new PEMParser(reader);){
                JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
                Object pemContent = pemParser.readObject();
                if (pemContent == null) {
                    throw new IllegalArgumentException("Invalid Private Key PEM file");
                }
                if (pemContent instanceof PEMKeyPair) {
                    PEMKeyPair pemKeyPair = (PEMKeyPair)pemContent;
                    KeyPair keyPair = jcaPEMKeyConverter.getKeyPair(pemKeyPair);
                    privateKey = keyPair.getPrivate();
                    break block15;
                }
                if (pemContent instanceof PrivateKeyInfo) {
                    PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pemContent;
                    privateKey = jcaPEMKeyConverter.getPrivateKey(privateKeyInfo);
                    break block15;
                }
                throw new IllegalArgumentException("Unsupported Private Key format '" + pemContent.getClass().getSimpleName() + '\"');
            }
        }
        return privateKey;
    }

    ClientConfiguration constructTokenClientConfig(ClientConfiguration apiClientConfiguration) {
        ClientConfiguration tokenClientConfiguration = new ClientConfiguration();
        tokenClientConfiguration.setClientCredentialsResolver(new DefaultClientCredentialsResolver(Optional::empty));
        tokenClientConfiguration.setRequestAuthenticator((RequestAuthenticator)new DisabledAuthenticator());
        if (apiClientConfiguration.getBaseUrlResolver() != null) {
            tokenClientConfiguration.setBaseUrlResolver(apiClientConfiguration.getBaseUrlResolver());
        }
        if (apiClientConfiguration.getProxy() != null) {
            tokenClientConfiguration.setProxy(apiClientConfiguration.getProxy());
        }
        tokenClientConfiguration.setAuthenticationScheme(AuthenticationScheme.NONE);
        tokenClientConfiguration.setAuthorizationMode(AuthorizationMode.get((AuthenticationScheme)tokenClientConfiguration.getAuthenticationScheme()));
        tokenClientConfiguration.setClientId(apiClientConfiguration.getClientId());
        tokenClientConfiguration.setScopes(apiClientConfiguration.getScopes());
        tokenClientConfiguration.setPrivateKey(apiClientConfiguration.getPrivateKey());
        tokenClientConfiguration.setKid(apiClientConfiguration.getKid());
        tokenClientConfiguration.setRetryMaxElapsed(0);
        tokenClientConfiguration.setRetryMaxAttempts(1);
        return tokenClientConfiguration;
    }
}

