/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Strings;
import com.okta.sdk.resource.api.PolicyApi;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.Policy;
import com.okta.sdk.resource.model.PolicyType;
import com.okta.sdk.resource.policy.PolicyBuilder;
import java.util.Objects;

public class DefaultPolicyBuilder<T extends PolicyBuilder>
implements PolicyBuilder<T> {
    protected String name;
    protected String description;
    protected PolicyType policyType;
    protected Integer priority;
    protected LifecycleStatus status = LifecycleStatus.ACTIVE;
    protected Boolean isActive = true;

    DefaultPolicyBuilder() {
    }

    public T setName(String name) {
        this.name = name;
        return this.self();
    }

    public T setDescription(String description) {
        this.description = description;
        return this.self();
    }

    public T setType(PolicyType policyType) {
        this.policyType = policyType;
        return this.self();
    }

    public T setPriority(Integer priority) {
        this.priority = priority;
        return this.self();
    }

    public T setStatus(LifecycleStatus status) {
        this.status = status;
        this.isActive = LifecycleStatus.ACTIVE.equals((Object)status);
        return this.self();
    }

    protected T self() {
        return (T)this;
    }

    public Policy buildAndCreate(PolicyApi client) throws ApiException {
        try {
            return client.createPolicy(this.build(), this.isActive);
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    private Policy build() {
        Policy policy = new Policy();
        if (Strings.hasText((String)this.name)) {
            policy.setName(this.name);
        }
        if (Strings.hasText((String)this.description)) {
            policy.setDescription(this.description);
        }
        if (this.priority != null) {
            policy.setPriority(this.priority);
        }
        if (!Objects.nonNull(this.policyType)) {
            throw new IllegalArgumentException("PolicyType cannot be blank, needs to be specified.");
        }
        policy.setType(this.policyType);
        if (Objects.nonNull(this.status)) {
            policy.setStatus(this.status);
        }
        return policy;
    }
}

