/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.oauth2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.okta.commons.http.authc.DisabledAuthenticator;
import com.okta.commons.http.authc.RequestAuthenticator;
import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Strings;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.AuthorizationMode;
import com.okta.sdk.impl.api.DefaultClientCredentialsResolver;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.impl.oauth2.AccessTokenRetrieverService;
import com.okta.sdk.impl.oauth2.DPoPHandshakeException;
import com.okta.sdk.impl.oauth2.OAuth2AccessToken;
import com.okta.sdk.impl.oauth2.OAuth2HttpException;
import com.okta.sdk.impl.oauth2.OAuth2TokenRetrieverException;
import com.okta.sdk.impl.util.ConfigUtil;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.model.HttpMethod;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.lang.NestedCollection;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.SecurityException;
import io.jsonwebtoken.security.VerifySecureDigestRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Optional;
import java.util.UUID;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenRetrieverServiceImpl
implements AccessTokenRetrieverService {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenRetrieverServiceImpl.class);
    static final String TOKEN_URI = "/oauth2/v1/token";
    private static final KeyPair DUMMY_KEY_PAIR = (KeyPair)Jwts.SIG.RS256.keyPair().build();
    private final ClientConfiguration tokenClientConfiguration;
    private final ApiClient apiClient;
    private final CustomJwtSigningAlgorithm customJwtSigningAlgorithm = new CustomJwtSigningAlgorithm();

    public AccessTokenRetrieverServiceImpl(ClientConfiguration apiClientConfiguration, ApiClient apiClient) {
        Assert.notNull((Object)((Object)apiClientConfiguration), (String)"apiClientConfiguration must not be null.");
        Assert.notNull((Object)apiClient, (String)"apiClient must not be null.");
        this.apiClient = apiClient;
        this.tokenClientConfiguration = this.constructTokenClientConfig(apiClientConfiguration);
    }

    @Override
    public OAuth2AccessToken getOAuth2AccessToken() throws IOException, InvalidKeyException, OAuth2TokenRetrieverException {
        log.debug("Attempting to get OAuth2 access token for client id {} from {}", (Object)this.tokenClientConfiguration.getClientId(), (Object)(this.tokenClientConfiguration.getBaseUrl() + TOKEN_URI));
        String signedJwt = this.createSignedJWT();
        String scope = String.join((CharSequence)" ", this.tokenClientConfiguration.getScopes());
        try {
            HashMap<String, String> formParameters = new HashMap<String, String>();
            formParameters.put("grant_type", "client_credentials");
            formParameters.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            formParameters.put("client_assertion", signedJwt);
            formParameters.put("scope", scope);
            OAuth2AccessToken oAuth2AccessToken = (OAuth2AccessToken)this.apiClient.invokeAPI(TOKEN_URI, HttpMethod.POST.name(), new LinkedList(), new LinkedList(), null, null, new LinkedHashMap(), new LinkedHashMap(), formParameters, "application/json", "application/x-www-form-urlencoded", new String[]{"oauth2"}, (TypeReference)new TypeReference<OAuth2AccessToken>(){});
            log.debug("Got OAuth2 access token for client id {} from {}", (Object)this.tokenClientConfiguration.getClientId(), (Object)(this.tokenClientConfiguration.getBaseUrl() + TOKEN_URI));
            this.apiClient.setAccessToken(oAuth2AccessToken.getAccessToken());
            return oAuth2AccessToken;
        }
        catch (DPoPHandshakeException e) {
            if (e.continueHandshake) {
                return this.getOAuth2AccessToken();
            }
            throw new OAuth2HttpException(e.getMessage(), e, false);
        }
        catch (ApiException e) {
            throw new OAuth2HttpException(e.getMessage(), e, e.getCode() == 401);
        }
        catch (Exception e) {
            throw new OAuth2TokenRetrieverException("Exception while trying to get OAuth2 access token for client id " + this.tokenClientConfiguration.getClientId(), e);
        }
    }

    String createSignedJWT() throws InvalidKeyException, IOException {
        String clientId = this.tokenClientConfiguration.getClientId();
        Instant now = Instant.now();
        JwtBuilder builder = ((JwtBuilder)((NestedCollection)Jwts.builder().audience().add((Object)(this.tokenClientConfiguration.getBaseUrl() + TOKEN_URI))).and()).issuedAt(Date.from(now)).expiration(Date.from(now.plus(50L, ChronoUnit.MINUTES))).issuer(clientId).subject(clientId).claim("jti", (Object)UUID.randomUUID().toString());
        if (this.tokenClientConfiguration.hasCustomJwtSigner()) {
            builder.signWith((Key)DUMMY_KEY_PAIR.getPrivate(), (SecureDigestAlgorithm)this.customJwtSigningAlgorithm);
        } else {
            builder = builder.signWith((Key)this.parsePrivateKey(this.getPemReader()));
        }
        if (Strings.hasText((String)this.tokenClientConfiguration.getKid())) {
            builder.header().add((Object)"kid", (Object)this.tokenClientConfiguration.getKid());
        }
        return builder.compact();
    }

    PrivateKey parsePrivateKey(Reader pemReader) throws IOException, InvalidKeyException {
        PrivateKey privateKey = this.getPrivateKeyFromPEM(pemReader);
        String algorithm = privateKey.getAlgorithm();
        if (!algorithm.equals("RSA") && !algorithm.equals("EC")) {
            throw new InvalidKeyException("Supplied privateKey is not an RSA or EC key - " + algorithm);
        }
        return privateKey;
    }

    private Reader getPemReader() throws IOException {
        String privateKey = this.tokenClientConfiguration.getPrivateKey();
        if (ConfigUtil.hasPrivateKeyContentWrapper(privateKey)) {
            return new StringReader(privateKey);
        }
        return Files.newBufferedReader(Paths.get(privateKey, new String[0]), Charset.defaultCharset());
    }

    PrivateKey getPrivateKeyFromPEM(Reader reader) throws IOException {
        PrivateKey privateKey;
        block8: {
            try (PEMParser pemParser = new PEMParser(reader);){
                JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
                Object pemContent = pemParser.readObject();
                if (pemContent == null) {
                    throw new IllegalArgumentException("Invalid Private Key PEM file");
                }
                if (pemContent instanceof PEMKeyPair) {
                    PEMKeyPair pemKeyPair = (PEMKeyPair)pemContent;
                    KeyPair keyPair = jcaPEMKeyConverter.getKeyPair(pemKeyPair);
                    privateKey = keyPair.getPrivate();
                    break block8;
                }
                if (pemContent instanceof PrivateKeyInfo) {
                    PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pemContent;
                    privateKey = jcaPEMKeyConverter.getPrivateKey(privateKeyInfo);
                    break block8;
                }
                throw new IllegalArgumentException("Unsupported Private Key format '" + pemContent.getClass().getSimpleName() + '\"');
            }
        }
        return privateKey;
    }

    ClientConfiguration constructTokenClientConfig(ClientConfiguration apiClientConfiguration) {
        ClientConfiguration tokenClientConfiguration = new ClientConfiguration();
        tokenClientConfiguration.setClientCredentialsResolver(new DefaultClientCredentialsResolver(Optional::empty));
        tokenClientConfiguration.setRequestAuthenticator((RequestAuthenticator)new DisabledAuthenticator());
        if (apiClientConfiguration.getBaseUrlResolver() != null) {
            tokenClientConfiguration.setBaseUrlResolver(apiClientConfiguration.getBaseUrlResolver());
        }
        if (apiClientConfiguration.getProxy() != null) {
            tokenClientConfiguration.setProxy(apiClientConfiguration.getProxy());
        }
        tokenClientConfiguration.setBaseUrl(apiClientConfiguration.getBaseUrl());
        tokenClientConfiguration.setAuthenticationScheme(AuthenticationScheme.OAUTH2_PRIVATE_KEY);
        tokenClientConfiguration.setAuthorizationMode(AuthorizationMode.get((AuthenticationScheme)tokenClientConfiguration.getAuthenticationScheme()));
        tokenClientConfiguration.setClientId(apiClientConfiguration.getClientId());
        tokenClientConfiguration.setScopes(apiClientConfiguration.getScopes());
        tokenClientConfiguration.setPrivateKey(apiClientConfiguration.getPrivateKey());
        tokenClientConfiguration.setJwtSigner(apiClientConfiguration.getJwtSigner(), apiClientConfiguration.getJwtSigningAlgorithm());
        tokenClientConfiguration.setKid(apiClientConfiguration.getKid());
        tokenClientConfiguration.setRetryMaxElapsed(0);
        tokenClientConfiguration.setRetryMaxAttempts(1);
        return tokenClientConfiguration;
    }

    private class CustomJwtSigningAlgorithm
    implements SecureDigestAlgorithm<PrivateKey, Key> {
        private CustomJwtSigningAlgorithm() {
        }

        public byte[] digest(SecureRequest<InputStream, PrivateKey> request) throws SecurityException {
            try {
                byte[] bytes = this.readAllBytes((InputStream)request.getPayload());
                return (byte[])AccessTokenRetrieverServiceImpl.this.tokenClientConfiguration.getJwtSigner().apply(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private byte[] readAllBytes(InputStream payload) throws IOException {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = payload.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }

        public boolean verify(VerifySecureDigestRequest<Key> request) throws SecurityException {
            throw new UnsupportedOperationException();
        }

        public String getId() {
            return AccessTokenRetrieverServiceImpl.this.tokenClientConfiguration.getJwtSigningAlgorithm();
        }
    }
}

