/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.cache;

import com.okta.commons.lang.Assert;
import com.okta.sdk.cache.CacheConfigurationBuilder;
import com.okta.sdk.impl.cache.CacheConfiguration;
import com.okta.sdk.impl.cache.DefaultCacheConfiguration;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class DefaultCacheConfigurationBuilder
implements CacheConfigurationBuilder {
    private final String name;
    private Duration timeToLive;
    private Duration timeToIdle;

    public DefaultCacheConfigurationBuilder(String name) {
        Assert.hasText((String)name, (String)"Cache Region name cannot be null or empty.");
        this.name = name;
    }

    public CacheConfigurationBuilder withTimeToLive(long ttl, TimeUnit ttlTimeUnit) {
        this.timeToLive = DefaultCacheConfiguration.toDuration(ttl, ttlTimeUnit);
        return this;
    }

    public CacheConfigurationBuilder withTimeToIdle(long tti, TimeUnit ttiTimeUnit) {
        this.timeToIdle = DefaultCacheConfiguration.toDuration(tti, ttiTimeUnit);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Duration getTimeToLive() {
        return this.timeToLive;
    }

    public Duration getTimeToIdle() {
        return this.timeToIdle;
    }

    public CacheConfiguration build() {
        return new DefaultCacheConfiguration(this.getName(), this.getTimeToLive(), this.getTimeToIdle());
    }
}

