/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource;

import com.okta.commons.lang.Strings;
import com.okta.sdk.resource.api.ApplicationApi;
import com.okta.sdk.resource.application.ApplicationBuilder;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.model.Application;
import com.okta.sdk.resource.model.ApplicationAccessibility;
import com.okta.sdk.resource.model.ApplicationSignOnMode;
import com.okta.sdk.resource.model.ApplicationVisibility;
import com.okta.sdk.resource.model.ApplicationVisibilityHide;
import java.util.Objects;

public class DefaultApplicationBuilder<T extends ApplicationBuilder>
implements ApplicationBuilder<T> {
    protected String name;
    protected String label;
    protected String errorRedirectUrl;
    protected String loginRedirectUrl;
    protected Boolean selfService;
    protected ApplicationSignOnMode signOnMode;
    protected Boolean iOS;
    protected Boolean web;

    public T setName(String name) {
        this.name = name;
        return this.self();
    }

    public T setLabel(String label) {
        this.label = label;
        return this.self();
    }

    public T setErrorRedirectUrl(String errorRedirectUrl) {
        this.errorRedirectUrl = errorRedirectUrl;
        return this.self();
    }

    public T setLoginRedirectUrl(String loginRedirectUrl) {
        this.loginRedirectUrl = loginRedirectUrl;
        return this.self();
    }

    public T setSelfService(Boolean selfService) {
        this.selfService = selfService;
        return this.self();
    }

    public T setSignOnMode(ApplicationSignOnMode signOnMode) {
        this.signOnMode = signOnMode;
        return this.self();
    }

    public T setIOS(Boolean iOS) {
        this.iOS = iOS;
        return this.self();
    }

    public T setWeb(Boolean web) {
        this.web = web;
        return this.self();
    }

    protected T self() {
        return (T)this;
    }

    public Application buildAndCreate(ApplicationApi client) throws ApiException {
        return client.createApplication(this.build(), Boolean.valueOf(false), null);
    }

    private Application build() {
        Application application = new Application();
        if (Strings.hasText((String)this.label)) {
            application.setLabel(this.label);
        }
        if (Objects.nonNull(this.signOnMode)) {
            application.setSignOnMode(this.signOnMode);
        }
        ApplicationAccessibility applicationAccessibility = new ApplicationAccessibility();
        if (Strings.hasText((String)this.loginRedirectUrl)) {
            applicationAccessibility.setLoginRedirectUrl(this.loginRedirectUrl);
        }
        if (Strings.hasText((String)this.errorRedirectUrl)) {
            applicationAccessibility.setErrorRedirectUrl(this.errorRedirectUrl);
        }
        if (Objects.nonNull(this.selfService)) {
            applicationAccessibility.setSelfService(this.selfService);
        }
        application.setAccessibility(applicationAccessibility);
        ApplicationVisibility applicationVisibility = new ApplicationVisibility();
        ApplicationVisibilityHide applicationVisibilityHide = new ApplicationVisibilityHide();
        if (Objects.nonNull(this.iOS)) {
            applicationVisibilityHide.setiOS(this.iOS);
        }
        if (Objects.nonNull(this.web)) {
            applicationVisibilityHide.setWeb(this.web);
        }
        applicationVisibility.setHide(applicationVisibilityHide);
        application.setVisibility(applicationVisibility);
        return application;
    }
}

