/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.user.factor;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.user.factor.ActivateFactorRequest;
import com.okta.sdk.resource.user.factor.FactorProvider;
import com.okta.sdk.resource.user.factor.FactorStatus;
import com.okta.sdk.resource.user.factor.FactorType;
import com.okta.sdk.resource.user.factor.UserFactor;
import com.okta.sdk.resource.user.factor.VerifyFactorRequest;
import com.okta.sdk.resource.user.factor.VerifyUserFactorResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultUserFactor
extends AbstractInstanceResource<UserFactor>
implements UserFactor {
    private static final MapProperty embeddedProperty = new MapProperty("_embedded");
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final EnumProperty<FactorType> factorTypeProperty = new EnumProperty<FactorType>("factorType", FactorType.class);
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final EnumProperty<FactorProvider> providerProperty = new EnumProperty<FactorProvider>("provider", FactorProvider.class);
    private static final EnumProperty<FactorStatus> statusProperty = new EnumProperty<FactorStatus>("status", FactorStatus.class);
    private static final ResourceReference<VerifyFactorRequest> verifyProperty = new ResourceReference<VerifyFactorRequest>("verify", VerifyFactorRequest.class, false);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultUserFactor.createPropertyDescriptorMap(embeddedProperty, linksProperty, createdProperty, factorTypeProperty, idProperty, lastUpdatedProperty, providerProperty, statusProperty, verifyProperty);

    public DefaultUserFactor(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultUserFactor(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return UserFactor.class;
    }

    public Map<String, Object> getEmbedded() {
        return this.getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public FactorType getFactorType() {
        return this.getEnumProperty(factorTypeProperty);
    }

    public UserFactor setFactorType(FactorType factorType) {
        this.setProperty(factorTypeProperty, (Object)factorType);
        return this;
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public FactorProvider getProvider() {
        return this.getEnumProperty(providerProperty);
    }

    public UserFactor setProvider(FactorProvider provider) {
        this.setProperty(providerProperty, (Object)provider);
        return this;
    }

    public FactorStatus getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public VerifyFactorRequest getVerify() {
        return this.getResourceProperty(verifyProperty);
    }

    public UserFactor setVerify(VerifyFactorRequest verify) {
        this.setProperty(verifyProperty, (Object)verify);
        return this;
    }

    public void deleteFactor() {
        String factorId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}");
        String userId = pathArgs.get("userId");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/users/" + userId + "/factors/" + factorId + "", queryArgs, (Map<String, List<String>>)headers);
    }

    public UserFactor activate(ActivateFactorRequest body) {
        String factorId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate");
        String userId = pathArgs.get("userId");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/factors/" + factorId + "/lifecycle/activate", body != null ? body : this.getDataStore().instantiate(VoidResource.class), this, UserFactor.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public UserFactor activate() {
        String factorId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate");
        String userId = pathArgs.get("userId");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/factors/" + factorId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), null, UserFactor.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public VerifyUserFactorResponse verify(VerifyFactorRequest body, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage) {
        String factorId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/verify");
        String userId = pathArgs.get("userId");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (templateId != null) {
            queryArgs.put("templateId", templateId);
        }
        if (tokenLifetimeSeconds != null) {
            queryArgs.put("tokenLifetimeSeconds", tokenLifetimeSeconds);
        }
        HttpHeaders headers = new HttpHeaders();
        if (xForwardedFor != null) {
            headers.add("X-Forwarded-For", xForwardedFor);
        }
        if (userAgent != null) {
            headers.add("User-Agent", userAgent);
        }
        if (acceptLanguage != null) {
            headers.add("Accept-Language", acceptLanguage);
        }
        return this.getDataStore().create("/api/v1/users/" + userId + "/factors/" + factorId + "/verify", body != null ? body : this.getDataStore().instantiate(VoidResource.class), this, VerifyUserFactorResponse.class, (Map<String, Object>)queryArgs, (Map<String, List<String>>)headers);
    }

    public VerifyUserFactorResponse verify() {
        String factorId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/users/{userId}/factors/{factorId}/verify");
        String userId = pathArgs.get("userId");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        Assert.hasText((String)factorId, (String)"'factorId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        return this.getDataStore().create("/api/v1/users/" + userId + "/factors/" + factorId + "/verify", new DefaultVoidResource(this.getDataStore()), null, VerifyUserFactorResponse.class, queryArgs, (Map<String, List<String>>)headers);
    }
}

