/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.6.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.application;

import com.okta.sdk.resource.application.AppUser;
import com.okta.sdk.resource.application.AppUserCredentials;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * AppUser
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2021-08-27T17:24:26.937-05:00")
public class DefaultAppUser extends AbstractInstanceResource<AppUser> implements AppUser {

    private final static MapProperty embeddedProperty = new MapProperty("_embedded");
    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static ResourceReference<AppUserCredentials> credentialsProperty = new ResourceReference("credentials", AppUserCredentials.class, false);
    private final static StringProperty externalIdProperty = new StringProperty("externalId");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastSyncProperty = new DateProperty("lastSync");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static DateProperty passwordChangedProperty = new DateProperty("passwordChanged");
    private final static MapProperty profileProperty = new MapProperty("profile");
    private final static StringProperty scopeProperty = new StringProperty("scope");
    private final static StringProperty statusProperty = new StringProperty("status");
    private final static DateProperty statusChangedProperty = new DateProperty("statusChanged");
    private final static StringProperty syncStateProperty = new StringProperty("syncState");

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(embeddedProperty, linksProperty, createdProperty, credentialsProperty, externalIdProperty, idProperty, lastSyncProperty, lastUpdatedProperty, passwordChangedProperty, profileProperty, scopeProperty, statusProperty, statusChangedProperty, syncStateProperty);

    public DefaultAppUser(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultAppUser(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return AppUser.class;
    }

    public Map<String, Object> getEmbedded() {
        return  getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public AppUserCredentials getCredentials() {
        return  getResourceProperty(credentialsProperty);
    }

    public AppUser setCredentials(AppUserCredentials credentials) {
        setProperty(credentialsProperty, credentials);
        return this;
    }

    public String getExternalId() {
        return  getString(externalIdProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public AppUser setId(String id) {
        setProperty(idProperty, id);
        return this;
    }

    public Date getLastSync() {
        return  getDateProperty(lastSyncProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public Date getPasswordChanged() {
        return  getDateProperty(passwordChangedProperty);
    }

    public Map<String, Object> getProfile() {
        return  getMap(profileProperty);
    }

    public AppUser setProfile(Map<String, Object> profile) {
        setProperty(profileProperty, profile);
        return this;
    }

    public String getScope() {
        return  getString(scopeProperty);
    }

    public AppUser setScope(String scope) {
        setProperty(scopeProperty, scope);
        return this;
    }

    public String getStatus() {
        return  getString(statusProperty);
    }

    public Date getStatusChanged() {
        return  getDateProperty(statusChangedProperty);
    }

    public String getSyncState() {
        return  getString(syncStateProperty);
    }


    /**
    * Update Application Profile for Assigned User
    * Updates a user&#39;s profile for an application
    * @return AppUser
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "POST - /api/v1/apps/{appId}/users/{userId}")
    public AppUser update() {

        String userId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/apps/{appId}/users/{userId}");
        String appId = pathArgs.get("appId");

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        AppUser appUser = this;
        getDataStore().create(
            "/api/v1/apps/" + appId + "/users/" + userId + "",
            this,
            this,
            AppUser.class,
            queryArgs,
            headers);
        return appUser;

    }




    /**
    * Remove User from Application
    * Removes an assignment for a user from an application.
    * @param sendEmail  (optional, default to false)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "DELETE - /api/v1/apps/{appId}/users/{userId}")
    public void delete(Boolean sendEmail) {

        String userId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/apps/{appId}/users/{userId}");
        String appId = pathArgs.get("appId");

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (sendEmail != null) queryArgs.put("sendEmail", sendEmail);

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/apps/" + appId + "/users/" + userId + "",
            (Resource) this,
            queryArgs,
            headers);
    }

    /**
    * Remove User from Application
    * Removes an assignment for a user from an application.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "DELETE - /api/v1/apps/{appId}/users/{userId}")
    public void delete() {

        String userId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/apps/{appId}/users/{userId}");
        String appId = pathArgs.get("appId");

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/apps/" + appId + "/users/" + userId + "",
            (Resource) this,
            queryArgs,
            headers);
     }



}
