/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.6.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.network.zone;

import com.okta.sdk.resource.network.zone.NetworkZone;
import com.okta.sdk.resource.network.zone.NetworkZoneAddress;
import com.okta.sdk.resource.network.zone.NetworkZoneLocation;
import com.okta.sdk.resource.network.zone.NetworkZoneStatus;
import com.okta.sdk.resource.network.zone.NetworkZoneType;
import com.okta.sdk.resource.network.zone.NetworkZoneUsage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * NetworkZone
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2021-08-27T17:24:26.937-05:00")
public class DefaultNetworkZone extends AbstractInstanceResource<NetworkZone> implements NetworkZone {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static ListProperty asnsProperty = new ListProperty("asns");
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static ResourceListProperty<NetworkZoneAddress> gatewaysProperty = new ResourceListProperty("gateways", NetworkZoneAddress.class);
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static ResourceListProperty<NetworkZoneLocation> locationsProperty = new ResourceListProperty("locations", NetworkZoneLocation.class);
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static ResourceListProperty<NetworkZoneAddress> proxiesProperty = new ResourceListProperty("proxies", NetworkZoneAddress.class);
    private final static StringProperty proxyTypeProperty = new StringProperty("proxyType");
    private final static EnumProperty<NetworkZoneStatus> statusProperty = new EnumProperty("status", NetworkZoneStatus.class);
    private final static BooleanProperty systemProperty = new BooleanProperty("system");
    private final static EnumProperty<NetworkZoneType> typeProperty = new EnumProperty("type", NetworkZoneType.class);
    private final static EnumProperty<NetworkZoneUsage> usageProperty = new EnumProperty("usage", NetworkZoneUsage.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, asnsProperty, createdProperty, gatewaysProperty, idProperty, lastUpdatedProperty, locationsProperty, nameProperty, proxiesProperty, proxyTypeProperty, statusProperty, systemProperty, typeProperty, usageProperty);

    public DefaultNetworkZone(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultNetworkZone(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return NetworkZone.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public List<String> getAsns() {
        return (List<String>) getListProperty(asnsProperty);
    }

    public NetworkZone setAsns(List<String> asns) {
        setProperty(asnsProperty, asns);
        return this;
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public List<NetworkZoneAddress> getGateways() {
        return (List<NetworkZoneAddress>) getResourceListProperty(gatewaysProperty);
    }

    public NetworkZone setGateways(List<NetworkZoneAddress> gateways) {
        setProperty(gatewaysProperty, gateways);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public List<NetworkZoneLocation> getLocations() {
        return (List<NetworkZoneLocation>) getResourceListProperty(locationsProperty);
    }

    public NetworkZone setLocations(List<NetworkZoneLocation> locations) {
        setProperty(locationsProperty, locations);
        return this;
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public NetworkZone setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public List<NetworkZoneAddress> getProxies() {
        return (List<NetworkZoneAddress>) getResourceListProperty(proxiesProperty);
    }

    public NetworkZone setProxies(List<NetworkZoneAddress> proxies) {
        setProperty(proxiesProperty, proxies);
        return this;
    }

    public String getProxyType() {
        return  getString(proxyTypeProperty);
    }

    public NetworkZone setProxyType(String proxyType) {
        setProperty(proxyTypeProperty, proxyType);
        return this;
    }

    public NetworkZoneStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public NetworkZone setStatus(NetworkZoneStatus status) {
        setProperty(statusProperty, status);
        return this;
    }

    public Boolean getSystem() {
        return  getBoolean(systemProperty);
    }

    public NetworkZone setSystem(Boolean system) {
        setProperty(systemProperty, system);
        return this;
    }

    public NetworkZoneType getType() {
        return  getEnumProperty(typeProperty);
    }

    public NetworkZone setType(NetworkZoneType type) {
        setProperty(typeProperty, type);
        return this;
    }

    public NetworkZoneUsage getUsage() {
        return  getEnumProperty(usageProperty);
    }

    public NetworkZone setUsage(NetworkZoneUsage usage) {
        setProperty(usageProperty, usage);
        return this;
    }


    /**
    * Delete Network Zone
    * Removes network zone.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "DELETE - /api/v1/zones/{zoneId}")
    public void delete() {

        String zoneId = getId();

        hasText(zoneId, "'zoneId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/zones/" + zoneId + "",
            (Resource) this,
            queryArgs,
            headers);
    }




    /**
    * Deactivate Network Zone
    * Deactivates a network zone.
    * @return NetworkZone
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "POST - /api/v1/zones/{zoneId}/lifecycle/deactivate")
    public NetworkZone deactivate() {

        String zoneId = getId();

        hasText(zoneId, "'zoneId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/zones/" + zoneId + "/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            NetworkZone.class,
            queryArgs,
            headers);

    }




    /**
    * Update Network Zone
    * Updates a network zone in your organization.
    * @return NetworkZone
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "PUT - /api/v1/zones/{zoneId}")
    public NetworkZone update() {

        String zoneId = getId();

        hasText(zoneId, "'zoneId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/zones/" + zoneId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }




    /**
    * Activate Network Zone
    * Activate Network Zone
    * @return NetworkZone
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "POST - /api/v1/zones/{zoneId}/lifecycle/activate")
    public NetworkZone activate() {

        String zoneId = getId();

        hasText(zoneId, "'zoneId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/zones/" + zoneId + "/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            this,
            NetworkZone.class,
            queryArgs,
            headers);

    }



}
