/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.6.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.policy;

import com.okta.sdk.resource.policy.PolicyRule;
import com.okta.sdk.resource.policy.PolicyRuleActions;
import com.okta.sdk.resource.policy.PolicyRuleConditions;
import java.util.Date;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * PolicyRule
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2021-08-27T17:24:26.937-05:00")
public class DefaultPolicyRule extends AbstractInstanceResource<PolicyRule> implements PolicyRule {

    private final static ResourceReference<PolicyRuleActions> actionsProperty = new ResourceReference("actions", PolicyRuleActions.class, false);
    private final static ResourceReference<PolicyRuleConditions> conditionsProperty = new ResourceReference("conditions", PolicyRuleConditions.class, false);
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static IntegerProperty priorityProperty = new IntegerProperty("priority");
    private final static EnumProperty<StatusEnum> statusProperty = new EnumProperty("status", StatusEnum.class);
    private final static BooleanProperty systemProperty = new BooleanProperty("system");
    private final static EnumProperty<TypeEnum> typeProperty = new EnumProperty("type", TypeEnum.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(actionsProperty, conditionsProperty, createdProperty, idProperty, lastUpdatedProperty, nameProperty, priorityProperty, statusProperty, systemProperty, typeProperty);

    public DefaultPolicyRule(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultPolicyRule(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return PolicyRule.class;
    }

    public PolicyRuleActions getActions() {
        return  getResourceProperty(actionsProperty);
    }

    public PolicyRule setActions(PolicyRuleActions actions) {
        setProperty(actionsProperty, actions);
        return this;
    }

    public PolicyRuleConditions getConditions() {
        return  getResourceProperty(conditionsProperty);
    }

    public PolicyRule setConditions(PolicyRuleConditions conditions) {
        setProperty(conditionsProperty, conditions);
        return this;
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public PolicyRule setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public Integer getPriority() {
        return  getIntProperty(priorityProperty);
    }

    public PolicyRule setPriority(Integer priority) {
        setProperty(priorityProperty, priority);
        return this;
    }

    public StatusEnum getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public PolicyRule setStatus(StatusEnum status) {
        setProperty(statusProperty, status);
        return this;
    }

    public Boolean getSystem() {
        return  getBoolean(systemProperty);
    }

    public PolicyRule setSystem(Boolean system) {
        setProperty(systemProperty, system);
        return this;
    }

    public TypeEnum getType() {
        return  getEnumProperty(typeProperty);
    }

    public PolicyRule setType(TypeEnum type) {
        setProperty(typeProperty, type);
        return this;
    }


    /**
    * 
    * Updates a policy rule.
    * @return PolicyRule
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "PUT - /api/v1/policies/{policyId}/rules/{ruleId}")
    public PolicyRule update() {

        String ruleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/policies/{policyId}/rules/{ruleId}");
        String policyId = pathArgs.get("policyId");

        hasText(policyId, "'policyId' is required and cannot be null or empty.");
        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/policies/" + policyId + "/rules/" + ruleId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }




    /**
    * 
    * Activates a policy rule.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "POST - /api/v1/policies/{policyId}/rules/{ruleId}/lifecycle/activate")
    public void activate() {

        String ruleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/policies/{policyId}/rules/{ruleId}/lifecycle/activate");
        String policyId = pathArgs.get("policyId");

        hasText(policyId, "'policyId' is required and cannot be null or empty.");
        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/policies/" + policyId + "/rules/" + ruleId + "/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Deactivates a policy rule.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "POST - /api/v1/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate")
    public void deactivate() {

        String ruleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate");
        String policyId = pathArgs.get("policyId");

        hasText(policyId, "'policyId' is required and cannot be null or empty.");
        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/policies/" + policyId + "/rules/" + ruleId + "/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Removes a policy rule.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "DELETE - /api/v1/policies/{policyId}/rules/{ruleId}")
    public void delete() {

        String ruleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/policies/{policyId}/rules/{ruleId}");
        String policyId = pathArgs.get("policyId");

        hasText(policyId, "'policyId' is required and cannot be null or empty.");
        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/policies/" + policyId + "/rules/" + ruleId + "",
            (Resource) this,
            queryArgs,
            headers);
    }



}
