/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.6.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.template;

import com.okta.sdk.resource.template.SmsTemplate;
import com.okta.sdk.resource.template.SmsTemplateTranslations;
import com.okta.sdk.resource.template.SmsTemplateType;
import java.util.Date;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * SmsTemplate
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2021-08-27T17:24:26.937-05:00")
public class DefaultSmsTemplate extends AbstractInstanceResource<SmsTemplate> implements SmsTemplate {

    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static StringProperty templateProperty = new StringProperty("template");
    private final static ResourceReference<SmsTemplateTranslations> translationsProperty = new ResourceReference("translations", SmsTemplateTranslations.class, false);
    private final static EnumProperty<SmsTemplateType> typeProperty = new EnumProperty("type", SmsTemplateType.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(createdProperty, idProperty, lastUpdatedProperty, nameProperty, templateProperty, translationsProperty, typeProperty);

    public DefaultSmsTemplate(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultSmsTemplate(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return SmsTemplate.class;
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public SmsTemplate setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public String getTemplate() {
        return  getString(templateProperty);
    }

    public SmsTemplate setTemplate(String template) {
        setProperty(templateProperty, template);
        return this;
    }

    public SmsTemplateTranslations getTranslations() {
        return  getResourceProperty(translationsProperty);
    }

    public SmsTemplate setTranslations(SmsTemplateTranslations translations) {
        setProperty(translationsProperty, translations);
        return this;
    }

    public SmsTemplateType getType() {
        return  getEnumProperty(typeProperty);
    }

    public SmsTemplate setType(SmsTemplateType type) {
        setProperty(typeProperty, type);
        return this;
    }


    /**
    * Partial SMS Template Update
    * Updates only some of the SMS template properties:
    * @return SmsTemplate
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "POST - /api/v1/templates/sms/{templateId}")
    public SmsTemplate partialUpdate() {

        String templateId = getId();

        hasText(templateId, "'templateId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        SmsTemplate smsTemplate = this;
        getDataStore().create(
            "/api/v1/templates/sms/" + templateId + "",
            this,
            this,
            SmsTemplate.class,
            queryArgs,
            headers);
        return smsTemplate;

    }




    /**
    * Remove SMS Template
    * Removes an SMS template.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "DELETE - /api/v1/templates/sms/{templateId}")
    public void delete() {

        String templateId = getId();

        hasText(templateId, "'templateId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/templates/sms/" + templateId + "",
            (Resource) this,
            queryArgs,
            headers);
    }




    /**
    * Update SMS Template
    * Updates the SMS template.
    * @return SmsTemplate
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "PUT - /api/v1/templates/sms/{templateId}")
    public SmsTemplate update() {

        String templateId = getId();

        hasText(templateId, "'templateId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/templates/sms/" + templateId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }



}
