/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.6.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.user.type;

import com.okta.sdk.resource.user.type.UserType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * UserType
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2021-08-27T17:24:26.937-05:00")
public class DefaultUserType extends AbstractInstanceResource<UserType> implements UserType {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty createdByProperty = new StringProperty("createdBy");
    private final static BooleanProperty _defaultProperty = new BooleanProperty("default");
    private final static StringProperty descriptionProperty = new StringProperty("description");
    private final static StringProperty displayNameProperty = new StringProperty("displayName");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static StringProperty lastUpdatedByProperty = new StringProperty("lastUpdatedBy");
    private final static StringProperty nameProperty = new StringProperty("name");

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, createdProperty, createdByProperty, _defaultProperty, descriptionProperty, displayNameProperty, idProperty, lastUpdatedProperty, lastUpdatedByProperty, nameProperty);

    public DefaultUserType(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultUserType(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return UserType.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getCreatedBy() {
        return  getString(createdByProperty);
    }

    public Boolean getDefault() {
        return  getBoolean(_defaultProperty);
    }

    public String getDescription() {
        return  getString(descriptionProperty);
    }

    public UserType setDescription(String description) {
        setProperty(descriptionProperty, description);
        return this;
    }

    public String getDisplayName() {
        return  getString(displayNameProperty);
    }

    public UserType setDisplayName(String displayName) {
        setProperty(displayNameProperty, displayName);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public UserType setId(String id) {
        setProperty(idProperty, id);
        return this;
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public String getLastUpdatedBy() {
        return  getString(lastUpdatedByProperty);
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public UserType setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }


    /**
    * 
    * Deletes a User Type permanently. This operation is not permitted for the default type, nor for any User Type that has existing users
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "DELETE - /api/v1/meta/types/user/{typeId}")
    public void delete() {

        String typeId = getId();

        hasText(typeId, "'typeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/meta/types/user/" + typeId + "",
            (Resource) this,
            queryArgs,
            headers);
    }




    /**
    * 
    * Updates an existing User Type
    * @return UserType
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "POST - /api/v1/meta/types/user/{typeId}")
    public UserType update() {

        String typeId = getId();

        hasText(typeId, "'typeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        UserType userType = this;
        getDataStore().create(
            "/api/v1/meta/types/user/" + typeId + "",
            this,
            this,
            UserType.class,
            queryArgs,
            headers);
        return userType;

    }




    /**
    * 
    * Replace an existing User Type
    * @param typeId  (required)
    * @param userType  (required)
    * @return UserType
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2021-08-27T17:24:26.937-05:00",
          comments = "PUT - /api/v1/meta/types/user/{typeId}")
    public UserType replaceUserType(String typeId, UserType userType) {



        notNull(userType, "'userType' is required and cannot be null.");
        hasText(typeId, "'typeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/meta/types/user/" + typeId + "";
        getDataStore().save(href, userType, this, queryArgs, headers);
        return  userType;

    }



}
