/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.client;

import com.okta.commons.configcheck.ConfigurationValidator;
import com.okta.commons.http.RequestExecutorFactory;
import com.okta.commons.http.config.BaseUrlResolver;
import com.okta.commons.http.config.HttpClientConfiguration;
import com.okta.commons.http.config.Proxy;
import com.okta.commons.lang.Assert;
import com.okta.commons.lang.Classes;
import com.okta.commons.lang.Strings;
import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.cache.CacheConfigurationBuilder;
import com.okta.sdk.cache.CacheManager;
import com.okta.sdk.cache.CacheManagerBuilder;
import com.okta.sdk.cache.Caches;
import com.okta.sdk.client.AuthenticationScheme;
import com.okta.sdk.client.AuthorizationMode;
import com.okta.sdk.client.Client;
import com.okta.sdk.client.ClientBuilder;
import com.okta.sdk.impl.api.ClientCredentialsResolver;
import com.okta.sdk.impl.api.DefaultClientCredentialsResolver;
import com.okta.sdk.impl.client.DefaultClient;
import com.okta.sdk.impl.config.ClientConfiguration;
import com.okta.sdk.impl.config.EnvironmentVariablesPropertiesSource;
import com.okta.sdk.impl.config.OptionalPropertiesSource;
import com.okta.sdk.impl.config.PropertiesSource;
import com.okta.sdk.impl.config.ResourcePropertiesSource;
import com.okta.sdk.impl.config.SystemPropertiesSource;
import com.okta.sdk.impl.config.YAMLPropertiesSource;
import com.okta.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.okta.sdk.impl.io.DefaultResourceFactory;
import com.okta.sdk.impl.io.Resource;
import com.okta.sdk.impl.io.ResourceFactory;
import com.okta.sdk.impl.oauth2.AccessTokenRetrieverService;
import com.okta.sdk.impl.oauth2.AccessTokenRetrieverServiceImpl;
import com.okta.sdk.impl.oauth2.OAuth2ClientCredentials;
import com.okta.sdk.impl.util.ConfigUtil;
import com.okta.sdk.impl.util.DefaultBaseUrlResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientBuilder
implements ClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultClientBuilder.class);
    private static final String ENVVARS_TOKEN = "envvars";
    private static final String SYSPROPS_TOKEN = "sysprops";
    private static final String OKTA_CONFIG_CP = "com/okta/sdk/config/";
    private static final String OKTA_YAML = "okta.yaml";
    private static final String OKTA_PROPERTIES = "okta.properties";
    private static final String OKTA_REQUEST_EXECUTOR_PREFIX = "okta.client.requestExecutor.";
    private CacheManager cacheManager;
    private ClientCredentials clientCredentials;
    private boolean allowNonHttpsForTesting = false;
    private ClientConfiguration clientConfig = new ClientConfiguration();
    private RequestExecutorFactory requestExecutorFactory;
    private AccessTokenRetrieverService accessTokenRetrieverService;

    public DefaultClientBuilder() {
        this(new DefaultResourceFactory());
    }

    DefaultClientBuilder(ResourceFactory resourceFactory) {
        ArrayList<PropertiesSource> sources = new ArrayList<PropertiesSource>();
        for (String location : DefaultClientBuilder.configSources()) {
            if (ENVVARS_TOKEN.equalsIgnoreCase(location)) {
                sources.add(EnvironmentVariablesPropertiesSource.oktaFilteredPropertiesSource());
                continue;
            }
            if (SYSPROPS_TOKEN.equalsIgnoreCase(location)) {
                sources.add(SystemPropertiesSource.oktaFilteredPropertiesSource());
                continue;
            }
            Resource resource = resourceFactory.createResource(location);
            PropertiesSource wrappedSource = Strings.endsWithIgnoreCase((String)location, (String)".yaml") ? new YAMLPropertiesSource(resource) : new ResourcePropertiesSource(resource);
            OptionalPropertiesSource propertiesSource = new OptionalPropertiesSource(wrappedSource);
            sources.add(propertiesSource);
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (PropertiesSource source : sources) {
            Map<String, String> srcProps = source.getProperties();
            props.putAll(srcProps);
        }
        if (Strings.hasText((String)((String)props.get("okta.client.token")))) {
            this.clientConfig.setApiToken((String)props.get("okta.client.token"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.cache.enabled")))) {
            this.clientConfig.setCacheManagerEnabled(Boolean.valueOf((String)props.get("okta.client.cache.enabled")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.cache.defaultTtl")))) {
            this.clientConfig.setCacheManagerTtl(Long.parseLong((String)props.get("okta.client.cache.defaultTtl")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.cache.defaultTti")))) {
            this.clientConfig.setCacheManagerTti(Long.parseLong((String)props.get("okta.client.cache.defaultTti")));
        }
        for (String prop : props.keySet()) {
            boolean isPrefix = prop.length() == "okta.client.cache.caches".length();
            if (isPrefix || !prop.startsWith("okta.client.cache.caches")) continue;
            String cacheClass = prop.substring("okta.client.cache.caches".length() + 1, prop.length() - 4);
            String cacheTti = (String)props.get("okta.client.cache.caches." + cacheClass + ".tti");
            String cacheTtl = (String)props.get("okta.client.cache.caches." + cacheClass + ".ttl");
            CacheConfigurationBuilder cacheBuilder = Caches.forResource((Class)Classes.forName((String)cacheClass));
            if (Strings.hasText((String)cacheTti)) {
                cacheBuilder.withTimeToIdle(Long.parseLong(cacheTti), TimeUnit.SECONDS);
            }
            if (Strings.hasText((String)cacheTtl)) {
                cacheBuilder.withTimeToLive(Long.parseLong(cacheTtl), TimeUnit.SECONDS);
            }
            if (this.clientConfig.getCacheManagerCaches().containsKey(cacheClass)) continue;
            this.clientConfig.getCacheManagerCaches().put(cacheClass, cacheBuilder);
        }
        if (Strings.hasText((String)((String)props.get("okta.testing.disableHttpsCheck")))) {
            this.allowNonHttpsForTesting = Boolean.valueOf((String)props.get("okta.testing.disableHttpsCheck"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.orgUrl")))) {
            String baseUrl = (String)props.get("okta.client.orgUrl");
            baseUrl = baseUrl.replace("\\:", ":");
            ConfigurationValidator.assertOrgUrl((String)baseUrl, (boolean)this.allowNonHttpsForTesting);
            this.clientConfig.setBaseUrl(baseUrl);
        }
        if (Strings.hasText((String)((String)props.get("okta.client.connectionTimeout")))) {
            this.clientConfig.setConnectionTimeout(Integer.parseInt((String)props.get("okta.client.connectionTimeout")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.authenticationScheme")))) {
            this.clientConfig.setAuthenticationScheme(Enum.valueOf(AuthenticationScheme.class, (String)props.get("okta.client.authenticationScheme")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.proxy.port")))) {
            this.clientConfig.setProxyPort(Integer.parseInt((String)props.get("okta.client.proxy.port")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.proxy.host")))) {
            this.clientConfig.setProxyHost((String)props.get("okta.client.proxy.host"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.proxy.username")))) {
            this.clientConfig.setProxyUsername((String)props.get("okta.client.proxy.username"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.proxy.password")))) {
            this.clientConfig.setProxyPassword((String)props.get("okta.client.proxy.password"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.authorizationMode")))) {
            this.clientConfig.setAuthorizationMode(AuthorizationMode.getAuthorizationMode((String)((String)props.get("okta.client.authorizationMode"))));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.clientId")))) {
            this.clientConfig.setClientId((String)props.get("okta.client.clientId"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.scopes")))) {
            HashSet<String> scopes = new HashSet<String>(Arrays.asList(((String)props.get("okta.client.scopes")).split("[\\s,]+")));
            this.clientConfig.setScopes(scopes);
        }
        if (Strings.hasText((String)((String)props.get("okta.client.privateKey")))) {
            this.clientConfig.setPrivateKey((String)props.get("okta.client.privateKey"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.kid")))) {
            this.clientConfig.setKid((String)props.get("okta.client.kid"));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.requestTimeout")))) {
            this.clientConfig.setRetryMaxElapsed(Integer.parseInt((String)props.get("okta.client.requestTimeout")));
        }
        if (Strings.hasText((String)((String)props.get("okta.client.rateLimit.maxRetries")))) {
            this.clientConfig.setRetryMaxAttempts(Integer.parseInt((String)props.get("okta.client.rateLimit.maxRetries")));
        }
        this.clientConfig.setRequestExecutorParams(props.entrySet().stream().filter(x -> ((String)x.getKey()).toLowerCase().startsWith(OKTA_REQUEST_EXECUTOR_PREFIX.toLowerCase())).collect(Collectors.toMap(k -> {
            String camelCaseString = Arrays.stream(((String)k.getKey()).substring(OKTA_REQUEST_EXECUTOR_PREFIX.length()).split("\\.")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(""));
            return camelCaseString.substring(0, 1).toLowerCase() + camelCaseString.substring(1);
        }, v -> (String)v.getValue(), (oldValue, newValue) -> newValue)));
    }

    public ClientBuilder setProxy(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy argument cannot be null.");
        }
        this.clientConfig.setProxyHost(proxy.getHost());
        this.clientConfig.setProxyPort(proxy.getPort());
        this.clientConfig.setProxyUsername(proxy.getUsername());
        this.clientConfig.setProxyPassword(proxy.getPassword());
        return this;
    }

    public ClientBuilder setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        return this;
    }

    public ClientBuilder setConnectionTimeout(int timeout) {
        Assert.isTrue((timeout >= 0 ? 1 : 0) != 0, (String)"Timeout cannot be a negative number.");
        this.clientConfig.setConnectionTimeout(timeout);
        return this;
    }

    public ClientBuilder setClientCredentials(ClientCredentials clientCredentials) {
        Assert.isInstanceOf(ClientCredentials.class, (Object)clientCredentials);
        this.clientCredentials = clientCredentials;
        return this;
    }

    public ClientBuilder setRequestAuthenticatorFactory(RequestAuthenticatorFactory factory) {
        Assert.notNull((Object)factory, (String)"factory argument cannot be null");
        this.clientConfig.setRequestAuthenticatorFactory(factory);
        return this;
    }

    public ClientBuilder setClientCredentialsResolver(ClientCredentialsResolver clientCredentialsResolver) {
        Assert.notNull((Object)clientCredentialsResolver, (String)"clientCredentialsResolver must not be null.");
        this.clientConfig.setClientCredentialsResolver(clientCredentialsResolver);
        return this;
    }

    public ClientBuilder setBaseUrlResolver(BaseUrlResolver baseUrlResolver) {
        Assert.notNull((Object)baseUrlResolver, (String)"baseUrlResolver must not be null");
        this.clientConfig.setBaseUrlResolver(baseUrlResolver);
        return this;
    }

    public ClientBuilder setRetryMaxElapsed(int maxElapsed) {
        this.clientConfig.setRetryMaxElapsed(maxElapsed);
        return this;
    }

    public ClientBuilder setRetryMaxAttempts(int maxAttempts) {
        this.clientConfig.setRetryMaxAttempts(maxAttempts);
        return this;
    }

    public ClientBuilder setRequestExecutorFactory(RequestExecutorFactory requestExecutorFactory) {
        this.requestExecutorFactory = requestExecutorFactory;
        return this;
    }

    public Client build() {
        if (!this.clientConfig.isCacheManagerEnabled()) {
            log.debug("CacheManager disabled. Defaulting to DisabledCacheManager");
            this.cacheManager = Caches.newDisabledCacheManager();
        } else if (this.cacheManager == null) {
            log.debug("No CacheManager configured. Defaulting to in-memory CacheManager with default TTL and TTI of five minutes.");
            CacheManagerBuilder cacheManagerBuilder = Caches.newCacheManager().withDefaultTimeToIdle(this.clientConfig.getCacheManagerTti(), TimeUnit.SECONDS).withDefaultTimeToLive(this.clientConfig.getCacheManagerTtl(), TimeUnit.SECONDS);
            if (this.clientConfig.getCacheManagerCaches().size() > 0) {
                for (CacheConfigurationBuilder builder : this.clientConfig.getCacheManagerCaches().values()) {
                    cacheManagerBuilder.withCache(builder);
                }
            }
            this.cacheManager = cacheManagerBuilder.build();
        }
        if (this.clientConfig.getBaseUrlResolver() == null) {
            ConfigurationValidator.assertOrgUrl((String)this.clientConfig.getBaseUrl(), (boolean)this.allowNonHttpsForTesting);
            this.clientConfig.setBaseUrlResolver(new DefaultBaseUrlResolver(this.clientConfig.getBaseUrl()));
        }
        if (!this.isOAuth2Flow()) {
            if (this.clientConfig.getClientCredentialsResolver() == null && this.clientCredentials != null) {
                this.clientConfig.setClientCredentialsResolver(new DefaultClientCredentialsResolver(this.clientCredentials));
            } else if (this.clientConfig.getClientCredentialsResolver() == null) {
                this.clientConfig.setClientCredentialsResolver(new DefaultClientCredentialsResolver(this.clientConfig));
            }
        } else {
            this.clientConfig.setAuthenticationScheme(AuthenticationScheme.OAUTH2_PRIVATE_KEY);
            this.validateOAuth2ClientConfig(this.clientConfig);
            this.accessTokenRetrieverService = new AccessTokenRetrieverServiceImpl(this.clientConfig);
            OAuth2ClientCredentials oAuth2ClientCredentials = new OAuth2ClientCredentials(this.accessTokenRetrieverService);
            this.clientConfig.setClientCredentialsResolver(new DefaultClientCredentialsResolver(oAuth2ClientCredentials));
        }
        return this.requestExecutorFactory == null ? new DefaultClient(this.clientConfig, this.cacheManager) : new DefaultClient(this.clientConfig, this.cacheManager, this.requestExecutorFactory.create((HttpClientConfiguration)this.clientConfig));
    }

    private void validateOAuth2ClientConfig(ClientConfiguration clientConfiguration) {
        Assert.notNull((Object)clientConfiguration.getClientId(), (String)"clientId cannot be null");
        Assert.isTrue((clientConfiguration.getScopes() != null && !clientConfiguration.getScopes().isEmpty() ? 1 : 0) != 0, (String)"At least one scope is required");
        String privateKey = clientConfiguration.getPrivateKey();
        Assert.hasText((String)privateKey, (String)"privateKey cannot be null (either PEM file path (or) full PEM content must be supplied)");
        if (!ConfigUtil.hasPrivateKeyContentWrapper(privateKey)) {
            Path privateKeyPemFilePath;
            try {
                privateKeyPemFilePath = Paths.get(privateKey, new String[0]);
            }
            catch (InvalidPathException ipe) {
                throw new IllegalArgumentException("Invalid privateKey file path", ipe);
            }
            boolean privateKeyPemFileExists = Files.exists(privateKeyPemFilePath, LinkOption.NOFOLLOW_LINKS);
            Assert.isTrue((boolean)privateKeyPemFileExists, (String)"privateKey file does not exist");
        }
    }

    public ClientBuilder setOrgUrl(String baseUrl) {
        ConfigurationValidator.assertOrgUrl((String)baseUrl, (boolean)this.allowNonHttpsForTesting);
        this.clientConfig.setBaseUrl(baseUrl);
        return this;
    }

    public ClientBuilder setAuthorizationMode(AuthorizationMode authorizationMode) {
        this.clientConfig.setAuthorizationMode(authorizationMode);
        this.clientConfig.setAuthenticationScheme(authorizationMode.getAuthenticationScheme());
        return this;
    }

    public ClientBuilder setScopes(Set<String> scopes) {
        if (this.isOAuth2Flow()) {
            Assert.isTrue((scopes != null && !scopes.isEmpty() ? 1 : 0) != 0, (String)"At least one scope is required");
            this.clientConfig.setScopes(scopes);
        }
        return this;
    }

    public ClientBuilder setPrivateKey(String privateKey) {
        if (this.isOAuth2Flow()) {
            Assert.notNull((Object)privateKey, (String)"Missing privateKey");
            this.clientConfig.setPrivateKey(privateKey);
        }
        return this;
    }

    public ClientBuilder setPrivateKey(Path privateKeyPath) {
        if (this.isOAuth2Flow()) {
            Assert.notNull((Object)privateKeyPath, (String)"Missing privateKeyFile");
            this.clientConfig.setPrivateKey(this.getFileContent(privateKeyPath));
        }
        return this;
    }

    public ClientBuilder setPrivateKey(InputStream privateKeyStream) {
        if (this.isOAuth2Flow()) {
            Assert.notNull((Object)privateKeyStream, (String)"Missing privateKeyFile");
            this.clientConfig.setPrivateKey(this.getFileContent(privateKeyStream));
        }
        return this;
    }

    public ClientBuilder setPrivateKey(PrivateKey privateKey) {
        if (this.isOAuth2Flow()) {
            Assert.notNull((Object)privateKey, (String)"Missing privateKeyFile");
            String algorithm = privateKey.getAlgorithm();
            if (algorithm.equals("RSA")) {
                PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
                try {
                    ASN1Primitive primitive = privateKeyInfo.parsePrivateKey().toASN1Primitive();
                    String encodedString = "-----BEGIN RSA PRIVATE KEY-----\n" + Base64.getEncoder().encodeToString(primitive.getEncoded()) + "\n" + "-----END RSA PRIVATE KEY-----";
                    this.clientConfig.setPrivateKey(encodedString);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not parse private key");
                }
            } else if (algorithm.equals("EC")) {
                String encodedString = "-----BEGIN EC PRIVATE KEY-----\n" + Base64.getEncoder().encodeToString(privateKey.getEncoded()) + "\n" + "-----END EC PRIVATE KEY-----";
                this.clientConfig.setPrivateKey(encodedString);
            } else {
                throw new IllegalArgumentException("Supplied privateKey is not an RSA or EC key - " + algorithm);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFileContent(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            String string = this.readFromInputStream(inputStream);
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read from supplied private key file");
        }
    }

    private String getFileContent(Path path) {
        Assert.notNull((Object)path, (String)"The path to the privateKey cannot be null.");
        return this.getFileContent(path.toFile());
    }

    private String getFileContent(InputStream privateKeyStream) {
        try {
            return this.readFromInputStream(privateKeyStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read from supplied privateKey input stream");
        }
    }

    private String readFromInputStream(InputStream inputStream) throws IOException {
        Assert.notNull((Object)inputStream, (String)"InputStream cannot be null.");
        StringBuilder resultStringBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, Charset.forName(StandardCharsets.UTF_8.name())));){
            String line;
            while ((line = br.readLine()) != null) {
                resultStringBuilder.append(line).append("\n");
            }
        }
        return resultStringBuilder.toString();
    }

    public ClientBuilder setClientId(String clientId) {
        ConfigurationValidator.assertClientId((String)clientId);
        this.clientConfig.setClientId(clientId);
        return this;
    }

    public ClientBuilder setKid(String kid) {
        Assert.notNull((Object)kid, (String)"kid cannot be null.");
        this.clientConfig.setKid(kid);
        return this;
    }

    boolean isOAuth2Flow() {
        return this.getClientConfiguration().getAuthorizationMode() == AuthorizationMode.PRIVATE_KEY;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfig;
    }

    private static String[] configSources() {
        return new String[]{"classpath:com/okta/sdk/config/okta.properties", "classpath:com/okta/sdk/config/okta.yaml", "classpath:okta.properties", "classpath:okta.yaml", System.getProperty("user.home") + File.separatorChar + ".okta" + File.separatorChar + OKTA_YAML, ENVVARS_TOKEN, SYSPROPS_TOKEN};
    }
}

