/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.oauth2;

import java.time.Duration;
import java.time.Instant;

public class OAuth2AccessToken {
    public static final String TOKEN_TYPE_KEY = "token_type";
    public static final String EXPIRES_IN_KEY = "expires_in";
    public static final String ACCESS_TOKEN_KEY = "access_token";
    public static final String SCOPE_KEY = "scope";
    public static final String ERROR_KEY = "error";
    public static final String ERROR_DESCRIPTION = "error_description";
    private String tokenType;
    private Integer expiresIn;
    private String accessToken;
    private String scope;
    private Instant issuedAt = Instant.now();

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public boolean hasExpired() {
        Duration duration = Duration.between(this.getIssuedAt(), Instant.now());
        return duration.getSeconds() >= (long)this.getExpiresIn().intValue();
    }

    void expireNow() {
        this.setExpiresIn(Integer.MIN_VALUE);
    }

    public String toString() {
        return "OAuth2AccessToken [tokenType=" + this.tokenType + ", issuedAt=" + this.issuedAt + ", expiresIn=" + this.expiresIn + ", accessToken=xxxxx, scope=" + this.scope + "]";
    }
}

