/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.application;

import com.okta.sdk.resource.application.ApplicationFeature;
import com.okta.sdk.resource.application.ApplicationFeatureList;
import com.okta.sdk.resource.application.CapabilitiesObject;
import com.okta.sdk.resource.common.EnabledStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * ApplicationFeature
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-04-28T13:50:40.626-05:00")
public class DefaultApplicationFeature extends AbstractInstanceResource<ApplicationFeature> implements ApplicationFeature {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static ResourceReference<CapabilitiesObject> capabilitiesProperty = new ResourceReference("capabilities", CapabilitiesObject.class, false);
    private final static StringProperty descriptionProperty = new StringProperty("description");
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static EnumProperty<EnabledStatus> statusProperty = new EnumProperty("status", EnabledStatus.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, capabilitiesProperty, descriptionProperty, nameProperty, statusProperty);

    public DefaultApplicationFeature(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultApplicationFeature(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return ApplicationFeature.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public CapabilitiesObject getCapabilities() {
        return  getResourceProperty(capabilitiesProperty);
    }

    public ApplicationFeature setCapabilities(CapabilitiesObject capabilities) {
        setProperty(capabilitiesProperty, capabilities);
        return this;
    }

    public String getDescription() {
        return  getString(descriptionProperty);
    }

    public ApplicationFeature setDescription(String description) {
        setProperty(descriptionProperty, description);
        return this;
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public ApplicationFeature setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public EnabledStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public ApplicationFeature setStatus(EnabledStatus status) {
        setProperty(statusProperty, status);
        return this;
    }


    /**
    * Fetches the Feature objects for an application.
    * List Features for application
    * @param appId  (required)
    * @return ApplicationFeatureList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/apps/{appId}/features")
    public ApplicationFeatureList listFeaturesForApplication(String appId) {



        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/features",
            ApplicationFeatureList.class,
            queryArgs,
            headers);
    }



}
