/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.authorization.server;

import com.okta.sdk.resource.application.AuthorizationServerCredentials;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.application.JwkUse;
import com.okta.sdk.resource.application.OAuth2Claim;
import com.okta.sdk.resource.application.OAuth2ClaimList;
import com.okta.sdk.resource.application.OAuth2ClientList;
import com.okta.sdk.resource.application.OAuth2RefreshToken;
import com.okta.sdk.resource.application.OAuth2RefreshTokenList;
import com.okta.sdk.resource.application.OAuth2Scope;
import com.okta.sdk.resource.application.OAuth2ScopeList;
import com.okta.sdk.resource.authorization.server.AuthorizationServer;
import com.okta.sdk.resource.authorization.server.AuthorizationServerPolicy;
import com.okta.sdk.resource.authorization.server.AuthorizationServerPolicyList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * AuthorizationServer
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-04-28T13:50:40.626-05:00")
public class DefaultAuthorizationServer extends AbstractInstanceResource<AuthorizationServer> implements AuthorizationServer {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static ListProperty audiencesProperty = new ListProperty("audiences");
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static ResourceReference<AuthorizationServerCredentials> credentialsProperty = new ResourceReference("credentials", AuthorizationServerCredentials.class, false);
    private final static StringProperty descriptionProperty = new StringProperty("description");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static StringProperty issuerProperty = new StringProperty("issuer");
    private final static EnumProperty<IssuerModeEnum> issuerModeProperty = new EnumProperty("issuerMode", IssuerModeEnum.class);
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static EnumProperty<StatusEnum> statusProperty = new EnumProperty("status", StatusEnum.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, audiencesProperty, createdProperty, credentialsProperty, descriptionProperty, idProperty, issuerProperty, issuerModeProperty, lastUpdatedProperty, nameProperty, statusProperty);

    public DefaultAuthorizationServer(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultAuthorizationServer(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return AuthorizationServer.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public List<String> getAudiences() {
        return (List<String>) getListProperty(audiencesProperty);
    }

    public AuthorizationServer setAudiences(List<String> audiences) {
        setProperty(audiencesProperty, audiences);
        return this;
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public AuthorizationServerCredentials getCredentials() {
        return  getResourceProperty(credentialsProperty);
    }

    public AuthorizationServer setCredentials(AuthorizationServerCredentials credentials) {
        setProperty(credentialsProperty, credentials);
        return this;
    }

    public String getDescription() {
        return  getString(descriptionProperty);
    }

    public AuthorizationServer setDescription(String description) {
        setProperty(descriptionProperty, description);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public String getIssuer() {
        return  getString(issuerProperty);
    }

    public AuthorizationServer setIssuer(String issuer) {
        setProperty(issuerProperty, issuer);
        return this;
    }

    public IssuerModeEnum getIssuerMode() {
        return  getEnumProperty(issuerModeProperty);
    }

    public AuthorizationServer setIssuerMode(IssuerModeEnum issuerMode) {
        setProperty(issuerModeProperty, issuerMode);
        return this;
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public AuthorizationServer setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public StatusEnum getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public AuthorizationServer setStatus(StatusEnum status) {
        setProperty(statusProperty, status);
        return this;
    }


    /**
    * 
    * Success
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/authorizationServers/{authServerId}/lifecycle/activate")
    public void activate() {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/authorizationServers/" + authServerId + "/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Success
    * @param claimId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "DELETE - /api/v1/authorizationServers/{authServerId}/claims/{claimId}")
    public void deleteOAuth2Claim(String claimId) {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(claimId, "'claimId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/authorizationServers/" + authServerId + "/claims/" + claimId + "",
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @param oAuth2Scope  (required)
    * @return OAuth2Scope
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/authorizationServers/{authServerId}/scopes")
    public OAuth2Scope createOAuth2Scope(OAuth2Scope oAuth2Scope) {

        String authServerId = getId();

        notNull(oAuth2Scope, "'oAuth2Scope' is required and cannot be null.");
        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/authorizationServers/" + authServerId + "/scopes",
            oAuth2Scope,
            this,
            OAuth2Scope.class,
            queryArgs,
            headers);
        return oAuth2Scope;

    }




    /**
    * 
    * Success
    * @param scopeId  (required)
    * @return OAuth2Scope
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/authorizationServers/{authServerId}/scopes/{scopeId}")
    public OAuth2Scope getOAuth2Scope(String scopeId) {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(scopeId, "'scopeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "/scopes/" + scopeId + "",
            OAuth2Scope.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @param policy  (required)
    * @return AuthorizationServerPolicy
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/authorizationServers/{authServerId}/policies")
    public AuthorizationServerPolicy createPolicy(AuthorizationServerPolicy policy) {

        String authServerId = getId();

        notNull(policy, "'policy' is required and cannot be null.");
        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/authorizationServers/" + authServerId + "/policies",
            policy,
            this,
            AuthorizationServerPolicy.class,
            queryArgs,
            headers);
        return policy;

    }




    /**
    * 
    * Success
    * @return AuthorizationServerPolicyList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/authorizationServers/{authServerId}/policies")
    public AuthorizationServerPolicyList listPolicies() {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "/policies",
            AuthorizationServerPolicyList.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @return OAuth2ClaimList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/authorizationServers/{authServerId}/claims")
    public OAuth2ClaimList listOAuth2Claims() {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "/claims",
            OAuth2ClaimList.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @param claimId  (required)
    * @return OAuth2Claim
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/authorizationServers/{authServerId}/claims/{claimId}")
    public OAuth2Claim getOAuth2Claim(String claimId) {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(claimId, "'claimId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "/claims/" + claimId + "",
            OAuth2Claim.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @return OAuth2ClientList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/authorizationServers/{authServerId}/clients")
    public OAuth2ClientList listOAuth2Clients() {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "/clients",
            OAuth2ClientList.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/authorizationServers/{authServerId}/lifecycle/deactivate")
    public void deactivate() {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/authorizationServers/" + authServerId + "/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Success
    * @param scopeId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "DELETE - /api/v1/authorizationServers/{authServerId}/scopes/{scopeId}")
    public void deleteOAuth2Scope(String scopeId) {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(scopeId, "'scopeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/authorizationServers/" + authServerId + "/scopes/" + scopeId + "",
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @return JsonWebKeyList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/authorizationServers/{authServerId}/credentials/keys")
    public JsonWebKeyList listKeys() {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "/credentials/keys",
            JsonWebKeyList.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @param q  (optional)
    * @param filter  (optional)
    * @param cursor  (optional)
    * @return OAuth2ScopeList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/authorizationServers/{authServerId}/scopes")
    public OAuth2ScopeList listOAuth2Scopes(String q, String filter, String cursor) {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (q != null) queryArgs.put("q", q);
        if (filter != null) queryArgs.put("filter", filter);
        if (cursor != null) queryArgs.put("cursor", cursor);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "/scopes",
            OAuth2ScopeList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Success
    * @return OAuth2ScopeList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/authorizationServers/{authServerId}/scopes")
    public OAuth2ScopeList listOAuth2Scopes() {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "/scopes",
            OAuth2ScopeList.class,
            queryArgs,
            headers);
     }




    /**
    * 
    * Success
    * @param clientId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "DELETE - /api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens")
    public void revokeRefreshTokensForClient(String clientId) {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens",
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @param use  (required)
    * @return JsonWebKeyList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/authorizationServers/{authServerId}/credentials/lifecycle/keyRotate")
    public JsonWebKeyList rotateKeys(JwkUse use) {

        String authServerId = getId();

        notNull(use, "'use' is required and cannot be null.");
        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/authorizationServers/" + authServerId + "/credentials/lifecycle/keyRotate",
            use,
            this,
            JsonWebKeyList.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Success
    * @param clientId  (required)
    * @param expand  (optional)
    * @return OAuth2RefreshTokenList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens")
    public OAuth2RefreshTokenList listRefreshTokensForClient(String clientId, String expand) {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens",
            OAuth2RefreshTokenList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Success
    * @param clientId  (required)
    * @return OAuth2RefreshTokenList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens")
    public OAuth2RefreshTokenList listRefreshTokensForClient(String clientId) {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens",
            OAuth2RefreshTokenList.class,
            queryArgs,
            headers);
     }




    /**
    * 
    * Success
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "DELETE - /api/v1/authorizationServers/{authServerId}")
    public void delete() {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/authorizationServers/" + authServerId + "",
            (Resource) this,
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @param claimId  (required)
    * @param oAuth2Claim  (required)
    * @return OAuth2Claim
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "PUT - /api/v1/authorizationServers/{authServerId}/claims/{claimId}")
    public OAuth2Claim updateOAuth2Claim(String claimId, OAuth2Claim oAuth2Claim) {

        String authServerId = getId();

        notNull(oAuth2Claim, "'oAuth2Claim' is required and cannot be null.");
        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(claimId, "'claimId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/authorizationServers/" + authServerId + "/claims/" + claimId + "";
        getDataStore().save(href, oAuth2Claim, this, queryArgs, headers);
        return  oAuth2Claim;

    }




    /**
    * 
    * Success
    * @param clientId  (required)
    * @param tokenId  (required)
    * @param expand  (optional)
    * @return OAuth2RefreshToken
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}")
    public OAuth2RefreshToken getRefreshTokenForClient(String clientId, String tokenId, String expand) {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");
        hasText(tokenId, "'tokenId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens/" + tokenId + "",
            OAuth2RefreshToken.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Success
    * @param clientId  (required)
    * @param tokenId  (required)
    * @return OAuth2RefreshToken
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}")
    public OAuth2RefreshToken getRefreshTokenForClient(String clientId, String tokenId) {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");
        hasText(tokenId, "'tokenId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens/" + tokenId + "",
            OAuth2RefreshToken.class,
            queryArgs,
            headers);
     }




    /**
    * 
    * Success
    * @param policyId  (required)
    * @param policy  (required)
    * @return AuthorizationServerPolicy
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "PUT - /api/v1/authorizationServers/{authServerId}/policies/{policyId}")
    public AuthorizationServerPolicy updatePolicy(String policyId, AuthorizationServerPolicy policy) {

        String authServerId = getId();

        notNull(policy, "'policy' is required and cannot be null.");
        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(policyId, "'policyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "";
        getDataStore().save(href, policy, this, queryArgs, headers);
        return  policy;

    }




    /**
    * 
    * Success
    * @param clientId  (required)
    * @param tokenId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "DELETE - /api/v1/authorizationServers/{authServerId}/clients/{clientId}/tokens/{tokenId}")
    public void revokeRefreshTokenForClient(String clientId, String tokenId) {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");
        hasText(tokenId, "'tokenId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/authorizationServers/" + authServerId + "/clients/" + clientId + "/tokens/" + tokenId + "",
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @param policyId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "DELETE - /api/v1/authorizationServers/{authServerId}/policies/{policyId}")
    public void deletePolicy(String policyId) {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(policyId, "'policyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "",
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @param policyId  (required)
    * @return AuthorizationServerPolicy
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/authorizationServers/{authServerId}/policies/{policyId}")
    public AuthorizationServerPolicy getPolicy(String policyId) {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(policyId, "'policyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "",
            AuthorizationServerPolicy.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @return AuthorizationServer
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "PUT - /api/v1/authorizationServers/{authServerId}")
    public AuthorizationServer update() {

        String authServerId = getId();

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/authorizationServers/" + authServerId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }




    /**
    * 
    * Success
    * @param scopeId  (required)
    * @param oAuth2Scope  (required)
    * @return OAuth2Scope
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "PUT - /api/v1/authorizationServers/{authServerId}/scopes/{scopeId}")
    public OAuth2Scope updateOAuth2Scope(String scopeId, OAuth2Scope oAuth2Scope) {

        String authServerId = getId();

        notNull(oAuth2Scope, "'oAuth2Scope' is required and cannot be null.");
        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(scopeId, "'scopeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/authorizationServers/" + authServerId + "/scopes/" + scopeId + "";
        getDataStore().save(href, oAuth2Scope, this, queryArgs, headers);
        return  oAuth2Scope;

    }




    /**
    * 
    * Success
    * @param oAuth2Claim  (required)
    * @return OAuth2Claim
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/authorizationServers/{authServerId}/claims")
    public OAuth2Claim createOAuth2Claim(OAuth2Claim oAuth2Claim) {

        String authServerId = getId();

        notNull(oAuth2Claim, "'oAuth2Claim' is required and cannot be null.");
        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/authorizationServers/" + authServerId + "/claims",
            oAuth2Claim,
            this,
            OAuth2Claim.class,
            queryArgs,
            headers);
        return oAuth2Claim;

    }



}
