/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.event.hook;

import com.okta.sdk.resource.event.hook.EventHook;
import com.okta.sdk.resource.event.hook.EventHookChannel;
import com.okta.sdk.resource.event.hook.EventSubscriptions;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * EventHook
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-04-28T13:50:40.626-05:00")
public class DefaultEventHook extends AbstractInstanceResource<EventHook> implements EventHook {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static ResourceReference<EventHookChannel> channelProperty = new ResourceReference("channel", EventHookChannel.class, false);
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty createdByProperty = new StringProperty("createdBy");
    private final static ResourceReference<EventSubscriptions> eventsProperty = new ResourceReference("events", EventSubscriptions.class, false);
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static EnumProperty<StatusEnum> statusProperty = new EnumProperty("status", StatusEnum.class);
    private final static EnumProperty<VerificationStatusEnum> verificationStatusProperty = new EnumProperty("verificationStatus", VerificationStatusEnum.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, channelProperty, createdProperty, createdByProperty, eventsProperty, idProperty, lastUpdatedProperty, nameProperty, statusProperty, verificationStatusProperty);

    public DefaultEventHook(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultEventHook(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return EventHook.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public EventHookChannel getChannel() {
        return  getResourceProperty(channelProperty);
    }

    public EventHook setChannel(EventHookChannel channel) {
        setProperty(channelProperty, channel);
        return this;
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getCreatedBy() {
        return  getString(createdByProperty);
    }

    public EventHook setCreatedBy(String createdBy) {
        setProperty(createdByProperty, createdBy);
        return this;
    }

    public EventSubscriptions getEvents() {
        return  getResourceProperty(eventsProperty);
    }

    public EventHook setEvents(EventSubscriptions events) {
        setProperty(eventsProperty, events);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public EventHook setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public StatusEnum getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public EventHook setStatus(StatusEnum status) {
        setProperty(statusProperty, status);
        return this;
    }

    public VerificationStatusEnum getVerificationStatus() {
        return  getEnumProperty(verificationStatusProperty);
    }

    public EventHook setVerificationStatus(VerificationStatusEnum verificationStatus) {
        setProperty(verificationStatusProperty, verificationStatus);
        return this;
    }


    /**
    * 
    * Success
    * @return EventHook
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "PUT - /api/v1/eventHooks/{eventHookId}")
    public EventHook update() {

        String eventHookId = getId();

        hasText(eventHookId, "'eventHookId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/eventHooks/" + eventHookId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }




    /**
    * 
    * Success
    * @return EventHook
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/eventHooks/{eventHookId}/lifecycle/deactivate")
    public EventHook deactivate() {

        String eventHookId = getId();

        hasText(eventHookId, "'eventHookId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/eventHooks/" + eventHookId + "/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            EventHook.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Success
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "DELETE - /api/v1/eventHooks/{eventHookId}")
    public void delete() {

        String eventHookId = getId();

        hasText(eventHookId, "'eventHookId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/eventHooks/" + eventHookId + "",
            (Resource) this,
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @return EventHook
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/eventHooks/{eventHookId}/lifecycle/activate")
    public EventHook activate() {

        String eventHookId = getId();

        hasText(eventHookId, "'eventHookId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/eventHooks/" + eventHookId + "/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            this,
            EventHook.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Success
    * @return EventHook
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/eventHooks/{eventHookId}/lifecycle/verify")
    public EventHook verify() {

        String eventHookId = getId();

        hasText(eventHookId, "'eventHookId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/eventHooks/" + eventHookId + "/lifecycle/verify",
            new DefaultVoidResource(getDataStore()),
            this,
            EventHook.class,
            queryArgs,
            headers);

    }



}
