/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.inline.hook;

import com.okta.sdk.resource.inline.hook.InlineHook;
import com.okta.sdk.resource.inline.hook.InlineHookChannel;
import com.okta.sdk.resource.inline.hook.InlineHookPayload;
import com.okta.sdk.resource.inline.hook.InlineHookResponse;
import com.okta.sdk.resource.inline.hook.InlineHookStatus;
import com.okta.sdk.resource.inline.hook.InlineHookType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * InlineHook
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-04-28T13:50:40.626-05:00")
public class DefaultInlineHook extends AbstractInstanceResource<InlineHook> implements InlineHook {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static ResourceReference<InlineHookChannel> channelProperty = new ResourceReference("channel", InlineHookChannel.class, false);
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static EnumProperty<InlineHookStatus> statusProperty = new EnumProperty("status", InlineHookStatus.class);
    private final static EnumProperty<InlineHookType> typeProperty = new EnumProperty("type", InlineHookType.class);
    private final static StringProperty versionProperty = new StringProperty("version");

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, channelProperty, createdProperty, idProperty, lastUpdatedProperty, nameProperty, statusProperty, typeProperty, versionProperty);

    public DefaultInlineHook(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultInlineHook(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return InlineHook.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public InlineHookChannel getChannel() {
        return  getResourceProperty(channelProperty);
    }

    public InlineHook setChannel(InlineHookChannel channel) {
        setProperty(channelProperty, channel);
        return this;
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public InlineHook setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public InlineHookStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public InlineHook setStatus(InlineHookStatus status) {
        setProperty(statusProperty, status);
        return this;
    }

    public InlineHookType getType() {
        return  getEnumProperty(typeProperty);
    }

    public InlineHook setType(InlineHookType type) {
        setProperty(typeProperty, type);
        return this;
    }

    public String getVersion() {
        return  getString(versionProperty);
    }

    public InlineHook setVersion(String version) {
        setProperty(versionProperty, version);
        return this;
    }


    /**
    * 
    * Updates an inline hook by ID
    * @return InlineHook
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "PUT - /api/v1/inlineHooks/{inlineHookId}")
    public InlineHook update() {

        String inlineHookId = getId();

        hasText(inlineHookId, "'inlineHookId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/inlineHooks/" + inlineHookId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }




    /**
    * 
    * Executes the Inline Hook matching the provided inlineHookId using the request body as the input. This will send the provided data through the Channel and return a response if it matches the correct data contract. This execution endpoint should only be used for testing purposes.
    * @param payloadData  (required)
    * @return InlineHookResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/inlineHooks/{inlineHookId}/execute")
    public InlineHookResponse execute(InlineHookPayload payloadData) {

        String inlineHookId = getId();

        notNull(payloadData, "'payloadData' is required and cannot be null.");
        hasText(inlineHookId, "'inlineHookId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/inlineHooks/" + inlineHookId + "/execute",
            payloadData,
            this,
            InlineHookResponse.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Deletes the Inline Hook matching the provided id. Once deleted, the Inline Hook is unrecoverable. As a safety precaution, only Inline Hooks with a status of INACTIVE are eligible for deletion.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "DELETE - /api/v1/inlineHooks/{inlineHookId}")
    public void delete() {

        String inlineHookId = getId();

        hasText(inlineHookId, "'inlineHookId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/inlineHooks/" + inlineHookId + "",
            (Resource) this,
            queryArgs,
            headers);
    }




    /**
    * 
    * Deactivates the Inline Hook matching the provided id
    * @return InlineHook
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/inlineHooks/{inlineHookId}/lifecycle/deactivate")
    public InlineHook deactivate() {

        String inlineHookId = getId();

        hasText(inlineHookId, "'inlineHookId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/inlineHooks/" + inlineHookId + "/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            InlineHook.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Activates the Inline Hook matching the provided id
    * @return InlineHook
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/inlineHooks/{inlineHookId}/lifecycle/activate")
    public InlineHook activate() {

        String inlineHookId = getId();

        hasText(inlineHookId, "'inlineHookId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/inlineHooks/" + inlineHookId + "/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            this,
            InlineHook.class,
            queryArgs,
            headers);

    }



}
