/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.org;

import com.okta.sdk.resource.org.OrgContactTypeObjList;
import com.okta.sdk.resource.org.OrgContactUser;
import com.okta.sdk.resource.org.OrgOktaCommunicationSetting;
import com.okta.sdk.resource.org.OrgOktaSupportSettingsObj;
import com.okta.sdk.resource.org.OrgPreferences;
import com.okta.sdk.resource.org.OrgSetting;
import java.io.File;
import java.util.Date;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * OrgSetting
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-04-28T13:50:40.626-05:00")
public class DefaultOrgSetting extends AbstractInstanceResource<OrgSetting> implements OrgSetting {

    private final static StringProperty address1Property = new StringProperty("address1");
    private final static StringProperty address2Property = new StringProperty("address2");
    private final static StringProperty cityProperty = new StringProperty("city");
    private final static StringProperty companyNameProperty = new StringProperty("companyName");
    private final static StringProperty countryProperty = new StringProperty("country");
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty endUserSupportHelpURLProperty = new StringProperty("endUserSupportHelpURL");
    private final static DateProperty expiresAtProperty = new DateProperty("expiresAt");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static StringProperty phoneNumberProperty = new StringProperty("phoneNumber");
    private final static StringProperty postalCodeProperty = new StringProperty("postalCode");
    private final static StringProperty stateProperty = new StringProperty("state");
    private final static StringProperty statusProperty = new StringProperty("status");
    private final static StringProperty subdomainProperty = new StringProperty("subdomain");
    private final static StringProperty supportPhoneNumberProperty = new StringProperty("supportPhoneNumber");
    private final static StringProperty websiteProperty = new StringProperty("website");

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(address1Property, address2Property, cityProperty, companyNameProperty, countryProperty, createdProperty, endUserSupportHelpURLProperty, expiresAtProperty, idProperty, lastUpdatedProperty, phoneNumberProperty, postalCodeProperty, stateProperty, statusProperty, subdomainProperty, supportPhoneNumberProperty, websiteProperty);

    public DefaultOrgSetting(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultOrgSetting(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return OrgSetting.class;
    }

    public String getAddress1() {
        return  getString(address1Property);
    }

    public OrgSetting setAddress1(String address1) {
        setProperty(address1Property, address1);
        return this;
    }

    public String getAddress2() {
        return  getString(address2Property);
    }

    public OrgSetting setAddress2(String address2) {
        setProperty(address2Property, address2);
        return this;
    }

    public String getCity() {
        return  getString(cityProperty);
    }

    public OrgSetting setCity(String city) {
        setProperty(cityProperty, city);
        return this;
    }

    public String getCompanyName() {
        return  getString(companyNameProperty);
    }

    public OrgSetting setCompanyName(String companyName) {
        setProperty(companyNameProperty, companyName);
        return this;
    }

    public String getCountry() {
        return  getString(countryProperty);
    }

    public OrgSetting setCountry(String country) {
        setProperty(countryProperty, country);
        return this;
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getEndUserSupportHelpURL() {
        return  getString(endUserSupportHelpURLProperty);
    }

    public OrgSetting setEndUserSupportHelpURL(String endUserSupportHelpURL) {
        setProperty(endUserSupportHelpURLProperty, endUserSupportHelpURL);
        return this;
    }

    public Date getExpiresAt() {
        return  getDateProperty(expiresAtProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public String getPhoneNumber() {
        return  getString(phoneNumberProperty);
    }

    public OrgSetting setPhoneNumber(String phoneNumber) {
        setProperty(phoneNumberProperty, phoneNumber);
        return this;
    }

    public String getPostalCode() {
        return  getString(postalCodeProperty);
    }

    public OrgSetting setPostalCode(String postalCode) {
        setProperty(postalCodeProperty, postalCode);
        return this;
    }

    public String getState() {
        return  getString(stateProperty);
    }

    public OrgSetting setState(String state) {
        setProperty(stateProperty, state);
        return this;
    }

    public String getStatus() {
        return  getString(statusProperty);
    }

    public String getSubdomain() {
        return  getString(subdomainProperty);
    }

    public String getSupportPhoneNumber() {
        return  getString(supportPhoneNumberProperty);
    }

    public OrgSetting setSupportPhoneNumber(String supportPhoneNumber) {
        setProperty(supportPhoneNumberProperty, supportPhoneNumber);
        return this;
    }

    public String getWebsite() {
        return  getString(websiteProperty);
    }

    public OrgSetting setWebsite(String website) {
        setProperty(websiteProperty, website);
        return this;
    }


    /**
    * Partial update Org setting
    * Partial update settings of your organization.
    * @return OrgSetting
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/org")
    public OrgSetting partialUpdate() {




        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        OrgSetting orgSetting = this;
        getDataStore().create(
            "/api/v1/org",
            this,
            this,
            OrgSetting.class,
            queryArgs,
            headers);
        return orgSetting;

    }




    /**
    * Get Okta Support settings
    * Gets Okta Support Settings of your organization.
    * @return OrgOktaSupportSettingsObj
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/org/privacy/oktaSupport")
    public OrgOktaSupportSettingsObj getSupportSettings() {




        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/org/privacy/oktaSupport",
            OrgOktaSupportSettingsObj.class,
            queryArgs,
            headers);
    }




    /**
    * Get org contact user
    * Retrieves the URL of the User associated with the specified Contact Type.
    * @param contactType  (required)
    * @return OrgContactUser
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/org/contacts/{contactType}")
    public OrgContactUser getOrgContactUser(String contactType) {



        hasText(contactType, "'contactType' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/org/contacts/" + contactType + "",
            OrgContactUser.class,
            queryArgs,
            headers);
    }




    /**
    * Get org preferences
    * Gets preferences of your organization.
    * @return OrgPreferences
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/org/preferences")
    public OrgPreferences orgPreferences() {




        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/org/preferences",
            OrgPreferences.class,
            queryArgs,
            headers);
    }




    /**
    * Update org logo
    * Updates the logo for your organization.
    * @param file  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/org/logo")
    public void updateOrgLogo(File file) {




        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();
        headers.add("x-contentType", "multipart/form-data");

        getDataStore().create(
            "/api/v1/org/logo",
            new DefaultFileResource(getDataStore(), file.getAbsoluteFile().toPath(), "file"),
            null,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * Get org contact types
    * Gets Contact Types of your organization.
    * @return OrgContactTypeObjList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/org/contacts")
    public OrgContactTypeObjList getContactTypes() {




        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/org/contacts",
            OrgContactTypeObjList.class,
            queryArgs,
            headers);
    }




    /**
    * Get Okta Communication Settings
    * Gets Okta Communication Settings of your organization.
    * @return OrgOktaCommunicationSetting
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/org/privacy/oktaCommunication")
    public OrgOktaCommunicationSetting communicationSettings() {




        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/org/privacy/oktaCommunication",
            OrgOktaCommunicationSetting.class,
            queryArgs,
            headers);
    }




    /**
    * Show Okta UI Footer
    * Hide the Okta UI footer for all end users of your organization.
    * @return OrgPreferences
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/org/preferences/hideEndUserFooter")
    public OrgPreferences hideFooter() {




        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/org/preferences/hideEndUserFooter",
            new DefaultVoidResource(getDataStore()),
            this,
            OrgPreferences.class,
            queryArgs,
            headers);

    }




    /**
    * Update Org setting
    * Update settings of your organization.
    * @return OrgSetting
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "PUT - /api/v1/org")
    public OrgSetting update() {




        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/org";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }




    /**
    * Show Okta UI Footer
    * Makes the Okta UI footer visible for all end users of your organization.
    * @return OrgPreferences
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/org/preferences/showEndUserFooter")
    public OrgPreferences showFooter() {




        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/org/preferences/showEndUserFooter",
            new DefaultVoidResource(getDataStore()),
            this,
            OrgPreferences.class,
            queryArgs,
            headers);

    }



}
