/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.profile.mapping;

import com.okta.sdk.resource.profile.mapping.ProfileMapping;
import com.okta.sdk.resource.profile.mapping.ProfileMappingProperty;
import com.okta.sdk.resource.profile.mapping.ProfileMappingSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * ProfileMapping
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-04-28T13:50:40.626-05:00")
public class DefaultProfileMapping extends AbstractInstanceResource<ProfileMapping> implements ProfileMapping {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static MapProperty propertiesProperty = new MapProperty("properties");
    private final static ResourceReference<ProfileMappingSource> sourceProperty = new ResourceReference("source", ProfileMappingSource.class, false);
    private final static ResourceReference<ProfileMappingSource> targetProperty = new ResourceReference("target", ProfileMappingSource.class, false);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, idProperty, propertiesProperty, sourceProperty, targetProperty);

    public DefaultProfileMapping(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultProfileMapping(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return ProfileMapping.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Map<String, ProfileMappingProperty> getProperties() {
        return  getMap(propertiesProperty);
    }

    public ProfileMappingSource getSource() {
        return  getResourceProperty(sourceProperty);
    }

    public ProfileMapping setSource(ProfileMappingSource source) {
        setProperty(sourceProperty, source);
        return this;
    }

    public ProfileMappingSource getTarget() {
        return  getResourceProperty(targetProperty);
    }

    public ProfileMapping setTarget(ProfileMappingSource target) {
        setProperty(targetProperty, target);
        return this;
    }


    /**
    * Update Profile Mapping
    * Updates an existing Profile Mapping by adding, updating, or removing one or many Property Mappings.
    * @param profileMapping  (required)
    * @return ProfileMapping
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/mappings/{mappingId}")
    public ProfileMapping update(ProfileMapping profileMapping) {

        String mappingId = getId();

        notNull(profileMapping, "'profileMapping' is required and cannot be null.");
        hasText(mappingId, "'mappingId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/mappings/" + mappingId + "",
            profileMapping,
            this,
            ProfileMapping.class,
            queryArgs,
            headers);
        return profileMapping;

    }



}
