/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.role;

import com.okta.sdk.resource.role.Subscription;
import com.okta.sdk.resource.role.SubscriptionList;
import com.okta.sdk.resource.role.SubscriptionStatus;
import com.okta.sdk.resource.subscription.NotificationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * Subscription
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-04-28T13:50:40.626-05:00")
public class DefaultSubscription extends AbstractInstanceResource<Subscription> implements Subscription {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static ListProperty channelsProperty = new ListProperty("channels");
    private final static EnumProperty<NotificationType> notificationTypeProperty = new EnumProperty("notificationType", NotificationType.class);
    private final static EnumProperty<SubscriptionStatus> statusProperty = new EnumProperty("status", SubscriptionStatus.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, channelsProperty, notificationTypeProperty, statusProperty);

    public DefaultSubscription(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultSubscription(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Subscription.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public List<String> getChannels() {
        return (List<String>) getListProperty(channelsProperty);
    }

    public Subscription setChannels(List<String> channels) {
        setProperty(channelsProperty, channels);
        return this;
    }

    public NotificationType getNotificationType() {
        return  getEnumProperty(notificationTypeProperty);
    }

    public Subscription setNotificationType(NotificationType notificationType) {
        setProperty(notificationTypeProperty, notificationType);
        return this;
    }

    public SubscriptionStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public Subscription setStatus(SubscriptionStatus status) {
        setProperty(statusProperty, status);
        return this;
    }


    /**
    * Get the subscription of a User with a specific notification type
    * Get the subscriptions of a User with a specific notification type. Only gets subscriptions for current user. An AccessDeniedException message is sent if requests are made from other users.
    * @param userId  (required)
    * @param notificationType  (required)
    * @return Subscription
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/users/{userId}/subscriptions/{notificationType}")
    public Subscription getUserSubscriptionByNotificationType(String userId, String notificationType) {



        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(notificationType, "'notificationType' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/subscriptions/" + notificationType + "",
            Subscription.class,
            queryArgs,
            headers);
    }




    /**
    * Subscribe a Custom Role to a specific notification type
    * When roleType Subscribes a Role to a specific notification type. When you change the subscription status of a Role, it overrides the subscription of any individual user of that Role. Else when roleId Subscribes a Custom Role to a specific notification type. When you change the subscription status of a Custom Role, it overrides the subscription of any individual user of that Custom Role.
    * @param roleTypeOrRoleId  (required)
    * @param notificationType  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/roles/{roleTypeOrRoleId}/subscriptions/{notificationType}/subscribe")
    public void subscribeRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType) {



        hasText(roleTypeOrRoleId, "'roleTypeOrRoleId' is required and cannot be null or empty.");
        hasText(notificationType, "'notificationType' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/roles/" + roleTypeOrRoleId + "/subscriptions/" + notificationType + "/subscribe",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * Subscribe to a specific notification type
    * Subscribes a User to a specific notification type. Only the current User can subscribe to a specific notification type. An AccessDeniedException message is sent if requests are made from other users.
    * @param userId  (required)
    * @param notificationType  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/users/{userId}/subscriptions/{notificationType}/subscribe")
    public void subscribeUserSubscriptionByNotificationType(String userId, String notificationType) {



        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(notificationType, "'notificationType' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/users/" + userId + "/subscriptions/" + notificationType + "/subscribe",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * List all subscriptions of a Custom Role
    * When roleType List all subscriptions of a Role. Else when roleId List subscriptions of a Custom Role
    * @param roleTypeOrRoleId  (required)
    * @return SubscriptionList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/roles/{roleTypeOrRoleId}/subscriptions")
    public SubscriptionList listRoleSubscriptions(String roleTypeOrRoleId) {



        hasText(roleTypeOrRoleId, "'roleTypeOrRoleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/roles/" + roleTypeOrRoleId + "/subscriptions",
            SubscriptionList.class,
            queryArgs,
            headers);
    }




    /**
    * Unsubscribe a Custom Role from a specific notification type
    * When roleType Unsubscribes a Role from a specific notification type. When you change the subscription status of a Role, it overrides the subscription of any individual user of that Role. Else when roleId Unsubscribes a Custom Role from a specific notification type. When you change the subscription status of a Custom Role, it overrides the subscription of any individual user of that Custom Role.
    * @param roleTypeOrRoleId  (required)
    * @param notificationType  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/roles/{roleTypeOrRoleId}/subscriptions/{notificationType}/unsubscribe")
    public void unsubscribeRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType) {



        hasText(roleTypeOrRoleId, "'roleTypeOrRoleId' is required and cannot be null or empty.");
        hasText(notificationType, "'notificationType' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/roles/" + roleTypeOrRoleId + "/subscriptions/" + notificationType + "/unsubscribe",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * Get subscriptions of a Custom Role with a specific notification type
    * When roleType Get subscriptions of a Role with a specific notification type. Else when roleId Get subscription of a Custom Role with a specific notification type.
    * @param roleTypeOrRoleId  (required)
    * @param notificationType  (required)
    * @return Subscription
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/roles/{roleTypeOrRoleId}/subscriptions/{notificationType}")
    public Subscription getRoleSubscriptionByNotificationType(String roleTypeOrRoleId, String notificationType) {



        hasText(roleTypeOrRoleId, "'roleTypeOrRoleId' is required and cannot be null or empty.");
        hasText(notificationType, "'notificationType' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/roles/" + roleTypeOrRoleId + "/subscriptions/" + notificationType + "",
            Subscription.class,
            queryArgs,
            headers);
    }




    /**
    * Unsubscribe from a specific notification type
    * Unsubscribes a User from a specific notification type. Only the current User can unsubscribe from a specific notification type. An AccessDeniedException message is sent if requests are made from other users.
    * @param userId  (required)
    * @param notificationType  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "POST - /api/v1/users/{userId}/subscriptions/{notificationType}/unsubscribe")
    public void unsubscribeUserSubscriptionByNotificationType(String userId, String notificationType) {



        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(notificationType, "'notificationType' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/users/" + userId + "/subscriptions/" + notificationType + "/unsubscribe",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * List subscriptions of a User
    * List subscriptions of a User. Only lists subscriptions for current user. An AccessDeniedException message is sent if requests are made from other users.
    * @param userId  (required)
    * @return SubscriptionList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-04-28T13:50:40.626-05:00",
          comments = "GET - /api/v1/users/{userId}/subscriptions")
    public SubscriptionList listUserSubscriptions(String userId) {



        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/subscriptions",
            SubscriptionList.class,
            queryArgs,
            headers);
    }



}
