/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.application;

import com.okta.sdk.resource.application.AppUser;
import com.okta.sdk.resource.application.AppUserList;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationAccessibility;
import com.okta.sdk.resource.application.ApplicationCredentials;
import com.okta.sdk.resource.application.ApplicationFeature;
import com.okta.sdk.resource.application.ApplicationGroupAssignment;
import com.okta.sdk.resource.application.ApplicationGroupAssignmentList;
import com.okta.sdk.resource.application.ApplicationLicensing;
import com.okta.sdk.resource.application.ApplicationSettings;
import com.okta.sdk.resource.application.ApplicationSignOnMode;
import com.okta.sdk.resource.application.ApplicationVisibility;
import com.okta.sdk.resource.application.CapabilitiesObject;
import com.okta.sdk.resource.application.Csr;
import com.okta.sdk.resource.application.CsrList;
import com.okta.sdk.resource.application.CsrMetadata;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.application.OAuth2ScopeConsentGrant;
import com.okta.sdk.resource.application.OAuth2ScopeConsentGrantList;
import com.okta.sdk.resource.application.OAuth2Token;
import com.okta.sdk.resource.application.OAuth2TokenList;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * Application
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-09-19T13:58:37.007-05:00")
public class DefaultApplication extends AbstractInstanceResource<Application> implements Application {

    private final static MapProperty embeddedProperty = new MapProperty("_embedded");
    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static ResourceReference<ApplicationAccessibility> accessibilityProperty = new ResourceReference("accessibility", ApplicationAccessibility.class, false);
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static ResourceReference<ApplicationCredentials> credentialsProperty = new ResourceReference("credentials", ApplicationCredentials.class, false);
    private final static ListProperty featuresProperty = new ListProperty("features");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static StringProperty labelProperty = new StringProperty("label");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static ResourceReference<ApplicationLicensing> licensingProperty = new ResourceReference("licensing", ApplicationLicensing.class, false);
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static MapProperty profileProperty = new MapProperty("profile");
    private final static ResourceReference<ApplicationSettings> settingsProperty = new ResourceReference("settings", ApplicationSettings.class, false);
    private final static EnumProperty<ApplicationSignOnMode> signOnModeProperty = new EnumProperty("signOnMode", ApplicationSignOnMode.class);
    private final static EnumProperty<StatusEnum> statusProperty = new EnumProperty("status", StatusEnum.class);
    private final static ResourceReference<ApplicationVisibility> visibilityProperty = new ResourceReference("visibility", ApplicationVisibility.class, false);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(embeddedProperty, linksProperty, accessibilityProperty, createdProperty, credentialsProperty, featuresProperty, idProperty, labelProperty, lastUpdatedProperty, licensingProperty, nameProperty, profileProperty, settingsProperty, signOnModeProperty, statusProperty, visibilityProperty);

    public DefaultApplication(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultApplication(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Application.class;
    }

    public Map<String, Object> getEmbedded() {
        return  getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public ApplicationAccessibility getAccessibility() {
        return  getResourceProperty(accessibilityProperty);
    }

    public Application setAccessibility(ApplicationAccessibility accessibility) {
        setProperty(accessibilityProperty, accessibility);
        return this;
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public ApplicationCredentials getCredentials() {
        return  getResourceProperty(credentialsProperty);
    }

    public Application setCredentials(ApplicationCredentials credentials) {
        setProperty(credentialsProperty, credentials);
        return this;
    }

    public List<String> getFeatures() {
        return (List<String>) getListProperty(featuresProperty);
    }

    public Application setFeatures(List<String> features) {
        setProperty(featuresProperty, features);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public String getLabel() {
        return  getString(labelProperty);
    }

    public Application setLabel(String label) {
        setProperty(labelProperty, label);
        return this;
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public ApplicationLicensing getLicensing() {
        return  getResourceProperty(licensingProperty);
    }

    public Application setLicensing(ApplicationLicensing licensing) {
        setProperty(licensingProperty, licensing);
        return this;
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public Map<String, Object> getProfile() {
        return  getMap(profileProperty);
    }

    public Application setProfile(Map<String, Object> profile) {
        setProperty(profileProperty, profile);
        return this;
    }

    public ApplicationSettings getSettings() {
        return  getResourceProperty(settingsProperty);
    }

    public Application setSettings(ApplicationSettings settings) {
        setProperty(settingsProperty, settings);
        return this;
    }

    public ApplicationSignOnMode getSignOnMode() {
        return  getEnumProperty(signOnModeProperty);
    }

    public Application setSignOnMode(ApplicationSignOnMode signOnMode) {
        setProperty(signOnModeProperty, signOnMode);
        return this;
    }

    public StatusEnum getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public ApplicationVisibility getVisibility() {
        return  getResourceProperty(visibilityProperty);
    }

    public Application setVisibility(ApplicationVisibility visibility) {
        setProperty(visibilityProperty, visibility);
        return this;
    }


    /**
    * Fetches a Feature object for an application.
    * Fetches a Feature object for an application.
    * @param name  (required)
    * @return ApplicationFeature
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/features/{name}")
    public ApplicationFeature getFeatureForApplication(String name) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(name, "'name' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/features/" + name + "",
            ApplicationFeature.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * 
    * @param csrId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "DELETE - /api/v1/apps/{appId}/credentials/csrs/{csrId}")
    public void revokeCsr(String csrId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(csrId, "'csrId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "",
            queryArgs,
            headers);
    }




    /**
    * 
    * 
    * @param csrId  (required)
    * @return Csr
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/credentials/csrs/{csrId}")
    public Csr getCsr(String csrId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(csrId, "'csrId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "",
            Csr.class,
            queryArgs,
            headers);
    }




    /**
    * Get Assigned User for Application
    * Fetches a specific user assignment for application by &#x60;id&#x60;.
    * @param userId  (required)
    * @param expand  (optional)
    * @return AppUser
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/users/{userId}")
    public AppUser getApplicationUser(String userId, String expand) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/users/" + userId + "",
            AppUser.class,
            queryArgs,
            headers);
    }

    /**
    * Get Assigned User for Application
    * Fetches a specific user assignment for application by &#x60;id&#x60;.
    * @param userId  (required)
    * @return AppUser
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/users/{userId}")
    public AppUser getApplicationUser(String userId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/users/" + userId + "",
            AppUser.class,
            queryArgs,
            headers);
     }




    /**
    * Clone Application Key Credential
    * Clones a X.509 certificate for an application key credential from a source application to target application.
    * @param keyId  (required)
    * @param targetAid Unique key of the target Application (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/credentials/keys/{keyId}/clone")
    public JsonWebKey cloneApplicationKey(String keyId, String targetAid) {

        String appId = getId();

        notNull(targetAid, "'targetAid' is required and cannot be null.");
        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(keyId, "'keyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (targetAid != null) queryArgs.put("targetAid", targetAid);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/apps/" + appId + "/credentials/keys/" + keyId + "/clone",
            new DefaultVoidResource(getDataStore()),
            this,
            JsonWebKey.class,
            queryArgs,
            headers);

    }




    /**
    * Update application policy
    * Assign an application to a specific policy. This unassigns the application from its currently assigned policy.
    * @param policyId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "PUT - /api/v1/apps/{appId}/policies/{policyId}")
    public void updateApplicationPolicy(String policyId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(policyId, "'policyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/apps/" + appId + "/policies/" + policyId + "";
        getDataStore().save(href, new DefaultVoidResource(getDataStore()), this, queryArgs, headers);

    }




    /**
    * Generate Certificate Signing Request for Application
    * Generates a new key pair and returns the Certificate Signing Request for it.
    * @param metadata  (required)
    * @return Csr
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/credentials/csrs")
    public Csr generateCsr(CsrMetadata metadata) {

        String appId = getId();

        notNull(metadata, "'metadata' is required and cannot be null.");
        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/apps/" + appId + "/credentials/csrs",
            metadata,
            this,
            Csr.class,
            queryArgs,
            headers);

    }




    /**
    * List Groups Assigned to Application
    * Enumerates group assignments for an application.
    * @param q  (optional)
    * @param expand  (optional)
    * @return ApplicationGroupAssignmentList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/groups")
    public ApplicationGroupAssignmentList listGroupAssignments(String q, String expand) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (q != null) queryArgs.put("q", q);
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/groups",
            ApplicationGroupAssignmentList.class,
            queryArgs,
            headers);
    }

    /**
    * List Groups Assigned to Application
    * Enumerates group assignments for an application.
    * @return ApplicationGroupAssignmentList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/groups")
    public ApplicationGroupAssignmentList listGroupAssignments() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/groups",
            ApplicationGroupAssignmentList.class,
            queryArgs,
            headers);
     }




    /**
    * 
    * Lists all scope consent grants for the application
    * @param expand  (optional)
    * @return OAuth2ScopeConsentGrantList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/grants")
    public OAuth2ScopeConsentGrantList listScopeConsentGrants(String expand) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/grants",
            OAuth2ScopeConsentGrantList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Lists all scope consent grants for the application
    * @return OAuth2ScopeConsentGrantList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/grants")
    public OAuth2ScopeConsentGrantList listScopeConsentGrants() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/grants",
            OAuth2ScopeConsentGrantList.class,
            queryArgs,
            headers);
     }




    /**
    * 
    * Revokes the specified token for the specified application
    * @param tokenId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "DELETE - /api/v1/apps/{appId}/tokens/{tokenId}")
    public void revokeOAuth2TokenForApplication(String tokenId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(tokenId, "'tokenId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/apps/" + appId + "/tokens/" + tokenId + "",
            queryArgs,
            headers);
    }




    /**
    * 
    * 
    * @param csrId  (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/credentials/csrs/{csrId}/lifecycle/publish")
    public JsonWebKey publishBinaryCerCert(String csrId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(csrId, "'csrId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "/lifecycle/publish",
            new DefaultVoidResource(getDataStore()),
            this,
            JsonWebKey.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Revokes all tokens for the specified application
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "DELETE - /api/v1/apps/{appId}/tokens")
    public void revokeOAuth2Tokens() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/apps/" + appId + "/tokens",
            queryArgs,
            headers);
    }




    /**
    * 
    * Revokes permission for the application to request the given scope
    * @param grantId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "DELETE - /api/v1/apps/{appId}/grants/{grantId}")
    public void revokeScopeConsentGrant(String grantId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(grantId, "'grantId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/apps/" + appId + "/grants/" + grantId + "",
            queryArgs,
            headers);
    }




    /**
    * Assign User to Application for SSO &amp; Provisioning
    * Assigns an user to an application with [credentials](#application-user-credentials-object) and an app-specific [profile](#application-user-profile-object). Profile mappings defined for the application are first applied before applying any profile properties specified in the request.
    * @param appUser  (required)
    * @return AppUser
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/users")
    public AppUser assignUserToApplication(AppUser appUser) {

        String appId = getId();

        notNull(appUser, "'appUser' is required and cannot be null.");
        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/apps/" + appId + "/users",
            appUser,
            this,
            AppUser.class,
            queryArgs,
            headers);
        return appUser;

    }




    /**
    * 
    * Grants consent for the application to request an OAuth 2.0 Okta scope
    * @param oAuth2ScopeConsentGrant  (required)
    * @return OAuth2ScopeConsentGrant
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/grants")
    public OAuth2ScopeConsentGrant grantConsentToScope(OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant) {

        String appId = getId();

        notNull(oAuth2ScopeConsentGrant, "'oAuth2ScopeConsentGrant' is required and cannot be null.");
        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/apps/" + appId + "/grants",
            oAuth2ScopeConsentGrant,
            this,
            OAuth2ScopeConsentGrant.class,
            queryArgs,
            headers);
        return oAuth2ScopeConsentGrant;

    }




    /**
    * Delete Application
    * Removes an inactive application.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "DELETE - /api/v1/apps/{appId}")
    public void delete() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/apps/" + appId + "",
            (Resource) this,
            queryArgs,
            headers);
    }




    /**
    * 
    * 
    * @param csrId  (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/credentials/csrs/{csrId}/lifecycle/publish")
    public JsonWebKey publishDerCert(String csrId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(csrId, "'csrId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "/lifecycle/publish",
            new DefaultVoidResource(getDataStore()),
            this,
            JsonWebKey.class,
            queryArgs,
            headers);

    }




    /**
    * Activate Application
    * Activates an inactive application.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/lifecycle/activate")
    public void activate() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/apps/" + appId + "/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * Assign Group to Application
    * Assigns a group to an application
    * @param groupId  (required)
    * @param applicationGroupAssignment  (optional)
    * @return ApplicationGroupAssignment
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "PUT - /api/v1/apps/{appId}/groups/{groupId}")
    public ApplicationGroupAssignment createApplicationGroupAssignment(String groupId, ApplicationGroupAssignment applicationGroupAssignment) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/apps/" + appId + "/groups/" + groupId + "";
        getDataStore().save(href, applicationGroupAssignment, this, queryArgs, headers);
        return  applicationGroupAssignment;

    }

    /**
    * Assign Group to Application
    * Assigns a group to an application
    * @param groupId  (required)
    * @return ApplicationGroupAssignment
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "PUT - /api/v1/apps/{appId}/groups/{groupId}")
    public ApplicationGroupAssignment createApplicationGroupAssignment(String groupId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        
        String href = "/api/v1/apps/" + appId + "/groups/" + groupId + "";
        ApplicationGroupAssignment applicationGroupAssignment = new DefaultApplicationGroupAssignment(getDataStore());
        getDataStore().save(href, applicationGroupAssignment, this, queryArgs, headers);
        return  applicationGroupAssignment;

     }




    /**
    * Get Assigned Group for Application
    * Fetches an application group assignment
    * @param groupId  (required)
    * @param expand  (optional)
    * @return ApplicationGroupAssignment
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/groups/{groupId}")
    public ApplicationGroupAssignment getApplicationGroupAssignment(String groupId, String expand) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/groups/" + groupId + "",
            ApplicationGroupAssignment.class,
            queryArgs,
            headers);
    }

    /**
    * Get Assigned Group for Application
    * Fetches an application group assignment
    * @param groupId  (required)
    * @return ApplicationGroupAssignment
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/groups/{groupId}")
    public ApplicationGroupAssignment getApplicationGroupAssignment(String groupId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/groups/" + groupId + "",
            ApplicationGroupAssignment.class,
            queryArgs,
            headers);
     }




    /**
    * 
    * Generates a new X.509 certificate for an application key credential
    * @param validityYears  (optional)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/credentials/keys/generate")
    public JsonWebKey generateKey(Integer validityYears) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (validityYears != null) queryArgs.put("validityYears", validityYears);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/apps/" + appId + "/credentials/keys/generate",
            new DefaultVoidResource(getDataStore()),
            this,
            JsonWebKey.class,
            queryArgs,
            headers);

    }

    /**
    * 
    * Generates a new X.509 certificate for an application key credential
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/credentials/keys/generate")
    public JsonWebKey generateKey() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/apps/" + appId + "/credentials/keys/generate",
            new DefaultVoidResource(getDataStore()),
            this,
            JsonWebKey.class,
            queryArgs,
            headers);

     }




    /**
    * 
    * Lists all tokens for the application
    * @param expand  (optional)
    * @return OAuth2TokenList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/tokens")
    public OAuth2TokenList listOAuth2Tokens(String expand) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/tokens",
            OAuth2TokenList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Lists all tokens for the application
    * @return OAuth2TokenList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/tokens")
    public OAuth2TokenList listOAuth2Tokens() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/tokens",
            OAuth2TokenList.class,
            queryArgs,
            headers);
     }




    /**
    * 
    * Fetches a single scope consent grant for the application
    * @param grantId  (required)
    * @param expand  (optional)
    * @return OAuth2ScopeConsentGrant
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/grants/{grantId}")
    public OAuth2ScopeConsentGrant getScopeConsentGrant(String grantId, String expand) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(grantId, "'grantId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/grants/" + grantId + "",
            OAuth2ScopeConsentGrant.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Fetches a single scope consent grant for the application
    * @param grantId  (required)
    * @return OAuth2ScopeConsentGrant
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/grants/{grantId}")
    public OAuth2ScopeConsentGrant getScopeConsentGrant(String grantId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(grantId, "'grantId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/grants/" + grantId + "",
            OAuth2ScopeConsentGrant.class,
            queryArgs,
            headers);
     }




    /**
    * Deactivate Application
    * Deactivates an active application.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/lifecycle/deactivate")
    public void deactivate() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/apps/" + appId + "/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * 
    * @param csrId  (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/credentials/csrs/{csrId}/lifecycle/publish")
    public JsonWebKey publishBinaryPemCert(String csrId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(csrId, "'csrId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "/lifecycle/publish",
            new DefaultVoidResource(getDataStore()),
            this,
            JsonWebKey.class,
            queryArgs,
            headers);

    }




    /**
    * Update Application
    * Updates an application in your organization.
    * @return Application
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "PUT - /api/v1/apps/{appId}")
    public Application update() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/apps/" + appId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }




    /**
    * List Key Credentials for Application
    * Enumerates key credentials for an application
    * @return JsonWebKeyList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/credentials/keys")
    public JsonWebKeyList listKeys() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/credentials/keys",
            JsonWebKeyList.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Gets a token for the specified application
    * @param tokenId  (required)
    * @param expand  (optional)
    * @return OAuth2Token
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/tokens/{tokenId}")
    public OAuth2Token getOAuth2Token(String tokenId, String expand) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(tokenId, "'tokenId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/tokens/" + tokenId + "",
            OAuth2Token.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Gets a token for the specified application
    * @param tokenId  (required)
    * @return OAuth2Token
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/tokens/{tokenId}")
    public OAuth2Token getOAuth2Token(String tokenId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(tokenId, "'tokenId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/tokens/" + tokenId + "",
            OAuth2Token.class,
            queryArgs,
            headers);
     }




    /**
    * List Certificate Signing Requests for Application
    * Enumerates Certificate Signing Requests for an application
    * @return CsrList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/credentials/csrs")
    public CsrList listCsrs() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/credentials/csrs",
            CsrList.class,
            queryArgs,
            headers);
    }




    /**
    * List Users Assigned to Application
    * Enumerates all assigned [application users](#application-user-model) for an application.
    * @param q  (optional)
    * @param queryScope  (optional)
    * @param filter  (optional)
    * @param expand  (optional)
    * @return AppUserList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/users")
    public AppUserList listApplicationUsers(String q, String queryScope, String filter, String expand) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (q != null) queryArgs.put("q", q);
        if (queryScope != null) queryArgs.put("query_scope", queryScope);
        if (filter != null) queryArgs.put("filter", filter);
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/users",
            AppUserList.class,
            queryArgs,
            headers);
    }

    /**
    * List Users Assigned to Application
    * Enumerates all assigned [application users](#application-user-model) for an application.
    * @return AppUserList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/users")
    public AppUserList listApplicationUsers() {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/users",
            AppUserList.class,
            queryArgs,
            headers);
     }




    /**
    * Get Key Credential for Application
    * Gets a specific application key credential by kid
    * @param keyId  (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/apps/{appId}/credentials/keys/{keyId}")
    public JsonWebKey getApplicationKey(String keyId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(keyId, "'keyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/apps/" + appId + "/credentials/keys/" + keyId + "",
            JsonWebKey.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * 
    * @param csrId  (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/credentials/csrs/{csrId}/lifecycle/publish")
    public JsonWebKey publishCerCert(String csrId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(csrId, "'csrId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "/lifecycle/publish",
            new DefaultVoidResource(getDataStore()),
            this,
            JsonWebKey.class,
            queryArgs,
            headers);

    }




    /**
    * Updates a Feature object for an application.
    * Updates a Feature object for an application.
    * @param name  (required)
    * @param capabilities  (required)
    * @return ApplicationFeature
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "PUT - /api/v1/apps/{appId}/features/{name}")
    public ApplicationFeature updateFeatureForApplication(String name, CapabilitiesObject capabilities) {

        String appId = getId();

        notNull(capabilities, "'capabilities' is required and cannot be null.");
        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(name, "'name' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/apps/" + appId + "/features/" + name + "";
        return getDataStore().save(href, capabilities, ApplicationFeature.class, false);

    }




    /**
    * 
    * 
    * @param csrId  (required)
    * @return JsonWebKey
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/credentials/csrs/{csrId}/lifecycle/publish")
    public JsonWebKey publishBinaryDerCert(String csrId) {

        String appId = getId();

        hasText(appId, "'appId' is required and cannot be null or empty.");
        hasText(csrId, "'csrId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/apps/" + appId + "/credentials/csrs/" + csrId + "/lifecycle/publish",
            new DefaultVoidResource(getDataStore()),
            this,
            JsonWebKey.class,
            queryArgs,
            headers);

    }




    /**
    * The file must be in PNG, JPG, or GIF format, and less than 1 MB in size. For best results use landscape orientation, a transparent background, and a minimum size of 420px by 120px to prevent upscaling.
    * Update the logo for an application.
    * @param appId  (required)
    * @param file  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/logo")
    public void uploadApplicationLogo(String appId, File file) {



        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();
        headers.add("x-contentType", "multipart/form-data");

        getDataStore().create(
            "/api/v1/apps/" + appId + "/logo",
            new DefaultFileResource(getDataStore(), file.getAbsoluteFile().toPath(), "file"),
            null,
            VoidResource.class,
            queryArgs,
            headers);

    }



}
