/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.application;

import com.okta.sdk.resource.application.ProvisioningConnection;
import com.okta.sdk.resource.application.ProvisioningConnectionAuthScheme;
import com.okta.sdk.resource.application.ProvisioningConnectionProfile;
import com.okta.sdk.resource.application.ProvisioningConnectionRequest;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * ProvisioningConnectionProfile
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-09-19T13:58:37.007-05:00")
public class DefaultProvisioningConnectionProfile extends AbstractResource implements ProvisioningConnectionProfile {

    private final static EnumProperty<ProvisioningConnectionAuthScheme> authSchemeProperty = new EnumProperty("authScheme", ProvisioningConnectionAuthScheme.class);
    private final static StringProperty tokenProperty = new StringProperty("token");

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(authSchemeProperty, tokenProperty);

    public DefaultProvisioningConnectionProfile(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultProvisioningConnectionProfile(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }


    public ProvisioningConnectionAuthScheme getAuthScheme() {
        return  getEnumProperty(authSchemeProperty);
    }

    public ProvisioningConnectionProfile setAuthScheme(ProvisioningConnectionAuthScheme authScheme) {
        setProperty(authSchemeProperty, authScheme);
        return this;
    }

    public String getToken() {
        return  getString(tokenProperty);
    }

    public ProvisioningConnectionProfile setToken(String token) {
        setProperty(tokenProperty, token);
        return this;
    }


    /**
    * Sets the default Provisioning Connection for an application.
    * Set default Provisioning Connection for application
    * @param appId  (required)
    * @param profile  (required)
    * @param activate  (optional)
    * @return ProvisioningConnection
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/connections/default")
    public ProvisioningConnection setDefaultProvisioningConnectionForApplication(String appId, ProvisioningConnectionRequest profile, Boolean activate) {



        notNull(profile, "'profile' is required and cannot be null.");
        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (activate != null) queryArgs.put("activate", activate);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/apps/" + appId + "/connections/default",
            profile,
            this,
            ProvisioningConnection.class,
            queryArgs,
            headers);

    }

    /**
    * Sets the default Provisioning Connection for an application.
    * Set default Provisioning Connection for application
    * @param appId  (required)
    * @param profile  (required)
    * @return ProvisioningConnection
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/apps/{appId}/connections/default")
    public ProvisioningConnection setDefaultProvisioningConnectionForApplication(String appId, ProvisioningConnectionRequest profile) {



        notNull(profile, "'profile' is required and cannot be null.");
        hasText(appId, "'appId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/apps/" + appId + "/connections/default",
            profile,
            this,
            ProvisioningConnection.class,
            queryArgs,
            headers);

     }



}
