/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.authorization.server.policy;

import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRule;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRuleActions;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRuleConditions;
import java.util.Date;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * AuthorizationServerPolicyRule
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-09-19T13:58:37.007-05:00")
public class DefaultAuthorizationServerPolicyRule extends AbstractInstanceResource<AuthorizationServerPolicyRule> implements AuthorizationServerPolicyRule {

    private final static ResourceReference<AuthorizationServerPolicyRuleActions> actionsProperty = new ResourceReference("actions", AuthorizationServerPolicyRuleActions.class, false);
    private final static ResourceReference<AuthorizationServerPolicyRuleConditions> conditionsProperty = new ResourceReference("conditions", AuthorizationServerPolicyRuleConditions.class, false);
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static IntegerProperty priorityProperty = new IntegerProperty("priority");
    private final static EnumProperty<StatusEnum> statusProperty = new EnumProperty("status", StatusEnum.class);
    private final static BooleanProperty systemProperty = new BooleanProperty("system");
    private final static EnumProperty<TypeEnum> typeProperty = new EnumProperty("type", TypeEnum.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(actionsProperty, conditionsProperty, createdProperty, idProperty, lastUpdatedProperty, nameProperty, priorityProperty, statusProperty, systemProperty, typeProperty);

    public DefaultAuthorizationServerPolicyRule(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultAuthorizationServerPolicyRule(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return AuthorizationServerPolicyRule.class;
    }

    public AuthorizationServerPolicyRuleActions getActions() {
        return  getResourceProperty(actionsProperty);
    }

    public AuthorizationServerPolicyRule setActions(AuthorizationServerPolicyRuleActions actions) {
        setProperty(actionsProperty, actions);
        return this;
    }

    public AuthorizationServerPolicyRuleConditions getConditions() {
        return  getResourceProperty(conditionsProperty);
    }

    public AuthorizationServerPolicyRule setConditions(AuthorizationServerPolicyRuleConditions conditions) {
        setProperty(conditionsProperty, conditions);
        return this;
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public AuthorizationServerPolicyRule setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public Integer getPriority() {
        return  getIntProperty(priorityProperty);
    }

    public AuthorizationServerPolicyRule setPriority(Integer priority) {
        setProperty(priorityProperty, priority);
        return this;
    }

    public StatusEnum getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public AuthorizationServerPolicyRule setStatus(StatusEnum status) {
        setProperty(statusProperty, status);
        return this;
    }

    public Boolean getSystem() {
        return  getBoolean(systemProperty);
    }

    public AuthorizationServerPolicyRule setSystem(Boolean system) {
        setProperty(systemProperty, system);
        return this;
    }

    public TypeEnum getType() {
        return  getEnumProperty(typeProperty);
    }

    public AuthorizationServerPolicyRule setType(TypeEnum type) {
        setProperty(typeProperty, type);
        return this;
    }


    /**
    * 
    * Updates the configuration of the Policy Rule defined in the specified Custom Authorization Server and Policy.
    * @param authServerId  (required)
    * @return AuthorizationServerPolicyRule
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "PUT - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}")
    public AuthorizationServerPolicyRule update(String authServerId) {

        String ruleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}");
        String policyId = pathArgs.get("policyId");

        hasText(policyId, "'policyId' is required and cannot be null or empty.");
        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }




    /**
    * 
    * Activate Authorization Server Policy Rule
    * @param authServerId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/activate")
    public void activate(String authServerId) {

        String ruleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/activate");
        String policyId = pathArgs.get("policyId");

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(policyId, "'policyId' is required and cannot be null or empty.");
        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Deactivate Authorization Server Policy Rule
    * @param authServerId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate")
    public void deactivate(String authServerId) {

        String ruleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate");
        String policyId = pathArgs.get("policyId");

        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(policyId, "'policyId' is required and cannot be null or empty.");
        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Deletes a Policy Rule defined in the specified Custom Authorization Server and Policy.
    * @param authServerId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "DELETE - /api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}")
    public void delete(String authServerId) {

        String ruleId = getId();
        Map<String, String> pathArgs = getParamsFromHref("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}");
        String policyId = pathArgs.get("policyId");

        hasText(policyId, "'policyId' is required and cannot be null or empty.");
        hasText(authServerId, "'authServerId' is required and cannot be null or empty.");
        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "",
            (Resource) this,
            queryArgs,
            headers);
    }



}
