/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.brand;

import com.okta.sdk.resource.brand.Brand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * Brand
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-09-19T13:58:37.007-05:00")
public class DefaultBrand extends AbstractInstanceResource<Brand> implements Brand {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static BooleanProperty agreeToCustomPrivacyPolicyProperty = new BooleanProperty("agreeToCustomPrivacyPolicy");
    private final static StringProperty customPrivacyPolicyUrlProperty = new StringProperty("customPrivacyPolicyUrl");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static BooleanProperty removePoweredByOktaProperty = new BooleanProperty("removePoweredByOkta");

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, agreeToCustomPrivacyPolicyProperty, customPrivacyPolicyUrlProperty, idProperty, removePoweredByOktaProperty);

    public DefaultBrand(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultBrand(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Brand.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public Boolean getAgreeToCustomPrivacyPolicy() {
        return  getBoolean(agreeToCustomPrivacyPolicyProperty);
    }

    public Brand setAgreeToCustomPrivacyPolicy(Boolean agreeToCustomPrivacyPolicy) {
        setProperty(agreeToCustomPrivacyPolicyProperty, agreeToCustomPrivacyPolicy);
        return this;
    }

    public String getCustomPrivacyPolicyUrl() {
        return  getString(customPrivacyPolicyUrlProperty);
    }

    public Brand setCustomPrivacyPolicyUrl(String customPrivacyPolicyUrl) {
        setProperty(customPrivacyPolicyUrlProperty, customPrivacyPolicyUrl);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Boolean getRemovePoweredByOkta() {
        return  getBoolean(removePoweredByOktaProperty);
    }

    public Brand setRemovePoweredByOkta(Boolean removePoweredByOkta) {
        setProperty(removePoweredByOktaProperty, removePoweredByOkta);
        return this;
    }


    /**
    * Update Brand
    * Updates a brand by &#x60;brandId&#x60;
    * @return Brand
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "PUT - /api/v1/brands/{brandId}")
    public Brand update() {

        String brandId = getId();

        hasText(brandId, "'brandId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/brands/" + brandId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }



}
