/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.brand;

import com.okta.sdk.resource.brand.EmailTemplateTouchPointVariant;
import com.okta.sdk.resource.brand.EndUserDashboardTouchPointVariant;
import com.okta.sdk.resource.brand.ErrorPageTouchPointVariant;
import com.okta.sdk.resource.brand.ImageUploadResponse;
import com.okta.sdk.resource.brand.SignInPageTouchPointVariant;
import com.okta.sdk.resource.brand.Theme;
import com.okta.sdk.resource.brand.ThemeResponse;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * Theme
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-09-19T13:58:37.007-05:00")
public class DefaultTheme extends AbstractInstanceResource<Theme> implements Theme {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static StringProperty backgroundImageProperty = new StringProperty("backgroundImage");
    private final static EnumProperty<EmailTemplateTouchPointVariant> emailTemplateTouchPointVariantProperty = new EnumProperty("emailTemplateTouchPointVariant", EmailTemplateTouchPointVariant.class);
    private final static EnumProperty<EndUserDashboardTouchPointVariant> endUserDashboardTouchPointVariantProperty = new EnumProperty("endUserDashboardTouchPointVariant", EndUserDashboardTouchPointVariant.class);
    private final static EnumProperty<ErrorPageTouchPointVariant> errorPageTouchPointVariantProperty = new EnumProperty("errorPageTouchPointVariant", ErrorPageTouchPointVariant.class);
    private final static StringProperty primaryColorContrastHexProperty = new StringProperty("primaryColorContrastHex");
    private final static StringProperty primaryColorHexProperty = new StringProperty("primaryColorHex");
    private final static StringProperty secondaryColorContrastHexProperty = new StringProperty("secondaryColorContrastHex");
    private final static StringProperty secondaryColorHexProperty = new StringProperty("secondaryColorHex");
    private final static EnumProperty<SignInPageTouchPointVariant> signInPageTouchPointVariantProperty = new EnumProperty("signInPageTouchPointVariant", SignInPageTouchPointVariant.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, backgroundImageProperty, emailTemplateTouchPointVariantProperty, endUserDashboardTouchPointVariantProperty, errorPageTouchPointVariantProperty, primaryColorContrastHexProperty, primaryColorHexProperty, secondaryColorContrastHexProperty, secondaryColorHexProperty, signInPageTouchPointVariantProperty);

    public DefaultTheme(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultTheme(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Theme.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public String getBackgroundImage() {
        return  getString(backgroundImageProperty);
    }

    public EmailTemplateTouchPointVariant getEmailTemplateTouchPointVariant() {
        return  getEnumProperty(emailTemplateTouchPointVariantProperty);
    }

    public Theme setEmailTemplateTouchPointVariant(EmailTemplateTouchPointVariant emailTemplateTouchPointVariant) {
        setProperty(emailTemplateTouchPointVariantProperty, emailTemplateTouchPointVariant);
        return this;
    }

    public EndUserDashboardTouchPointVariant getEndUserDashboardTouchPointVariant() {
        return  getEnumProperty(endUserDashboardTouchPointVariantProperty);
    }

    public Theme setEndUserDashboardTouchPointVariant(EndUserDashboardTouchPointVariant endUserDashboardTouchPointVariant) {
        setProperty(endUserDashboardTouchPointVariantProperty, endUserDashboardTouchPointVariant);
        return this;
    }

    public ErrorPageTouchPointVariant getErrorPageTouchPointVariant() {
        return  getEnumProperty(errorPageTouchPointVariantProperty);
    }

    public Theme setErrorPageTouchPointVariant(ErrorPageTouchPointVariant errorPageTouchPointVariant) {
        setProperty(errorPageTouchPointVariantProperty, errorPageTouchPointVariant);
        return this;
    }

    public String getPrimaryColorContrastHex() {
        return  getString(primaryColorContrastHexProperty);
    }

    public Theme setPrimaryColorContrastHex(String primaryColorContrastHex) {
        setProperty(primaryColorContrastHexProperty, primaryColorContrastHex);
        return this;
    }

    public String getPrimaryColorHex() {
        return  getString(primaryColorHexProperty);
    }

    public Theme setPrimaryColorHex(String primaryColorHex) {
        setProperty(primaryColorHexProperty, primaryColorHex);
        return this;
    }

    public String getSecondaryColorContrastHex() {
        return  getString(secondaryColorContrastHexProperty);
    }

    public Theme setSecondaryColorContrastHex(String secondaryColorContrastHex) {
        setProperty(secondaryColorContrastHexProperty, secondaryColorContrastHex);
        return this;
    }

    public String getSecondaryColorHex() {
        return  getString(secondaryColorHexProperty);
    }

    public Theme setSecondaryColorHex(String secondaryColorHex) {
        setProperty(secondaryColorHexProperty, secondaryColorHex);
        return this;
    }

    public SignInPageTouchPointVariant getSignInPageTouchPointVariant() {
        return  getEnumProperty(signInPageTouchPointVariantProperty);
    }

    public Theme setSignInPageTouchPointVariant(SignInPageTouchPointVariant signInPageTouchPointVariant) {
        setProperty(signInPageTouchPointVariantProperty, signInPageTouchPointVariant);
        return this;
    }


    /**
    * Deletes a Theme favicon. The org then uses the Okta default favicon.
    * Deletes a Theme favicon. The org then uses the Okta default favicon.
    * @param brandId  (required)
    * @param themeId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "DELETE - /api/v1/brands/{brandId}/themes/{themeId}/favicon")
    public void deleteBrandThemeFavicon(String brandId, String themeId) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(themeId, "'themeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/brands/" + brandId + "/themes/" + themeId + "/favicon",
            queryArgs,
            headers);
    }




    /**
    * Deletes a Theme logo. The org then uses the Okta default logo.
    * Deletes a Theme logo. The org then uses the Okta default logo.
    * @param brandId  (required)
    * @param themeId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "DELETE - /api/v1/brands/{brandId}/themes/{themeId}/logo")
    public void deleteBrandThemeLogo(String brandId, String themeId) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(themeId, "'themeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/brands/" + brandId + "/themes/" + themeId + "/logo",
            queryArgs,
            headers);
    }




    /**
    * Deletes a Theme background image
    * Deletes a Theme background image
    * @param brandId  (required)
    * @param themeId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "DELETE - /api/v1/brands/{brandId}/themes/{themeId}/background-image")
    public void deleteBrandThemeBackgroundImage(String brandId, String themeId) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(themeId, "'themeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/brands/" + brandId + "/themes/" + themeId + "/background-image",
            queryArgs,
            headers);
    }




    /**
    * Updates the favicon for your theme
    * Updates the favicon for your theme
    * @param brandId  (required)
    * @param themeId  (required)
    * @param file  (required)
    * @return ImageUploadResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/brands/{brandId}/themes/{themeId}/favicon")
    public ImageUploadResponse updateBrandThemeFavicon(String brandId, String themeId, File file) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(themeId, "'themeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();
        headers.add("x-contentType", "multipart/form-data");

        return getDataStore().create(
            "/api/v1/brands/" + brandId + "/themes/" + themeId + "/favicon",
            new DefaultFileResource(getDataStore(), file.getAbsoluteFile().toPath(), "file"),
            null,
            ImageUploadResponse.class,
            queryArgs,
            headers);

    }




    /**
    * Update a themes logo
    * Updates the logo for your Theme
    * @param brandId  (required)
    * @param themeId  (required)
    * @param file  (required)
    * @return ImageUploadResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/brands/{brandId}/themes/{themeId}/logo")
    public ImageUploadResponse uploadBrandThemeLogo(String brandId, String themeId, File file) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(themeId, "'themeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();
        headers.add("x-contentType", "multipart/form-data");

        return getDataStore().create(
            "/api/v1/brands/" + brandId + "/themes/" + themeId + "/logo",
            new DefaultFileResource(getDataStore(), file.getAbsoluteFile().toPath(), "file"),
            null,
            ImageUploadResponse.class,
            queryArgs,
            headers);

    }




    /**
    * Updates the background image for your Theme
    * Updates the background image for your Theme
    * @param brandId  (required)
    * @param themeId  (required)
    * @param file  (required)
    * @return ImageUploadResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/brands/{brandId}/themes/{themeId}/background-image")
    public ImageUploadResponse updateBrandThemeBackgroundImage(String brandId, String themeId, File file) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(themeId, "'themeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();
        headers.add("x-contentType", "multipart/form-data");

        return getDataStore().create(
            "/api/v1/brands/" + brandId + "/themes/" + themeId + "/background-image",
            new DefaultFileResource(getDataStore(), file.getAbsoluteFile().toPath(), "file"),
            null,
            ImageUploadResponse.class,
            queryArgs,
            headers);

    }




    /**
    * Update a theme for a brand
    * Updates a theme for a brand
    * @param brandId  (required)
    * @param themeId  (required)
    * @param theme  (required)
    * @return ThemeResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "PUT - /api/v1/brands/{brandId}/themes/{themeId}")
    public ThemeResponse update(String brandId, String themeId, Theme theme) {



        notNull(theme, "'theme' is required and cannot be null.");
        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(themeId, "'themeId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/brands/" + brandId + "/themes/" + themeId + "";
        return getDataStore().save(href, theme, ThemeResponse.class, false);

    }



}
