/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.brands;

import com.okta.sdk.resource.brands.EmailTemplate;
import com.okta.sdk.resource.brands.EmailTemplateContent;
import com.okta.sdk.resource.brands.EmailTemplateCustomization;
import com.okta.sdk.resource.brands.EmailTemplateCustomizationList;
import com.okta.sdk.resource.brands.EmailTemplateCustomizationRequest;
import com.okta.sdk.resource.brands.EmailTemplateTestRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * EmailTemplate
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-09-19T13:58:37.007-05:00")
public class DefaultEmailTemplate extends AbstractInstanceResource<EmailTemplate> implements EmailTemplate {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static StringProperty nameProperty = new StringProperty("name");

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, nameProperty);

    public DefaultEmailTemplate(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultEmailTemplate(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return EmailTemplate.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public String getName() {
        return  getString(nameProperty);
    }


    /**
    * Delete Email Customization
    * Delete an email customization
    * @param brandId  (required)
    * @param templateName  (required)
    * @param customizationId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "DELETE - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}")
    public void deleteEmailTemplateCustomization(String brandId, String templateName, String customizationId) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(templateName, "'templateName' is required and cannot be null or empty.");
        hasText(customizationId, "'customizationId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations/" + customizationId + "",
            queryArgs,
            headers);
    }




    /**
    * Get Preview of Email Template Default Content
    * Send a test email to the current users primary and secondary email addresses. The email content is selected based on the following priority: An email customization specifically for the users locale. The default language of email customizations. The email templates default content.
    * @param brandId  (required)
    * @param templateName  (required)
    * @param customization  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/brands/{brandId}/templates/email/{templateName}/test")
    public void sendTestEmail(String brandId, String templateName, EmailTemplateTestRequest customization) {



        notNull(customization, "'customization' is required and cannot be null.");
        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(templateName, "'templateName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/test",
            customization,
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * Get Email Template Customization
    * Fetch an email customization by id.
    * @param brandId  (required)
    * @param templateName  (required)
    * @param customizationId  (required)
    * @return EmailTemplateCustomization
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}")
    public EmailTemplateCustomization getEmailTemplateCustomization(String brandId, String templateName, String customizationId) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(templateName, "'templateName' is required and cannot be null or empty.");
        hasText(customizationId, "'customizationId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations/" + customizationId + "",
            EmailTemplateCustomization.class,
            queryArgs,
            headers);
    }




    /**
    * Get Preview Content of Email Customization
    * Get a preview of an email template customization.
    * @param brandId  (required)
    * @param templateName  (required)
    * @param customizationId  (required)
    * @return EmailTemplateContent
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}/preview")
    public EmailTemplateContent getEmailTemplateCustomizationPreview(String brandId, String templateName, String customizationId) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(templateName, "'templateName' is required and cannot be null or empty.");
        hasText(customizationId, "'customizationId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations/" + customizationId + "/preview",
            EmailTemplateContent.class,
            queryArgs,
            headers);
    }




    /**
    * Create Email Template Customization
    * Create an email customization
    * @param brandId  (required)
    * @param templateName  (required)
    * @param customization  (required)
    * @return EmailTemplateCustomization
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations")
    public EmailTemplateCustomization createEmailTemplateCustomization(String brandId, String templateName, EmailTemplateCustomizationRequest customization) {



        notNull(customization, "'customization' is required and cannot be null.");
        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(templateName, "'templateName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations",
            customization,
            this,
            EmailTemplateCustomization.class,
            queryArgs,
            headers);

    }




    /**
    * Get Preview of Email Template Default Content
    * Fetch a preview of an email template&#39;s default content by populating velocity references with the current user&#39;s environment.
    * @param brandId  (required)
    * @param templateName  (required)
    * @return EmailTemplateContent
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/brands/{brandId}/templates/email/{templateName}/default-content/preview")
    public EmailTemplateContent getEmailTemplateDefaultContentPreview(String brandId, String templateName) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(templateName, "'templateName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/default-content/preview",
            EmailTemplateContent.class,
            queryArgs,
            headers);
    }




    /**
    * Delete Email Template Customization
    * Delete all customizations for an email template. Also known as “Reset to Default”.
    * @param brandId  (required)
    * @param templateName  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "DELETE - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations")
    public void deleteEmailTemplateCustomizations(String brandId, String templateName) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(templateName, "'templateName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations",
            queryArgs,
            headers);
    }




    /**
    * List Email Template Customization
    * List all email customizations for an email template
    * @param brandId  (required)
    * @param templateName  (required)
    * @return EmailTemplateCustomizationList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations")
    public EmailTemplateCustomizationList listEmailTemplateCustomizations(String brandId, String templateName) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(templateName, "'templateName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations",
            EmailTemplateCustomizationList.class,
            queryArgs,
            headers);
    }




    /**
    * Update Email Customization
    * Update an email customization
    * @param brandId  (required)
    * @param templateName  (required)
    * @param customizationId  (required)
    * @param customization  (required)
    * @return EmailTemplateCustomization
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "PUT - /api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}")
    public EmailTemplateCustomization updateEmailTemplateCustomization(String brandId, String templateName, String customizationId, EmailTemplateCustomizationRequest customization) {



        notNull(customization, "'customization' is required and cannot be null.");
        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(templateName, "'templateName' is required and cannot be null or empty.");
        hasText(customizationId, "'customizationId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/customizations/" + customizationId + "";
        return getDataStore().save(href, customization, EmailTemplateCustomization.class, false);

    }




    /**
    * Get Default Content of Email Template
    * Fetch the default content for an email template.
    * @param brandId  (required)
    * @param templateName  (required)
    * @return EmailTemplateContent
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/brands/{brandId}/templates/email/{templateName}/default-content")
    public EmailTemplateContent getEmailTemplateDefaultContent(String brandId, String templateName) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(templateName, "'templateName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/brands/" + brandId + "/templates/email/" + templateName + "/default-content",
            EmailTemplateContent.class,
            queryArgs,
            headers);
    }




    /**
    * Get Email Template
    * Fetch an email template by templateName
    * @param brandId  (required)
    * @param templateName  (required)
    * @return EmailTemplate
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/brands/{brandId}/templates/email/{templateName}")
    public EmailTemplate getEmailTemplate(String brandId, String templateName) {



        hasText(brandId, "'brandId' is required and cannot be null or empty.");
        hasText(templateName, "'templateName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/brands/" + brandId + "/templates/email/" + templateName + "",
            EmailTemplate.class,
            queryArgs,
            headers);
    }



}
