/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.domain;

import com.okta.sdk.resource.domain.DomainCertificate;
import com.okta.sdk.resource.domain.DomainCertificateType;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * DomainCertificate
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-09-19T13:58:37.007-05:00")
public class DefaultDomainCertificate extends AbstractInstanceResource<DomainCertificate> implements DomainCertificate {

    private final static StringProperty certificateProperty = new StringProperty("certificate");
    private final static StringProperty certificateChainProperty = new StringProperty("certificateChain");
    private final static StringProperty privateKeyProperty = new StringProperty("privateKey");
    private final static EnumProperty<DomainCertificateType> typeProperty = new EnumProperty("type", DomainCertificateType.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(certificateProperty, certificateChainProperty, privateKeyProperty, typeProperty);

    public DefaultDomainCertificate(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultDomainCertificate(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return DomainCertificate.class;
    }

    public String getCertificate() {
        return  getString(certificateProperty);
    }

    public DomainCertificate setCertificate(String certificate) {
        setProperty(certificateProperty, certificate);
        return this;
    }

    public String getCertificateChain() {
        return  getString(certificateChainProperty);
    }

    public DomainCertificate setCertificateChain(String certificateChain) {
        setProperty(certificateChainProperty, certificateChain);
        return this;
    }

    public String getPrivateKey() {
        return  getString(privateKeyProperty);
    }

    public DomainCertificate setPrivateKey(String privateKey) {
        setProperty(privateKeyProperty, privateKey);
        return this;
    }

    public DomainCertificateType getType() {
        return  getEnumProperty(typeProperty);
    }

    public DomainCertificate setType(DomainCertificateType type) {
        setProperty(typeProperty, type);
        return this;
    }


    /**
    * Create Certificate
    * Creates the Certificate for the Domain.
    * @param domainId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "PUT - /api/v1/domains/{domainId}/certificate")
    public void createCertificate(String domainId) {



        hasText(domainId, "'domainId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/domains/" + domainId + "/certificate";
        getDataStore().save(href, this, null, queryArgs, headers);

    }



}
