/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.linked.object;

import com.okta.sdk.resource.linked.object.LinkedObject;
import com.okta.sdk.resource.linked.object.LinkedObjectDetails;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * LinkedObject
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-09-19T13:58:37.007-05:00")
public class DefaultLinkedObject extends AbstractInstanceResource<LinkedObject> implements LinkedObject {

    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static ResourceReference<LinkedObjectDetails> associatedProperty = new ResourceReference("associated", LinkedObjectDetails.class, false);
    private final static ResourceReference<LinkedObjectDetails> primaryProperty = new ResourceReference("primary", LinkedObjectDetails.class, false);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(linksProperty, associatedProperty, primaryProperty);

    public DefaultLinkedObject(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultLinkedObject(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return LinkedObject.class;
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public LinkedObjectDetails getAssociated() {
        return  getResourceProperty(associatedProperty);
    }

    public LinkedObject setAssociated(LinkedObjectDetails associated) {
        setProperty(associatedProperty, associated);
        return this;
    }

    public LinkedObjectDetails getPrimary() {
        return  getResourceProperty(primaryProperty);
    }

    public LinkedObject setPrimary(LinkedObjectDetails primary) {
        setProperty(primaryProperty, primary);
        return this;
    }


    /**
    * 
    * Success
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "DELETE - /api/v1/meta/schemas/user/linkedObjects/{linkedObjectName}")
    public void delete() {

        String linkedObjectName = getPrimary().getName();

        hasText(linkedObjectName, "'linkedObjectName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/meta/schemas/user/linkedObjects/" + linkedObjectName + "",
            (Resource) this,
            queryArgs,
            headers);
    }



}
