/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.policy;

import com.okta.sdk.resource.policy.Policy;
import com.okta.sdk.resource.policy.PolicyRule;
import com.okta.sdk.resource.policy.PolicyRuleConditions;
import com.okta.sdk.resource.policy.PolicyRuleList;
import com.okta.sdk.resource.policy.PolicyType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * Policy
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2022-09-19T13:58:37.007-05:00")
public class DefaultPolicy extends AbstractInstanceResource<Policy> implements Policy {

    private final static MapProperty embeddedProperty = new MapProperty("_embedded");
    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static ResourceReference<PolicyRuleConditions> conditionsProperty = new ResourceReference("conditions", PolicyRuleConditions.class, false);
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty descriptionProperty = new StringProperty("description");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static StringProperty nameProperty = new StringProperty("name");
    private final static IntegerProperty priorityProperty = new IntegerProperty("priority");
    private final static EnumProperty<StatusEnum> statusProperty = new EnumProperty("status", StatusEnum.class);
    private final static BooleanProperty systemProperty = new BooleanProperty("system");
    private final static EnumProperty<PolicyType> typeProperty = new EnumProperty("type", PolicyType.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(embeddedProperty, linksProperty, conditionsProperty, createdProperty, descriptionProperty, idProperty, lastUpdatedProperty, nameProperty, priorityProperty, statusProperty, systemProperty, typeProperty);

    public DefaultPolicy(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultPolicy(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Policy.class;
    }

    public Map<String, Object> getEmbedded() {
        return  getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public PolicyRuleConditions getConditions() {
        return  getResourceProperty(conditionsProperty);
    }

    public Policy setConditions(PolicyRuleConditions conditions) {
        setProperty(conditionsProperty, conditions);
        return this;
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getDescription() {
        return  getString(descriptionProperty);
    }

    public Policy setDescription(String description) {
        setProperty(descriptionProperty, description);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return  getString(nameProperty);
    }

    public Policy setName(String name) {
        setProperty(nameProperty, name);
        return this;
    }

    public Integer getPriority() {
        return  getIntProperty(priorityProperty);
    }

    public Policy setPriority(Integer priority) {
        setProperty(priorityProperty, priority);
        return this;
    }

    public StatusEnum getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public Policy setStatus(StatusEnum status) {
        setProperty(statusProperty, status);
        return this;
    }

    public Boolean getSystem() {
        return  getBoolean(systemProperty);
    }

    public Policy setSystem(Boolean system) {
        setProperty(systemProperty, system);
        return this;
    }

    public PolicyType getType() {
        return  getEnumProperty(typeProperty);
    }

    public Policy setType(PolicyType type) {
        setProperty(typeProperty, type);
        return this;
    }


    /**
    * 
    * Creates a policy rule.
    * @param policyRule  (required)
    * @return PolicyRule
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/policies/{policyId}/rules")
    public PolicyRule createRule(PolicyRule policyRule) {

        String policyId = getId();

        notNull(policyRule, "'policyRule' is required and cannot be null.");
        hasText(policyId, "'policyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/policies/" + policyId + "/rules",
            policyRule,
            this,
            PolicyRule.class,
            queryArgs,
            headers);
        return policyRule;

    }




    /**
    * 
    * Deactivates a policy.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/policies/{policyId}/lifecycle/deactivate")
    public void deactivate() {

        String policyId = getId();

        hasText(policyId, "'policyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/policies/" + policyId + "/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Updates a policy.
    * @return Policy
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "PUT - /api/v1/policies/{policyId}")
    public Policy update() {

        String policyId = getId();

        hasText(policyId, "'policyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/policies/" + policyId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }




    /**
    * 
    * Removes a policy.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "DELETE - /api/v1/policies/{policyId}")
    public void delete() {

        String policyId = getId();

        hasText(policyId, "'policyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/policies/" + policyId + "",
            (Resource) this,
            queryArgs,
            headers);
    }




    /**
    * 
    * Activates a policy.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "POST - /api/v1/policies/{policyId}/lifecycle/activate")
    public void activate() {

        String policyId = getId();

        hasText(policyId, "'policyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/policies/" + policyId + "/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Enumerates all policy rules.
    * @return PolicyRuleList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/policies/{policyId}/rules")
    public PolicyRuleList listPolicyRules() {

        String policyId = getId();

        hasText(policyId, "'policyId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/policies/" + policyId + "/rules",
            PolicyRuleList.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Gets a policy rule.
    * @param ruleId  (required)
    * @return PolicyRule
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2022-09-19T13:58:37.007-05:00",
          comments = "GET - /api/v1/policies/{policyId}/rules/{ruleId}")
    public PolicyRule getPolicyRule(String ruleId) {

        String policyId = getId();

        hasText(policyId, "'policyId' is required and cannot be null or empty.");
        hasText(ruleId, "'ruleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/policies/" + policyId + "/rules/" + ruleId + "",
            PolicyRule.class,
            queryArgs,
            headers);
    }



}
