/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.group;

import com.okta.sdk.resource.application.ApplicationList;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupProfile;
import com.okta.sdk.resource.group.GroupType;
import com.okta.sdk.resource.role.AssignRoleRequest;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.UserList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * Group
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2023-07-07T08:50:42.885-05:00")
public class DefaultGroup extends AbstractInstanceResource<Group> implements Group {

    private final static MapProperty embeddedProperty = new MapProperty("_embedded");
    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastMembershipUpdatedProperty = new DateProperty("lastMembershipUpdated");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static ListProperty objectClassProperty = new ListProperty("objectClass");
    private final static ResourceReference<GroupProfile> profileProperty = new ResourceReference("profile", GroupProfile.class, true);
    private final static EnumProperty<GroupType> typeProperty = new EnumProperty("type", GroupType.class);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(embeddedProperty, linksProperty, createdProperty, idProperty, lastMembershipUpdatedProperty, lastUpdatedProperty, objectClassProperty, profileProperty, typeProperty);

    public DefaultGroup(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultGroup(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return Group.class;
    }

    public Map<String, Object> getEmbedded() {
        return  getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastMembershipUpdated() {
        return  getDateProperty(lastMembershipUpdatedProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public List<String> getObjectClass() {
        return (List<String>) getListProperty(objectClassProperty);
    }

    public GroupProfile getProfile() {
        return  getResourceProperty(profileProperty);
    }

    public Group setProfile(GroupProfile profile) {
        setProperty(profileProperty, profile);
        return this;
    }

    public GroupType getType() {
        return  getEnumProperty(typeProperty);
    }


    /**
    * 
    * Assigns a Role to a Group
    * @param assignRoleRequest  (required)
    * @param disableNotifications  (optional)
    * @return Role
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/groups/{groupId}/roles")
    public Role assignRole(AssignRoleRequest assignRoleRequest, Boolean disableNotifications) {

        String groupId = getId();

        notNull(assignRoleRequest, "'assignRoleRequest' is required and cannot be null.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (disableNotifications != null) queryArgs.put("disableNotifications", disableNotifications);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/groups/" + groupId + "/roles",
            assignRoleRequest,
            this,
            Role.class,
            queryArgs,
            headers);

    }

    /**
    * 
    * Assigns a Role to a Group
    * @param assignRoleRequest  (required)
    * @return Role
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/groups/{groupId}/roles")
    public Role assignRole(AssignRoleRequest assignRoleRequest) {

        String groupId = getId();

        notNull(assignRoleRequest, "'assignRoleRequest' is required and cannot be null.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/groups/" + groupId + "/roles",
            assignRoleRequest,
            this,
            Role.class,
            queryArgs,
            headers);

     }




    /**
    * List Group Members
    * Enumerates all users that are a member of a group.
    * @return UserList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/groups/{groupId}/users")
    public UserList listUsers() {

        String groupId = getId();

        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups/" + groupId + "/users",
            UserList.class,
            queryArgs,
            headers);
    }




    /**
    * Update Group
    * Updates the profile for a group with &#x60;OKTA_GROUP&#x60; type from your organization.
    * @return Group
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "PUT - /api/v1/groups/{groupId}")
    public Group update() {

        String groupId = getId();

        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/groups/" + groupId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }




    /**
    * Remove User from Group
    * Removes a user from a group with &#39;OKTA_GROUP&#39; type.
    * @param userId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/groups/{groupId}/users/{userId}")
    public void removeUser(String userId) {

        String groupId = getId();

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/groups/" + groupId + "/users/" + userId + "",
            queryArgs,
            headers);
    }




    /**
    * List Assigned Applications
    * Enumerates all applications that are assigned to a group.
    * @return ApplicationList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/groups/{groupId}/apps")
    public ApplicationList listApplications() {

        String groupId = getId();

        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/groups/" + groupId + "/apps",
            ApplicationList.class,
            queryArgs,
            headers);
    }




    /**
    * Remove Group
    * Removes a group with &#x60;OKTA_GROUP&#x60; type from your organization.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/groups/{groupId}")
    public void delete() {

        String groupId = getId();

        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/groups/" + groupId + "",
            (Resource) this,
            queryArgs,
            headers);
    }



}
