/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.impl.resource.user;

import com.okta.sdk.resource.application.OAuth2ClientList;
import com.okta.sdk.resource.application.OAuth2RefreshToken;
import com.okta.sdk.resource.application.OAuth2RefreshTokenList;
import com.okta.sdk.resource.application.OAuth2ScopeConsentGrantList;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.identity.provider.IdentityProviderList;
import com.okta.sdk.resource.role.AssignRoleRequest;
import com.okta.sdk.resource.user.AppLinkList;
import com.okta.sdk.resource.user.ChangePasswordRequest;
import com.okta.sdk.resource.user.ForgotPasswordResponse;
import com.okta.sdk.resource.user.ResetPasswordToken;
import com.okta.sdk.resource.user.ResponseLinksList;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.RoleList;
import com.okta.sdk.resource.user.TempPassword;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserActivationToken;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.UserProfile;
import com.okta.sdk.resource.user.UserStatus;
import com.okta.sdk.resource.user.factor.SecurityQuestionList;
import com.okta.sdk.resource.user.factor.UserFactor;
import com.okta.sdk.resource.user.factor.UserFactorList;
import com.okta.sdk.resource.user.type.UserType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.AbstractResource;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.commons.http.QueryString;
import com.okta.commons.http.HttpHeaders;

import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.DoubleProperty;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.impl.resource.CharacterArrayProperty;
import com.okta.sdk.impl.resource.ListProperty;
import com.okta.sdk.impl.resource.EnumListProperty;
import com.okta.sdk.impl.resource.ResourceListProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.DefaultFileResource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.Resource;
import java.util.Map;
import java.util.HashMap;

import static com.okta.commons.lang.Assert.notNull;
import static com.okta.commons.lang.Assert.hasText;


/**
 * User
 */
@javax.annotation.Generated(
        value = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
        date  = "2023-07-07T08:50:42.885-05:00")
public class DefaultUser extends AbstractInstanceResource<User> implements User {

    private final static MapProperty embeddedProperty = new MapProperty("_embedded");
    private final static MapProperty linksProperty = new MapProperty("_links");
    private final static DateProperty activatedProperty = new DateProperty("activated");
    private final static DateProperty createdProperty = new DateProperty("created");
    private final static ResourceReference<UserCredentials> credentialsProperty = new ResourceReference("credentials", UserCredentials.class, false);
    private final static StringProperty idProperty = new StringProperty("id");
    private final static DateProperty lastLoginProperty = new DateProperty("lastLogin");
    private final static DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private final static DateProperty passwordChangedProperty = new DateProperty("passwordChanged");
    private final static ResourceReference<UserProfile> profileProperty = new ResourceReference("profile", UserProfile.class, true);
    private final static EnumProperty<UserStatus> statusProperty = new EnumProperty("status", UserStatus.class);
    private final static DateProperty statusChangedProperty = new DateProperty("statusChanged");
    private final static EnumProperty<UserStatus> transitioningToStatusProperty = new EnumProperty("transitioningToStatus", UserStatus.class);
    private final static ResourceReference<UserType> typeProperty = new ResourceReference("type", UserType.class, false);

    private final static Map<String, Property> PROPERTY_DESCRIPTORS = createPropertyDescriptorMap(embeddedProperty, linksProperty, activatedProperty, createdProperty, credentialsProperty, idProperty, lastLoginProperty, lastUpdatedProperty, passwordChangedProperty, profileProperty, statusProperty, statusChangedProperty, transitioningToStatusProperty, typeProperty);

    public DefaultUser(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultUser(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return User.class;
    }

    public Map<String, Object> getEmbedded() {
        return  getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return  getMap(linksProperty);
    }

    public Date getActivated() {
        return  getDateProperty(activatedProperty);
    }

    public Date getCreated() {
        return  getDateProperty(createdProperty);
    }

    public UserCredentials getCredentials() {
        return  getResourceProperty(credentialsProperty);
    }

    public User setCredentials(UserCredentials credentials) {
        setProperty(credentialsProperty, credentials);
        return this;
    }

    public String getId() {
        return  getString(idProperty);
    }

    public Date getLastLogin() {
        return  getDateProperty(lastLoginProperty);
    }

    public Date getLastUpdated() {
        return  getDateProperty(lastUpdatedProperty);
    }

    public Date getPasswordChanged() {
        return  getDateProperty(passwordChangedProperty);
    }

    public UserProfile getProfile() {
        return  getResourceProperty(profileProperty);
    }

    public User setProfile(UserProfile profile) {
        setProperty(profileProperty, profile);
        return this;
    }

    public UserStatus getStatus() {
        return  getEnumProperty(statusProperty);
    }

    public Date getStatusChanged() {
        return  getDateProperty(statusChangedProperty);
    }

    public UserStatus getTransitioningToStatus() {
        return  getEnumProperty(transitioningToStatusProperty);
    }

    public UserType getType() {
        return  getResourceProperty(typeProperty);
    }

    public User setType(UserType type) {
        setProperty(typeProperty, type);
        return this;
    }


    /**
    * Listing IdPs associated with a user
    * Lists the IdPs associated with the user.
    * @return IdentityProviderList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/idps")
    public IdentityProviderList listIdentityProviders() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/idps",
            IdentityProviderList.class,
            queryArgs,
            headers);
    }




    /**
    * Deactivate User
    * Deactivates a user. This operation can only be performed on users that do not have a &#x60;DEPROVISIONED&#x60; status. While the asynchronous operation (triggered by HTTP header &#x60;Prefer: respond-async&#x60;) is proceeding the user&#39;s &#x60;transitioningToStatus&#x60; property is &#x60;DEPROVISIONED&#x60;. The user&#39;s status is &#x60;DEPROVISIONED&#x60; when the deactivation process is complete.
    * @param sendEmail  (optional, default to false)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/deactivate")
    public void deactivate(Boolean sendEmail) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (sendEmail != null) queryArgs.put("sendEmail", sendEmail);

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/users/" + userId + "/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }

    /**
    * Deactivate User
    * Deactivates a user. This operation can only be performed on users that do not have a &#x60;DEPROVISIONED&#x60; status. While the asynchronous operation (triggered by HTTP header &#x60;Prefer: respond-async&#x60;) is proceeding the user&#39;s &#x60;transitioningToStatus&#x60; property is &#x60;DEPROVISIONED&#x60;. The user&#39;s status is &#x60;DEPROVISIONED&#x60; when the deactivation process is complete.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/deactivate")
    public void deactivate() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/users/" + userId + "/lifecycle/deactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

     }




    /**
    * Reset Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password.  The OTT link can be automatically emailed to the user or returned to the API caller and distributed using a custom flow.
    * @param sendEmail  (required)
    * @return ResetPasswordToken
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/reset_password")
    public ResetPasswordToken resetPassword(Boolean sendEmail) {

        String userId = getId();

        notNull(sendEmail, "'sendEmail' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (sendEmail != null) queryArgs.put("sendEmail", sendEmail);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/lifecycle/reset_password",
            new DefaultVoidResource(getDataStore()),
            this,
            ResetPasswordToken.class,
            queryArgs,
            headers);

    }




    /**
    * Expire Password
    * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; and the user&#39;s password is reset to a temporary password that is returned.
    * @return TempPassword
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/expire_password?tempPassword&#x3D;true")
    public TempPassword expirePasswordAndGetTemporaryPassword() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/lifecycle/expire_password?tempPassword=true",
            new DefaultVoidResource(getDataStore()),
            this,
            TempPassword.class,
            queryArgs,
            headers);

    }




    /**
    * Enroll Factor
    * Enrolls a user with a supported factor.
    * @param body Factor (required)
    * @param updatePhone  (optional, default to false)
    * @param templateId id of SMS template (only for SMS factor) (optional)
    * @param tokenLifetimeSeconds  (optional, default to 300)
    * @param activate  (optional, default to false)
    * @return UserFactor
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/factors")
    public UserFactor enrollFactor(UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) {

        String userId = getId();

        notNull(body, "'body' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (updatePhone != null) queryArgs.put("updatePhone", updatePhone);
        if (templateId != null) queryArgs.put("templateId", templateId);
        if (tokenLifetimeSeconds != null) queryArgs.put("tokenLifetimeSeconds", tokenLifetimeSeconds);
        if (activate != null) queryArgs.put("activate", activate);

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/users/" + userId + "/factors",
            body,
            this,
            UserFactor.class,
            queryArgs,
            headers);
        return body;

    }

    /**
    * Enroll Factor
    * Enrolls a user with a supported factor.
    * @param body Factor (required)
    * @return UserFactor
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/factors")
    public UserFactor enrollFactor(UserFactor body) {

        String userId = getId();

        notNull(body, "'body' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/users/" + userId + "/factors",
            body,
            this,
            UserFactor.class,
            queryArgs,
            headers);
        return body;

     }




    /**
    * 
    * Enumerates all the enrolled factors for the specified user
    * @return UserFactorList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/factors")
    public UserFactorList listFactors() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/factors",
            UserFactorList.class,
            queryArgs,
            headers);
    }




    /**
    * Forgot Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password
    * @param sendEmail  (optional, default to true)
    * @return ForgotPasswordResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/credentials/forgot_password")
    public ForgotPasswordResponse forgotPasswordGenerateOneTimeToken(Boolean sendEmail) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (sendEmail != null) queryArgs.put("sendEmail", sendEmail);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/credentials/forgot_password",
            new DefaultVoidResource(getDataStore()),
            this,
            ForgotPasswordResponse.class,
            queryArgs,
            headers);

    }

    /**
    * Forgot Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password
    * @return ForgotPasswordResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/credentials/forgot_password")
    public ForgotPasswordResponse forgotPasswordGenerateOneTimeToken() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/credentials/forgot_password",
            new DefaultVoidResource(getDataStore()),
            this,
            ForgotPasswordResponse.class,
            queryArgs,
            headers);

     }




    /**
    * 
    * Removes all active identity provider sessions. This forces the user to authenticate on the next operation. Optionally revokes OpenID Connect and OAuth refresh and access tokens issued to the user.
    * @param oAuthTokens Revoke issued OpenID Connect and OAuth refresh and access tokens (optional, default to false)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}/sessions")
    public void clearSessions(Boolean oAuthTokens) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (oAuthTokens != null) queryArgs.put("oauthTokens", oAuthTokens);

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/sessions",
            queryArgs,
            headers);
    }

    /**
    * 
    * Removes all active identity provider sessions. This forces the user to authenticate on the next operation. Optionally revokes OpenID Connect and OAuth refresh and access tokens issued to the user.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}/sessions")
    public void clearSessions() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/sessions",
            queryArgs,
            headers);
     }




    /**
    * 
    * Success
    * @param roleId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "PUT - /api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps")
    public void addAllAppsAsTarget(String roleId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/catalog/apps";
        getDataStore().save(href, new DefaultVoidResource(getDataStore()), this, queryArgs, headers);

    }




    /**
    * Forgot Password
    * Sets a new password for a user by validating the user&#39;s answer to their current recovery question
    * @param user  (required)
    * @param sendEmail  (optional, default to true)
    * @return ForgotPasswordResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/credentials/forgot_password")
    public ForgotPasswordResponse forgotPasswordSetNewPassword(UserCredentials user, Boolean sendEmail) {

        String userId = getId();

        notNull(user, "'user' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (sendEmail != null) queryArgs.put("sendEmail", sendEmail);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/credentials/forgot_password",
            user,
            this,
            ForgotPasswordResponse.class,
            queryArgs,
            headers);

    }

    /**
    * Forgot Password
    * Sets a new password for a user by validating the user&#39;s answer to their current recovery question
    * @param user  (required)
    * @return ForgotPasswordResponse
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/credentials/forgot_password")
    public ForgotPasswordResponse forgotPasswordSetNewPassword(UserCredentials user) {

        String userId = getId();

        notNull(user, "'user' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/credentials/forgot_password",
            user,
            this,
            ForgotPasswordResponse.class,
            queryArgs,
            headers);

     }




    /**
    * 
    * Revokes all refresh tokens issued for the specified User and Client.
    * @param clientId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}/clients/{clientId}/tokens")
    public void revokeTokensForUserAndClient(String clientId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/clients/" + clientId + "/tokens",
            queryArgs,
            headers);
    }




    /**
    * Reset Factors
    * This operation resets all factors for the specified user. All MFA factor enrollments returned to the unenrolled state. The user&#39;s status remains ACTIVE. This link is present only if the user is currently enrolled in one or more MFA factors.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/reset_factors")
    public void resetFactors() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/users/" + userId + "/lifecycle/reset_factors",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Get linked objects for a user, relationshipName can be a primary or associated relationship name
    * @param relationshipName  (required)
    * @return ResponseLinksList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/linkedObjects/{relationshipName}")
    public ResponseLinksList getLinkedObjects(String relationshipName) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(relationshipName, "'relationshipName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/linkedObjects/" + relationshipName + "",
            ResponseLinksList.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Revokes all grants for a specified user
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}/grants")
    public void revokeGrants() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/grants",
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @param roleId  (required)
    * @return GroupList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/roles/{roleId}/targets/groups")
    public GroupList listGroupTargets(String roleId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups",
            GroupList.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Gets a refresh token issued for the specified User and Client.
    * @param clientId  (required)
    * @param tokenId  (required)
    * @param expand  (optional)
    * @return OAuth2RefreshToken
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/clients/{clientId}/tokens/{tokenId}")
    public OAuth2RefreshToken getRefreshTokenForUserAndClient(String clientId, String tokenId, String expand) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");
        hasText(tokenId, "'tokenId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/clients/" + clientId + "/tokens/" + tokenId + "",
            OAuth2RefreshToken.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Gets a refresh token issued for the specified User and Client.
    * @param clientId  (required)
    * @param tokenId  (required)
    * @return OAuth2RefreshToken
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/clients/{clientId}/tokens/{tokenId}")
    public OAuth2RefreshToken getRefreshTokenForUserAndClient(String clientId, String tokenId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");
        hasText(tokenId, "'tokenId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/clients/" + clientId + "/tokens/" + tokenId + "",
            OAuth2RefreshToken.class,
            queryArgs,
            headers);
     }




    /**
    * 
    * Revokes all grants for the specified user and client
    * @param clientId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}/clients/{clientId}/grants")
    public void revokeGrantsForUserAndClient(String clientId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/clients/" + clientId + "/grants",
            queryArgs,
            headers);
    }




    /**
    * 
    * Unassigns a role from a user.
    * @param roleId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}/roles/{roleId}")
    public void removeRole(String roleId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/roles/" + roleId + "",
            queryArgs,
            headers);
    }




    /**
    * 
    * Revokes the specified refresh token.
    * @param clientId  (required)
    * @param tokenId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}/clients/{clientId}/tokens/{tokenId}")
    public void revokeTokenForUserAndClient(String clientId, String tokenId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");
        hasText(tokenId, "'tokenId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/clients/" + clientId + "/tokens/" + tokenId + "",
            queryArgs,
            headers);
    }




    /**
    * Expire Password
    * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; so that the user is required to change their password at their next login.
    * @return User
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/expire_password?tempPassword&#x3D;false")
    public User expirePassword() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/lifecycle/expire_password?tempPassword=false",
            new DefaultVoidResource(getDataStore()),
            this,
            User.class,
            queryArgs,
            headers);

    }




    /**
    * Activate User
    * Activates a user.  This operation can only be performed on users with a &#x60;STAGED&#x60; status.  Activation of a user is an asynchronous operation. The user will have the &#x60;transitioningToStatus&#x60; property with a value of &#x60;ACTIVE&#x60; during activation to indicate that the user hasn&#39;t completed the asynchronous operation.  The user will have a status of &#x60;ACTIVE&#x60; when the activation process is complete.
    * @param sendEmail Sends an activation email to the user if true (required)
    * @return UserActivationToken
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/activate")
    public UserActivationToken activate(Boolean sendEmail) {

        String userId = getId();

        notNull(sendEmail, "'sendEmail' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (sendEmail != null) queryArgs.put("sendEmail", sendEmail);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/lifecycle/activate",
            new DefaultVoidResource(getDataStore()),
            this,
            UserActivationToken.class,
            queryArgs,
            headers);

    }




    /**
    * Change Recovery Question
    * Changes a user&#39;s recovery question &amp; answer credential by validating the user&#39;s current password.  This operation can only be performed on users in **STAGED**, **ACTIVE** or **RECOVERY** &#x60;status&#x60; that have a valid password credential
    * @param userCredentials  (required)
    * @return UserCredentials
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/credentials/change_recovery_question")
    public UserCredentials changeRecoveryQuestion(UserCredentials userCredentials) {

        String userId = getId();

        notNull(userCredentials, "'userCredentials' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/users/" + userId + "/credentials/change_recovery_question",
            userCredentials,
            this,
            UserCredentials.class,
            queryArgs,
            headers);
        return userCredentials;

    }




    /**
    * 
    * Lists all grants for the specified user
    * @param scopeId  (optional)
    * @param expand  (optional)
    * @return OAuth2ScopeConsentGrantList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/grants")
    public OAuth2ScopeConsentGrantList listGrants(String scopeId, String expand) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (scopeId != null) queryArgs.put("scopeId", scopeId);
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/grants",
            OAuth2ScopeConsentGrantList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Lists all grants for the specified user
    * @return OAuth2ScopeConsentGrantList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/grants")
    public OAuth2ScopeConsentGrantList listGrants() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/grants",
            OAuth2ScopeConsentGrantList.class,
            queryArgs,
            headers);
     }




    /**
    * Unsuspend User
    * Unsuspends a user and returns them to the &#x60;ACTIVE&#x60; state.  This operation can only be performed on users that have a &#x60;SUSPENDED&#x60; status.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/unsuspend")
    public void unsuspend() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/users/" + userId + "/lifecycle/unsuspend",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Assigns a role to a user.
    * @param assignRoleRequest  (required)
    * @param disableNotifications  (optional)
    * @return Role
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/roles")
    public Role assignRole(AssignRoleRequest assignRoleRequest, Boolean disableNotifications) {

        String userId = getId();

        notNull(assignRoleRequest, "'assignRoleRequest' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (disableNotifications != null) queryArgs.put("disableNotifications", disableNotifications);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/roles",
            assignRoleRequest,
            this,
            Role.class,
            queryArgs,
            headers);

    }

    /**
    * 
    * Assigns a role to a user.
    * @param assignRoleRequest  (required)
    * @return Role
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/roles")
    public Role assignRole(AssignRoleRequest assignRoleRequest) {

        String userId = getId();

        notNull(assignRoleRequest, "'assignRoleRequest' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/roles",
            assignRoleRequest,
            this,
            Role.class,
            queryArgs,
            headers);

     }




    /**
    * 
    * Gets role that is assigne to user.
    * @param roleId  (required)
    * @return Role
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/roles/{roleId}")
    public Role getRole(String roleId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/roles/" + roleId + "",
            Role.class,
            queryArgs,
            headers);
    }




    /**
    * Get Member Groups
    * Fetches the groups of which the user is a member.
    * @return GroupList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/groups")
    public GroupList listGroups() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/groups",
            GroupList.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Lists all refresh tokens issued for the specified User and Client.
    * @param clientId  (required)
    * @param expand  (optional)
    * @return OAuth2RefreshTokenList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/clients/{clientId}/tokens")
    public OAuth2RefreshTokenList listRefreshTokensForUserAndClient(String clientId, String expand) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/clients/" + clientId + "/tokens",
            OAuth2RefreshTokenList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Lists all refresh tokens issued for the specified User and Client.
    * @param clientId  (required)
    * @return OAuth2RefreshTokenList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/clients/{clientId}/tokens")
    public OAuth2RefreshTokenList listRefreshTokensForUserAndClient(String clientId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(clientId, "'clientId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/clients/" + clientId + "/tokens",
            OAuth2RefreshTokenList.class,
            queryArgs,
            headers);
     }




    /**
    * 
    * Success
    * @param roleId  (required)
    * @param groupId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}")
    public void removeGroupTarget(String roleId, String groupId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups/" + groupId + "",
            queryArgs,
            headers);
    }




    /**
    * 
    * Enumerates all the supported factors that can be enrolled for the specified user
    * @return UserFactorList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/factors/catalog")
    public UserFactorList listSupportedFactors() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/factors/catalog",
            UserFactorList.class,
            queryArgs,
            headers);
    }




    /**
    * Delete User
    * Deletes a user permanently.  This operation can only be performed on users that have a &#x60;DEPROVISIONED&#x60; status.  **This action cannot be recovered!**
    * @param sendEmail  (optional, default to false)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}")
    public void delete(Boolean sendEmail) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (sendEmail != null) queryArgs.put("sendEmail", sendEmail);

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "",
            (Resource) this,
            queryArgs,
            headers);
    }

    /**
    * Delete User
    * Deletes a user permanently.  This operation can only be performed on users that have a &#x60;DEPROVISIONED&#x60; status.  **This action cannot be recovered!**
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}")
    public void delete() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "",
            (Resource) this,
            queryArgs,
            headers);
     }




    /**
    * 
    * Lists all client resources for which the specified user has grants or tokens.
    * @return OAuth2ClientList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/clients")
    public OAuth2ClientList listClients() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/clients",
            OAuth2ClientList.class,
            queryArgs,
            headers);
    }




    /**
    * Suspend User
    * Suspends a user.  This operation can only be performed on users with an &#x60;ACTIVE&#x60; status.  The user will have a status of &#x60;SUSPENDED&#x60; when the process is complete.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/suspend")
    public void suspend() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/users/" + userId + "/lifecycle/suspend",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * 
    * Revokes one grant for a specified user
    * @param grantId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}/grants/{grantId}")
    public void revokeGrant(String grantId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(grantId, "'grantId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/grants/" + grantId + "",
            queryArgs,
            headers);
    }




    /**
    * 
    * 
    * @param primaryRelationshipName  (required)
    * @param primaryUserId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "PUT - /api/v1/users/{associatedUserId}/linkedObjects/{primaryRelationshipName}/{primaryUserId}")
    public void setLinkedObject(String primaryRelationshipName, String primaryUserId) {

        String associatedUserId = getId();

        hasText(associatedUserId, "'associatedUserId' is required and cannot be null or empty.");
        hasText(primaryRelationshipName, "'primaryRelationshipName' is required and cannot be null or empty.");
        hasText(primaryUserId, "'primaryUserId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/users/" + associatedUserId + "/linkedObjects/" + primaryRelationshipName + "/" + primaryUserId + "";
        getDataStore().save(href, new DefaultVoidResource(getDataStore()), this, queryArgs, headers);

    }




    /**
    * 
    * Delete linked objects for a user, relationshipName can be ONLY a primary relationship name
    * @param relationshipName  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}/linkedObjects/{relationshipName}")
    public void removeLinkedObject(String relationshipName) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(relationshipName, "'relationshipName' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/linkedObjects/" + relationshipName + "",
            queryArgs,
            headers);
    }




    /**
    * Unlock User
    * Unlocks a user with a &#x60;LOCKED_OUT&#x60; status and returns them to &#x60;ACTIVE&#x60; status.  Users will be able to login with their current password.
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/unlock")
    public void unlock() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().create(
            "/api/v1/users/" + userId + "/lifecycle/unlock",
            new DefaultVoidResource(getDataStore()),
            this,
            VoidResource.class,
            queryArgs,
            headers);

    }




    /**
    * Update User
    * Update a user&#39;s profile and/or credentials using strict-update semantics.
    * @param strict  (optional)
    * @return User
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "PUT - /api/v1/users/{userId}")
    public User update(Boolean strict) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (strict != null) queryArgs.put("strict", strict);

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/users/" + userId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

    }

    /**
    * Update User
    * Update a user&#39;s profile and/or credentials using strict-update semantics.
    * @return User
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "PUT - /api/v1/users/{userId}")
    public User update() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        
        String href = "/api/v1/users/" + userId + "";
        getDataStore().save(href, this, null, queryArgs, headers);
        return this;

     }




    /**
    * 
    * Unenrolls an existing factor for the specified user, allowing the user to enroll a new factor.
    * @param factorId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "DELETE - /api/v1/users/{userId}/factors/{factorId}")
    public void deleteFactor(String factorId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        getDataStore().delete(
            "/api/v1/users/" + userId + "/factors/" + factorId + "",
            queryArgs,
            headers);
    }




    /**
    * Reactivate User
    * Reactivates a user.  This operation can only be performed on users with a &#x60;PROVISIONED&#x60; status.  This operation restarts the activation workflow if for some reason the user activation was not completed when using the activationToken from [Activate User](#activate-user).
    * @param sendEmail Sends an activation email to the user if true (optional, default to false)
    * @return UserActivationToken
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/reactivate")
    public UserActivationToken reactivate(Boolean sendEmail) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (sendEmail != null) queryArgs.put("sendEmail", sendEmail);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/lifecycle/reactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            UserActivationToken.class,
            queryArgs,
            headers);

    }

    /**
    * Reactivate User
    * Reactivates a user.  This operation can only be performed on users with a &#x60;PROVISIONED&#x60; status.  This operation restarts the activation workflow if for some reason the user activation was not completed when using the activationToken from [Activate User](#activate-user).
    * @return UserActivationToken
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/lifecycle/reactivate")
    public UserActivationToken reactivate() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/lifecycle/reactivate",
            new DefaultVoidResource(getDataStore()),
            this,
            UserActivationToken.class,
            queryArgs,
            headers);

     }




    /**
    * 
    * Fetches a factor for the specified user
    * @param factorId  (required)
    * @return UserFactor
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/factors/{factorId}")
    public UserFactor getFactor(String factorId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(factorId, "'factorId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/factors/" + factorId + "",
            UserFactor.class,
            queryArgs,
            headers);
    }




    /**
    * Change Password
    * Changes a user&#39;s password by validating the user&#39;s current password. This operation can only be performed on users in &#x60;STAGED&#x60;, &#x60;ACTIVE&#x60;, &#x60;PASSWORD_EXPIRED&#x60;, or &#x60;RECOVERY&#x60; status that have a valid password credential
    * @param changePasswordRequest  (required)
    * @param strict  (optional)
    * @return UserCredentials
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/credentials/change_password")
    public UserCredentials changePassword(ChangePasswordRequest changePasswordRequest, Boolean strict) {

        String userId = getId();

        notNull(changePasswordRequest, "'changePasswordRequest' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (strict != null) queryArgs.put("strict", strict);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/credentials/change_password",
            changePasswordRequest,
            this,
            UserCredentials.class,
            queryArgs,
            headers);

    }

    /**
    * Change Password
    * Changes a user&#39;s password by validating the user&#39;s current password. This operation can only be performed on users in &#x60;STAGED&#x60;, &#x60;ACTIVE&#x60;, &#x60;PASSWORD_EXPIRED&#x60;, or &#x60;RECOVERY&#x60; status that have a valid password credential
    * @param changePasswordRequest  (required)
    * @return UserCredentials
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "POST - /api/v1/users/{userId}/credentials/change_password")
    public UserCredentials changePassword(ChangePasswordRequest changePasswordRequest) {

        String userId = getId();

        notNull(changePasswordRequest, "'changePasswordRequest' is required and cannot be null.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().create(
            "/api/v1/users/" + userId + "/credentials/change_password",
            changePasswordRequest,
            this,
            UserCredentials.class,
            queryArgs,
            headers);

     }




    /**
    * Get Assigned App Links
    * Fetches appLinks for all direct or indirect (via group membership) assigned applications.
    * @return AppLinkList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/appLinks")
    public AppLinkList listAppLinks() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/appLinks",
            AppLinkList.class,
            queryArgs,
            headers);
    }




    /**
    * 
    * Success
    * @param roleId  (required)
    * @param groupId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "PUT - /api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}")
    public void addGroupTarget(String roleId, String groupId) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");
        hasText(roleId, "'roleId' is required and cannot be null or empty.");
        hasText(groupId, "'groupId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/users/" + userId + "/roles/" + roleId + "/targets/groups/" + groupId + "";
        getDataStore().save(href, new DefaultVoidResource(getDataStore()), this, queryArgs, headers);

    }




    /**
    * 
    * Enumerates all available security questions for a user&#39;s &#x60;question&#x60; factor
    * @return SecurityQuestionList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/factors/questions")
    public SecurityQuestionList listSupportedSecurityQuestions() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/factors/questions",
            SecurityQuestionList.class,
            queryArgs,
            headers);
    }




    /**
    * Add User to Group
    * Adds a user to a group with &#39;OKTA_GROUP&#39; type.
    * @param groupId  (required)
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "PUT - /api/v1/groups/{groupId}/users/{userId}")
    public void addToGroup(String groupId) {

        String userId = getId();

        hasText(groupId, "'groupId' is required and cannot be null or empty.");
        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();


        String href = "/api/v1/groups/" + groupId + "/users/" + userId + "";
        getDataStore().save(href, new DefaultVoidResource(getDataStore()), this, queryArgs, headers);

    }




    /**
    * 
    * Lists all roles assigned to a user.
    * @param expand  (optional)
    * @return RoleList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/roles")
    public RoleList listAssignedRoles(String expand) {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();
        if (expand != null) queryArgs.put("expand", expand);

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/roles",
            RoleList.class,
            queryArgs,
            headers);
    }

    /**
    * 
    * Lists all roles assigned to a user.
    * @return RoleList
    */
    @Override
    @javax.annotation.Generated(
          value    = "com.okta.swagger.codegen.OktaJavaClientImplCodegen",
          date     = "2023-07-07T08:50:42.885-05:00",
          comments = "GET - /api/v1/users/{userId}/roles")
    public RoleList listAssignedRoles() {

        String userId = getId();

        hasText(userId, "'userId' is required and cannot be null or empty.");

        Map<String, Object> queryArgs = new HashMap<>();

        HttpHeaders headers = new HttpHeaders();

        return getDataStore().getResource(
            "/api/v1/users/" + userId + "/roles",
            RoleList.class,
            queryArgs,
            headers);
     }



}
