/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.application;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.MapProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.application.AppUser;
import com.okta.sdk.resource.application.AppUserCredentials;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultAppUser
extends AbstractInstanceResource<AppUser>
implements AppUser {
    private static final MapProperty embeddedProperty = new MapProperty("_embedded");
    private static final MapProperty linksProperty = new MapProperty("_links");
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final ResourceReference<AppUserCredentials> credentialsProperty = new ResourceReference<AppUserCredentials>("credentials", AppUserCredentials.class, false);
    private static final StringProperty externalIdProperty = new StringProperty("externalId");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastSyncProperty = new DateProperty("lastSync");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final DateProperty passwordChangedProperty = new DateProperty("passwordChanged");
    private static final MapProperty profileProperty = new MapProperty("profile");
    private static final StringProperty scopeProperty = new StringProperty("scope");
    private static final StringProperty statusProperty = new StringProperty("status");
    private static final DateProperty statusChangedProperty = new DateProperty("statusChanged");
    private static final StringProperty syncStateProperty = new StringProperty("syncState");
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultAppUser.createPropertyDescriptorMap(embeddedProperty, linksProperty, createdProperty, credentialsProperty, externalIdProperty, idProperty, lastSyncProperty, lastUpdatedProperty, passwordChangedProperty, profileProperty, scopeProperty, statusProperty, statusChangedProperty, syncStateProperty);

    public DefaultAppUser(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultAppUser(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return AppUser.class;
    }

    public Map<String, Object> getEmbedded() {
        return this.getMap(embeddedProperty);
    }

    public Map<String, Object> getLinks() {
        return this.getMap(linksProperty);
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public AppUserCredentials getCredentials() {
        return this.getResourceProperty(credentialsProperty);
    }

    public AppUser setCredentials(AppUserCredentials credentials) {
        this.setProperty(credentialsProperty, (Object)credentials);
        return this;
    }

    public String getExternalId() {
        return this.getString(externalIdProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public AppUser setId(String id) {
        this.setProperty(idProperty, (Object)id);
        return this;
    }

    public Date getLastSync() {
        return this.getDateProperty(lastSyncProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public Date getPasswordChanged() {
        return this.getDateProperty(passwordChangedProperty);
    }

    public Map<String, Object> getProfile() {
        return this.getMap(profileProperty);
    }

    public AppUser setProfile(Map<String, Object> profile) {
        this.setProperty(profileProperty, profile);
        return this;
    }

    public String getScope() {
        return this.getString(scopeProperty);
    }

    public AppUser setScope(String scope) {
        this.setProperty(scopeProperty, (Object)scope);
        return this;
    }

    public String getStatus() {
        return this.getString(statusProperty);
    }

    public Date getStatusChanged() {
        return this.getDateProperty(statusChangedProperty);
    }

    public String getSyncState() {
        return this.getString(syncStateProperty);
    }

    public AppUser update() {
        String userId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/apps/{appId}/users/{userId}");
        String appId = pathArgs.get("appId");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        DefaultAppUser appUser = this;
        this.getDataStore().create("/api/v1/apps/" + appId + "/users/" + userId + "", this, this, AppUser.class, queryArgs, (Map<String, List<String>>)headers);
        return appUser;
    }

    public void delete(Boolean sendEmail) {
        String userId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/apps/{appId}/users/{userId}");
        String appId = pathArgs.get("appId");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        if (sendEmail != null) {
            queryArgs.put("sendEmail", sendEmail);
        }
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "/users/" + userId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }

    @Override
    public void delete() {
        String userId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/apps/{appId}/users/{userId}");
        String appId = pathArgs.get("appId");
        Assert.hasText((String)appId, (String)"'appId' is required and cannot be null or empty.");
        Assert.hasText((String)userId, (String)"'userId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/apps/" + appId + "/users/" + userId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }
}

