/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.config;

import com.okta.commons.configcheck.ConfigurationValidator;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@ConfigurationProperties(value="okta.oauth2")
public class OktaOAuth2Properties
implements Validator {
    private String redirectUri = "/login";
    private String customLoginRoute;
    private String clientId;
    private String clientSecret;
    private String discoveryUri;
    private String issuer;
    private String audience = "api://default";
    private String scopeClaim = "scp";
    private String rolesClaim = "groups";
    private List<String> scopes = Arrays.asList("openid", "profile", "email");
    private String principalClaim = "email";

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getScopeClaim() {
        return this.scopeClaim;
    }

    public void setScopeClaim(String scopeClaim) {
        this.scopeClaim = scopeClaim;
    }

    public String getRolesClaim() {
        return this.rolesClaim;
    }

    public void setRolesClaim(String rolesClaim) {
        this.rolesClaim = rolesClaim;
    }

    public String getDiscoveryUri() {
        return this.discoveryUri;
    }

    public void setDiscoveryUri(String discoveryUri) {
        this.discoveryUri = discoveryUri;
    }

    public String getPrincipalClaim() {
        return this.principalClaim;
    }

    public void setPrincipalClaim(String principalClaim) {
        this.principalClaim = principalClaim;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getCustomLoginRoute() {
        return this.customLoginRoute;
    }

    public void setCustomLoginRoute(String customLoginRoute) {
        this.customLoginRoute = customLoginRoute;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public boolean supports(Class<?> clazz) {
        return OktaOAuth2Properties.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        OktaOAuth2Properties properties = (OktaOAuth2Properties)target;
        if (properties.getIssuer() != null) {
            ConfigurationValidator.validateIssuer((String)properties.getIssuer()).ifInvalid(res -> errors.rejectValue("issuer", res.getMessage()));
        }
        if (properties.getClientId() != null) {
            ConfigurationValidator.validateClientId((String)properties.getClientId()).ifInvalid(res -> errors.rejectValue("clientId", res.getMessage()));
        }
        if (properties.getClientSecret() != null) {
            ConfigurationValidator.validateClientSecret((String)properties.getClientSecret()).ifInvalid(res -> errors.rejectValue("clientSecret", res.getMessage()));
        }
    }
}

